/*
 * Decompiled with CFR 0.152.
 */
package org.cyclopsgroup.jcli;

import org.cyclopsgroup.jcli.StringTokenizer;

public class QuotedStringTokenizer
extends StringTokenizer {
    private final char delimiter;
    private final char quotation;

    public QuotedStringTokenizer() {
        this(' ', '\"');
    }

    public QuotedStringTokenizer(char delimiter, char quotation) {
        this.delimiter = delimiter;
        this.quotation = quotation;
    }

    public String escape(String value) {
        if (value == null) {
            return null;
        }
        if (value.indexOf(this.delimiter) == -1 && value.indexOf(this.quotation) == -1) {
            return value;
        }
        if (value.indexOf(this.quotation) == -1) {
            return this.quotation + value + this.quotation;
        }
        return this.quotation + value.replaceAll("\\" + this.quotation, "\\" + this.quotation + "\\" + this.quotation) + this.quotation;
    }

    public void parse(String input, StringTokenizer.TokenEventHandler handler) {
        ParsingState state = ParsingState.READY;
        StringBuilder buf = null;
        int wordStart = 0;
        block6: for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            switch (state) {
                case READY: {
                    assert (buf == null);
                    if (c == this.delimiter) continue block6;
                    if (c == this.quotation) {
                        state = ParsingState.QUOTED;
                        wordStart = i;
                        buf = new StringBuilder();
                        continue block6;
                    }
                    state = ParsingState.WORD_STARTED;
                    wordStart = i;
                    buf = new StringBuilder();
                    buf.append(c);
                    continue block6;
                }
                case WORD_STARTED: {
                    assert (buf != null);
                    if (c == this.delimiter) {
                        state = ParsingState.READY;
                        handler.handleWordEvent(buf.toString(), wordStart, i, true);
                        buf = null;
                        continue block6;
                    }
                    buf.append(c);
                    continue block6;
                }
                case QUOTED: {
                    assert (buf != null);
                    if (c == this.quotation) {
                        state = ParsingState.ESCAPED_OR_QUOTE_END;
                        continue block6;
                    }
                    buf.append(c);
                    continue block6;
                }
                case ESCAPED_OR_QUOTE_END: {
                    assert (buf != null);
                    if (c == this.delimiter) {
                        state = ParsingState.READY;
                        handler.handleWordEvent(buf.toString(), wordStart, i, true);
                        buf = null;
                        continue block6;
                    }
                    buf.append(c);
                    state = ParsingState.QUOTED;
                }
            }
        }
        if (buf != null) {
            handler.handleWordEvent(buf.toString(), wordStart, input.length(), false);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ParsingState {
        ESCAPED_OR_QUOTE_END,
        QUOTED,
        READY,
        WORD_STARTED;

    }
}

