/*
 * Decompiled with CFR 0.152.
 */
package org.cyclopsgroup.jcli;

import org.apache.commons.lang.Validate;
import org.cyclopsgroup.jcli.StringTokenizer;

public class EscapedStringTokenizer
extends StringTokenizer {
    private final char delimiter;
    private final String delimiterString;
    private final char escaper;
    private final String replacementString;

    public EscapedStringTokenizer() {
        this(' ', '\\');
    }

    public EscapedStringTokenizer(char delimiter, char escaper) {
        Validate.isTrue((delimiter != escaper ? 1 : 0) != 0, (String)"Delimiter can't be the same as escaper");
        this.delimiter = delimiter;
        this.escaper = escaper;
        this.delimiterString = "" + delimiter;
        this.replacementString = escaper + this.delimiterString;
    }

    public String escape(String value) {
        if (value == null || value.indexOf(this.delimiter) == -1) {
            return value;
        }
        return value.replace(this.delimiterString, this.replacementString);
    }

    public void parse(String input, StringTokenizer.TokenEventHandler handler) {
        ProcessingState state = ProcessingState.READY;
        StringBuilder word = null;
        int wordStart = 0;
        block5: for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            switch (state) {
                case READY: {
                    if (c == this.delimiter) continue block5;
                    wordStart = i;
                    word = new StringBuilder();
                    if (c == this.escaper) {
                        state = ProcessingState.ESCAPING;
                        continue block5;
                    }
                    state = ProcessingState.WORD;
                    word.append(c);
                    continue block5;
                }
                case WORD: {
                    if (c == this.delimiter) {
                        state = ProcessingState.READY;
                        handler.handleWordEvent(word.toString(), wordStart, i, true);
                        word = null;
                        continue block5;
                    }
                    if (c == this.escaper) {
                        state = ProcessingState.ESCAPING;
                        continue block5;
                    }
                    word.append(c);
                    continue block5;
                }
                case ESCAPING: {
                    state = ProcessingState.WORD;
                    word.append(c);
                }
            }
        }
        if (word != null) {
            handler.handleWordEvent(word.toString(), wordStart, input.length(), false);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ProcessingState {
        ESCAPING,
        READY,
        WORD;

    }
}

