/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.util.serializer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.fasterxml.jackson.dataformat.xml.ser.ToXmlGenerator;
import java.io.IOException;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.cyclonedx.model.Dependency;
import org.cyclonedx.model.DependencyList;

public class DependencySerializer
extends StdSerializer<DependencyList>
implements ContextualSerializer {
    private final String REF = "ref";
    private boolean useNamespace;
    private final String parentTagName;

    public DependencySerializer(boolean useNamespace, String parentTagName) {
        super(DependencyList.class, false);
        this.useNamespace = useNamespace;
        this.parentTagName = parentTagName;
    }

    public DependencySerializer() {
        this(false, null);
    }

    public DependencySerializer(Class<DependencyList> t, String parentTagName) {
        super(t);
        this.parentTagName = parentTagName;
    }

    public JsonSerializer<?> createContextual(SerializerProvider prov, BeanProperty property) {
        return new DependencySerializer(this.useNamespace, property.getName());
    }

    public void serialize(DependencyList dependencies, JsonGenerator generator, SerializerProvider provider) throws IOException {
        try {
            if (generator instanceof ToXmlGenerator) {
                this.writeXMLDependenciesWithGenerator((ToXmlGenerator)generator, dependencies);
            } else {
                this.writeJSONDependenciesWithGenerator(generator, dependencies);
            }
        }
        catch (IOException | XMLStreamException ex) {
            throw new IOException(ex);
        }
    }

    private void writeJSONDependenciesWithGenerator(JsonGenerator generator, List<Dependency> dependencies) throws IOException {
        if (dependencies != null) {
            generator.writeStartArray();
            if (!dependencies.isEmpty()) {
                for (Dependency dependency : dependencies) {
                    generator.writeStartObject();
                    generator.writeStringField("ref", dependency.getRef());
                    generator.writeArrayFieldStart("dependsOn");
                    if (CollectionUtils.isNotEmpty(dependency.getDependencies())) {
                        for (Dependency subDependency : dependency.getDependencies()) {
                            generator.writeString(subDependency.getRef());
                        }
                    }
                    generator.writeEndArray();
                    generator.writeEndObject();
                }
            }
            generator.writeEndArray();
        }
    }

    private void writeXMLDependenciesWithGenerator(ToXmlGenerator toXmlGenerator, List<Dependency> dependencies) throws IOException, XMLStreamException {
        if (dependencies != null && !dependencies.isEmpty()) {
            this.processNamespace(toXmlGenerator, this.parentTagName);
            toXmlGenerator.writeStartArray();
            for (Dependency dependency : dependencies) {
                this.writeXMLDependency(dependency, toXmlGenerator);
            }
            toXmlGenerator.writeEndArray();
            toXmlGenerator.writeEndObject();
        }
    }

    private void writeXMLDependency(Dependency dependency, ToXmlGenerator generator) throws IOException, XMLStreamException {
        this.processNamespace(generator, "dependency");
        if (CollectionUtils.isNotEmpty(dependency.getDependencies())) {
            generator.writeStartArray();
        }
        generator.setNextIsAttribute(true);
        generator.setNextName(new QName("ref"));
        generator.writeString(dependency.getRef());
        generator.setNextIsAttribute(false);
        if (CollectionUtils.isNotEmpty(dependency.getDependencies())) {
            for (Dependency subDependency : dependency.getDependencies()) {
                this.writeXMLDependency(subDependency, generator);
            }
        }
        if (CollectionUtils.isNotEmpty(dependency.getDependencies())) {
            generator.writeEndArray();
        }
        generator.writeEndObject();
    }

    private void processNamespace(ToXmlGenerator toXmlGenerator, String dependencies) throws XMLStreamException, IOException {
        QName qName;
        String dependenciesNamespace;
        String string = dependenciesNamespace = StringUtils.isBlank((CharSequence)dependencies) ? "dependencies" : dependencies;
        if (this.useNamespace) {
            qName = new QName("http://cyclonedx.org/schema/ext/dependency-graph/1.0", dependenciesNamespace, "dg");
            toXmlGenerator.getStaxWriter().setPrefix(qName.getPrefix(), qName.getNamespaceURI());
        } else {
            qName = new QName(dependenciesNamespace);
        }
        toXmlGenerator.setNextName(qName);
        toXmlGenerator.writeStartObject();
        toXmlGenerator.writeFieldName(qName.getLocalPart());
    }
}

