/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.util.deserializer;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import org.cyclonedx.model.ExternalReference;
import org.cyclonedx.model.OrganizationalEntity;
import org.cyclonedx.model.Signature;
import org.cyclonedx.model.attestation.affirmation.Signatory;

public class SignatoryDeserializer
extends JsonDeserializer<Signatory> {
    private final ObjectMapper mapper = new ObjectMapper();

    public Signatory deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
        return this.parseSignatory(node);
    }

    private Signatory parseSignatory(JsonNode node) {
        JsonNode signatureNode;
        Signatory signatory = new Signatory();
        if (node.has("name")) {
            signatory.setName(node.get("name").asText());
        }
        if (node.has("role")) {
            signatory.setRole(node.get("role").asText());
        }
        if ((signatureNode = node.get("signature")) != null) {
            Signature signature = (Signature)this.mapper.convertValue((Object)node.get("signature"), Signature.class);
            signatory.setSignature(signature);
        } else {
            this.parseOrganizationAndReference(node, signatory);
        }
        return signatory;
    }

    private void parseOrganizationAndReference(JsonNode node, Signatory signatory) {
        JsonNode organizationNode = node.get("organization");
        JsonNode externalReferenceNode = node.get("externalReference");
        if (organizationNode != null && externalReferenceNode != null) {
            OrganizationalEntity organization = (OrganizationalEntity)this.mapper.convertValue((Object)organizationNode, OrganizationalEntity.class);
            ExternalReference externalReference = (ExternalReference)this.mapper.convertValue((Object)externalReferenceNode, ExternalReference.class);
            signatory.setExternalReferenceAndOrganization(externalReference, organization);
        }
    }
}

