/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.util.deserializer;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import org.cyclonedx.model.AttachmentText;
import org.cyclonedx.model.formulation.common.OutputType;
import org.cyclonedx.util.deserializer.AbstractDataTypeDeserializer;

public class OutputTypeDeserializer
extends AbstractDataTypeDeserializer<OutputType> {
    public OutputType deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
        OutputType outputType = new OutputType();
        this.setSourceAndTarget(node, outputType);
        this.createOutputDataInfo(node, outputType, deserializationContext, jsonParser);
        this.setProperties(node, outputType);
        if (node.has("type")) {
            JsonNode typeNode = node.get("type");
            OutputType.OutputTypeEnum type = (OutputType.OutputTypeEnum)((Object)this.objectMapper.treeToValue((TreeNode)typeNode, OutputType.OutputTypeEnum.class));
            outputType.setType(type);
        }
        return outputType;
    }

    private void createOutputDataInfo(JsonNode node, OutputType outputType, DeserializationContext ctxt, JsonParser jsonParser) throws IOException {
        if (node.has("resource")) {
            this.setResource(node, outputType);
        } else if (node.has("environmentVars")) {
            this.setEnvironmentVars(node, outputType, jsonParser, ctxt);
        } else if (node.has("data")) {
            JsonNode dataNode = node.get("data");
            AttachmentText data = (AttachmentText)this.objectMapper.treeToValue((TreeNode)dataNode, AttachmentText.class);
            outputType.setData(data);
        }
    }
}

