/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.util.deserializer;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.cyclonedx.model.OrganizationalContact;
import org.cyclonedx.model.OrganizationalEntity;
import org.cyclonedx.model.organization.PostalAddress;
import org.cyclonedx.util.deserializer.MetadataDeserializer;

public class OrganizationalEntityDeserializer
extends JsonDeserializer<OrganizationalEntity> {
    private final ObjectMapper mapper = new ObjectMapper();

    public OrganizationalEntity deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        JsonNode addressNode;
        ObjectCodec codec = jsonParser.getCodec();
        JsonNode node = (JsonNode)codec.readTree(jsonParser);
        String bomRef = node.has("bom-ref") ? node.get("bom-ref").asText() : null;
        String name = node.has("name") ? node.get("name").asText() : null;
        List<String> urls = this.parseUrls(node.get("url"));
        OrganizationalEntity entity = new OrganizationalEntity();
        entity.setBomRef(bomRef);
        entity.setName(name);
        entity.setUrls(urls);
        JsonNode contactNode = node.get("contact");
        if (contactNode != null) {
            List<OrganizationalContact> contacts = MetadataDeserializer.deserializeOrganizationalContact(contactNode, this.mapper);
            entity.setContacts(contacts);
        }
        if ((addressNode = node.get("address")) != null) {
            PostalAddress address = (PostalAddress)this.mapper.convertValue((Object)addressNode, (TypeReference)new TypeReference<PostalAddress>(){});
            entity.setAddress(address);
        }
        return entity;
    }

    private List<String> parseUrls(JsonNode urlNode) {
        ArrayList<String> urls = new ArrayList<String>();
        if (urlNode != null) {
            if (urlNode.isArray()) {
                for (JsonNode urlElement : urlNode) {
                    urls.add(urlElement.asText());
                }
            } else if (urlNode.isTextual()) {
                urls.add(urlNode.asText());
            }
        }
        return urls;
    }
}

