/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cyclonedx.Version;
import org.cyclonedx.model.Annotation;
import org.cyclonedx.model.Component;
import org.cyclonedx.model.Composition;
import org.cyclonedx.model.Dependency;
import org.cyclonedx.model.DependencyList;
import org.cyclonedx.model.ExtensibleElement;
import org.cyclonedx.model.ExternalReference;
import org.cyclonedx.model.JsonOnly;
import org.cyclonedx.model.Metadata;
import org.cyclonedx.model.Property;
import org.cyclonedx.model.Service;
import org.cyclonedx.model.Signature;
import org.cyclonedx.model.VersionFilter;
import org.cyclonedx.model.XmlOnly;
import org.cyclonedx.model.attestation.Declarations;
import org.cyclonedx.model.definition.Definition;
import org.cyclonedx.model.formulation.Formula;
import org.cyclonedx.model.vulnerability.Vulnerability;
import org.cyclonedx.util.deserializer.DependencyDeserializer;
import org.cyclonedx.util.deserializer.ExternalReferencesDeserializer;
import org.cyclonedx.util.deserializer.VulnerabilityDeserializer;

@JacksonXmlRootElement(localName="bom")
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder(value={"bomFormat", "specVersion", "serialNumber", "version", "metadata", "components", "services", "externalReferences", "dependencies", "compositions", "properties", "vulnerabilities", "annotations", "formulation", "declarations", "definitions", "signature"})
public class Bom
extends ExtensibleElement {
    @XmlOnly
    @JacksonXmlProperty(isAttribute=true)
    private String xmlns;
    @VersionFilter(value=Version.VERSION_12)
    private Metadata metadata;
    private List<Component> components;
    @VersionFilter(value=Version.VERSION_12)
    private List<Service> services;
    @VersionFilter(value=Version.VERSION_11)
    private DependencyList dependencies;
    @VersionFilter(value=Version.VERSION_11)
    private List<ExternalReference> externalReferences;
    @VersionFilter(value=Version.VERSION_13)
    private List<Composition> compositions;
    @VersionFilter(value=Version.VERSION_15)
    private List<Formula> formulation;
    @VersionFilter(value=Version.VERSION_16)
    private Definition definitions;
    @VersionFilter(value=Version.VERSION_16)
    private Declarations declarations;
    @VersionFilter(value=Version.VERSION_14)
    @JsonDeserialize(using=VulnerabilityDeserializer.class)
    private List<Vulnerability> vulnerabilities;
    @VersionFilter(value=Version.VERSION_15)
    private List<Annotation> annotations;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private List<Property> properties;
    @JacksonXmlProperty(isAttribute=true)
    private int version = 1;
    @JacksonXmlProperty(isAttribute=true)
    @VersionFilter(value=Version.VERSION_11)
    private String serialNumber;
    @JsonOnly
    private String specVersion;
    @JsonOnly
    private String bomFormat;
    @JsonOnly
    @VersionFilter(value=Version.VERSION_14)
    private Signature signature;

    public Metadata getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Metadata metadata) {
        this.metadata = metadata;
    }

    @JacksonXmlElementWrapper(localName="components")
    @JacksonXmlProperty(localName="component")
    public List<Component> getComponents() {
        return this.components;
    }

    public void setComponents(List<Component> components) {
        this.components = components;
    }

    public void addComponent(Component component) {
        if (this.components == null) {
            this.components = new ArrayList<Component>();
        }
        this.components.add(component);
    }

    @JacksonXmlElementWrapper(localName="services")
    @JacksonXmlProperty(localName="service")
    @VersionFilter(value=Version.VERSION_12)
    public List<Service> getServices() {
        return this.services;
    }

    public void setServices(List<Service> services) {
        this.services = services;
    }

    public void addService(Service service) {
        if (this.services == null) {
            this.services = new ArrayList<Service>();
        }
        this.services.add(service);
    }

    @JacksonXmlElementWrapper(useWrapping=false)
    @JsonDeserialize(using=DependencyDeserializer.class)
    @VersionFilter(value=Version.VERSION_11)
    public List<Dependency> getDependencies() {
        return this.dependencies;
    }

    public void setDependencies(List<Dependency> dependencies) {
        this.dependencies = new DependencyList(dependencies);
    }

    public void addDependency(Dependency dependency) {
        if (this.dependencies == null) {
            this.dependencies = new DependencyList(Collections.emptyList());
        }
        this.dependencies.add(dependency);
    }

    @JacksonXmlElementWrapper(localName="externalReferences")
    @JacksonXmlProperty(localName="reference")
    @JsonDeserialize(using=ExternalReferencesDeserializer.class)
    public List<ExternalReference> getExternalReferences() {
        return this.externalReferences;
    }

    public void addExternalReference(ExternalReference externalReference) {
        if (this.externalReferences == null) {
            this.externalReferences = new ArrayList<ExternalReference>();
        }
        this.externalReferences.add(externalReference);
    }

    public void setExternalReferences(List<ExternalReference> externalReferences) {
        this.externalReferences = externalReferences;
    }

    @JacksonXmlElementWrapper(localName="compositions")
    @JacksonXmlProperty(localName="composition")
    @VersionFilter(value=Version.VERSION_13)
    public List<Composition> getCompositions() {
        return this.compositions;
    }

    public void setCompositions(List<Composition> compositions) {
        this.compositions = compositions;
    }

    @JacksonXmlElementWrapper(localName="formulation")
    @JacksonXmlProperty(localName="formula")
    @VersionFilter(value=Version.VERSION_15)
    public List<Formula> getFormulation() {
        return this.formulation;
    }

    public void setFormulation(List<Formula> formulation) {
        this.formulation = formulation;
    }

    @JacksonXmlElementWrapper(localName="vulnerabilities")
    @JacksonXmlProperty(localName="vulnerability")
    @VersionFilter(value=Version.VERSION_14)
    public List<Vulnerability> getVulnerabilities() {
        return this.vulnerabilities;
    }

    public void setVulnerabilities(List<Vulnerability> vulnerabilities) {
        this.vulnerabilities = vulnerabilities;
    }

    @JacksonXmlElementWrapper(localName="annotations")
    @JacksonXmlProperty(localName="annotation")
    @VersionFilter(value=Version.VERSION_15)
    public List<Annotation> getAnnotations() {
        return this.annotations;
    }

    public void setAnnotations(List<Annotation> annotations) {
        this.annotations = annotations;
    }

    @JacksonXmlElementWrapper(localName="properties")
    @JacksonXmlProperty(localName="property")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @VersionFilter(value=Version.VERSION_13)
    public List<Property> getProperties() {
        return this.properties;
    }

    public void setProperties(List<Property> properties) {
        this.properties = properties;
    }

    public void addProperty(Property property) {
        if (this.properties == null) {
            this.properties = new ArrayList<Property>();
        }
        this.properties.add(property);
    }

    public Declarations getDeclarations() {
        return this.declarations;
    }

    public void setDeclarations(Declarations declarations) {
        this.declarations = declarations;
    }

    public Definition getDefinitions() {
        return this.definitions;
    }

    public void setDefinitions(Definition definitions) {
        this.definitions = definitions;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public void setSerialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
    }

    public String getXmlns() {
        return this.xmlns;
    }

    public void setXmlns(String xmlns) {
        this.xmlns = xmlns;
    }

    public String getSpecVersion() {
        return this.specVersion;
    }

    public String getBomFormat() {
        return this.bomFormat;
    }

    public Signature getSignature() {
        return this.signature;
    }

    public void setSignature(Signature signature) {
        this.signature = signature;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Bom bom = (Bom)o;
        return this.version == bom.version && Objects.equals(this.metadata, bom.metadata) && Objects.equals(this.components, bom.components) && Objects.equals(this.dependencies, bom.dependencies) && Objects.equals(this.externalReferences, bom.externalReferences) && Objects.equals(this.compositions, bom.compositions) && Objects.equals(this.vulnerabilities, bom.vulnerabilities) && Objects.equals(this.annotations, bom.annotations) && Objects.equals(this.properties, bom.properties) && Objects.equals(this.serialNumber, bom.serialNumber) && Objects.equals(this.specVersion, bom.specVersion);
    }

    public int hashCode() {
        return Objects.hash(this.metadata, this.components, this.dependencies, this.externalReferences, this.compositions, this.vulnerabilities, this.annotations, this.properties, this.version, this.serialNumber, this.specVersion);
    }
}

