/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.util.serializer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.fasterxml.jackson.dataformat.xml.ser.ToXmlGenerator;
import java.io.IOException;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.cyclonedx.model.attestation.affirmation.Signatory;
import org.cyclonedx.util.serializer.ExtensibleTypesSerializer;

public class SignatorySerializer
extends StdSerializer<Signatory> {
    private final boolean isXml;

    public SignatorySerializer(boolean isXml) {
        this(null, isXml);
    }

    public SignatorySerializer(Class<Signatory> t, boolean isXml) {
        super(t);
        this.isXml = isXml;
    }

    public void serialize(Signatory value, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        if (this.isXml && jsonGenerator instanceof ToXmlGenerator) {
            ToXmlGenerator xmlGenerator = (ToXmlGenerator)jsonGenerator;
            this.serializeXml(xmlGenerator, value, serializerProvider);
        } else {
            this.serializeJson(jsonGenerator, value);
        }
    }

    private void serializeXml(ToXmlGenerator gen, Signatory signatory, SerializerProvider provider) throws IOException {
        if (CollectionUtils.isNotEmpty(signatory.getExtensibleTypes())) {
            gen.writeStartObject();
            if (StringUtils.isNotBlank((CharSequence)signatory.getName())) {
                gen.writeStringField("name", signatory.getName());
            }
            if (StringUtils.isNotBlank((CharSequence)signatory.getRole())) {
                gen.writeStringField("role", signatory.getRole());
            }
            new ExtensibleTypesSerializer().serialize(signatory.getExtensibleTypes(), (JsonGenerator)gen, provider);
            gen.writeEndObject();
        }
    }

    private void serializeJson(JsonGenerator gen, Signatory signatory) throws IOException {
        boolean shouldSerialize = false;
        if (signatory.getSignature() != null && !this.isXml) {
            shouldSerialize = true;
        } else if (signatory.getExternalReference() != null && signatory.getOrganization() != null) {
            shouldSerialize = true;
        }
        if (shouldSerialize) {
            gen.writeStartObject();
            if (StringUtils.isNotBlank((CharSequence)signatory.getName())) {
                gen.writeStringField("name", signatory.getName());
            }
            if (StringUtils.isNotBlank((CharSequence)signatory.getRole())) {
                gen.writeStringField("role", signatory.getRole());
            }
            if (signatory.getSignature() != null) {
                gen.writeObjectField("signature", (Object)signatory.getSignature());
            } else if (signatory.getExternalReference() != null && signatory.getOrganization() != null) {
                gen.writeObjectField("organization", (Object)signatory.getOrganization());
                gen.writeObjectField("externalReference", (Object)signatory.getExternalReference());
            }
            gen.writeEndObject();
        }
    }

    public Class<Signatory> handledType() {
        return Signatory.class;
    }
}

