/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.util.deserializer;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import org.cyclonedx.model.OrganizationalChoice;
import org.cyclonedx.model.OrganizationalContact;
import org.cyclonedx.model.OrganizationalEntity;

public class OrganizationalChoiceDeserializer
extends JsonDeserializer<OrganizationalChoice> {
    public OrganizationalChoice deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
        OrganizationalChoice organizationalChoice = new OrganizationalChoice();
        if (node.has("individual")) {
            OrganizationalContact individual = (OrganizationalContact)jp.getCodec().treeToValue((TreeNode)node.get("individual"), OrganizationalContact.class);
            organizationalChoice.setIndividual(individual);
        } else if (node.has("organization")) {
            JsonNode organizationNode = node.get("organization");
            OrganizationalEntity organization = this.deserializeOrganization(jp, organizationNode);
            organizationalChoice.setOrganization(organization);
        }
        return organizationalChoice;
    }

    private OrganizationalEntity deserializeOrganization(JsonParser jp, JsonNode organizationNode) throws JsonProcessingException {
        OrganizationalEntity organization = new OrganizationalEntity();
        if (organizationNode.has("name")) {
            organization.setName(organizationNode.get("name").asText());
        }
        if (organizationNode.has("contact")) {
            JsonNode contactsNode = organizationNode.get("contact");
            if (contactsNode.isArray()) {
                for (JsonNode contactNode : contactsNode) {
                    this.addContactToOrganization(jp, organization, contactNode);
                }
            } else if (contactsNode.isObject()) {
                this.addContactToOrganization(jp, organization, contactsNode);
            }
        }
        return organization;
    }

    private void addContactToOrganization(JsonParser jp, OrganizationalEntity organization, JsonNode node) throws JsonProcessingException {
        OrganizationalContact contact = (OrganizationalContact)jp.getCodec().treeToValue((TreeNode)node, OrganizationalContact.class);
        organization.addContact(contact);
    }
}

