/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.synonym.analysis;

import java.io.IOException;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.core.LowerCaseFilter;
import org.apache.lucene.analysis.core.WhitespaceTokenizer;
import org.codelibs.elasticsearch.synonym.analysis.SynonymFilter;
import org.codelibs.elasticsearch.synonym.analysis.SynonymLoader;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.analysis.AbstractTokenFilterFactory;
import org.elasticsearch.index.analysis.AnalysisRegistry;
import org.elasticsearch.index.analysis.TokenizerFactory;
import org.elasticsearch.indices.analysis.AnalysisModule;

public class SynonymTokenFilterFactory
extends AbstractTokenFilterFactory {
    private final boolean ignoreCase;
    private SynonymLoader synonymLoader = null;

    public SynonymTokenFilterFactory(IndexSettings indexSettings, Environment environment, String name, Settings settings, AnalysisRegistry analysisRegistry) throws IOException {
        super(indexSettings, name, settings);
        this.ignoreCase = settings.getAsBoolean("ignore_case", Boolean.valueOf(false));
        boolean expand = settings.getAsBoolean("expand", Boolean.valueOf(true));
        String tokenizerName = settings.get("tokenizer", "whitespace");
        AnalysisModule.AnalysisProvider tokenizerFactoryFactory = null;
        if (analysisRegistry != null && (tokenizerFactoryFactory = analysisRegistry.getTokenizerProvider(tokenizerName, indexSettings)) == null) {
            throw new IllegalArgumentException("failed to find tokenizer [" + tokenizerName + "] for synonym token filter");
        }
        final TokenizerFactory tokenizerFactory = tokenizerFactoryFactory == null ? null : (TokenizerFactory)tokenizerFactoryFactory.get(indexSettings, environment, tokenizerName, AnalysisRegistry.getSettingsFromIndexSettings((IndexSettings)indexSettings, (String)("index.analysis.tokenizer." + tokenizerName)));
        Analyzer analyzer = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                WhitespaceTokenizer tokenizer = tokenizerFactory == null ? new WhitespaceTokenizer() : tokenizerFactory.create();
                WhitespaceTokenizer stream = SynonymTokenFilterFactory.this.ignoreCase ? new LowerCaseFilter((TokenStream)tokenizer) : tokenizer;
                return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)stream);
            }
        };
        this.synonymLoader = new SynonymLoader(environment, settings, expand, analyzer);
        if (this.synonymLoader.getSynonymMap() == null) {
            if (settings.getAsList("synonyms", null) != null) {
                this.logger.warn("synonyms values are empty.");
            } else if (settings.get("synonyms_path") != null) {
                this.logger.warn("synonyms_path[{}] is empty.", (Object)settings.get("synonyms_path"));
            } else {
                throw new IllegalArgumentException("synonym requires either `synonyms` or `synonyms_path` to be configured");
            }
        }
    }

    public TokenStream create(TokenStream tokenStream) {
        return this.synonymLoader == null ? tokenStream : new SynonymFilter(tokenStream, this.synonymLoader, this.ignoreCase);
    }
}

