/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.synonym;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.codelibs.elasticsearch.synonym.analysis.NGramSynonymTokenizerFactory;
import org.codelibs.elasticsearch.synonym.analysis.SynonymTokenFilterFactory;
import org.codelibs.elasticsearch.synonym.service.SynonymAnalysisService;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.component.LifecycleComponent;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.env.Environment;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.analysis.AnalysisRegistry;
import org.elasticsearch.index.analysis.TokenFilterFactory;
import org.elasticsearch.index.analysis.TokenizerFactory;
import org.elasticsearch.indices.analysis.AnalysisModule;
import org.elasticsearch.plugins.AnalysisPlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.watcher.ResourceWatcherService;

public class SynonymPlugin
extends Plugin
implements AnalysisPlugin {
    private final PluginComponent pluginComponent = new PluginComponent();

    public Collection<Class<? extends LifecycleComponent>> getGuiceServiceClasses() {
        return Collections.singletonList(SynonymAnalysisService.class);
    }

    public Collection<Object> createComponents(Client client, ClusterService clusterService, ThreadPool threadPool, ResourceWatcherService resourceWatcherService, ScriptService scriptService, NamedXContentRegistry xContentRegistry, Environment environment, NodeEnvironment nodeEnvironment, NamedWriteableRegistry namedWriteableRegistry) {
        ArrayList<Object> components = new ArrayList<Object>();
        components.add(this.pluginComponent);
        return components;
    }

    public Map<String, AnalysisModule.AnalysisProvider<TokenFilterFactory>> getTokenFilters() {
        HashMap<String, AnalysisModule.AnalysisProvider<TokenFilterFactory>> extra = new HashMap<String, AnalysisModule.AnalysisProvider<TokenFilterFactory>>();
        extra.put("synonym_filter", new AnalysisModule.AnalysisProvider<TokenFilterFactory>(){

            public TokenFilterFactory get(IndexSettings indexSettings, Environment environment, String name, Settings settings) throws IOException {
                return new SynonymTokenFilterFactory(indexSettings, environment, name, settings, SynonymPlugin.this.pluginComponent.getAnalysisRegistry());
            }

            public boolean requiresAnalysisSettings() {
                return true;
            }
        });
        return extra;
    }

    public Map<String, AnalysisModule.AnalysisProvider<TokenizerFactory>> getTokenizers() {
        return Collections.singletonMap("ngram_synonym", NGramSynonymTokenizerFactory::new);
    }

    public static class PluginComponent {
        private AnalysisRegistry analysisRegistry;

        public AnalysisRegistry getAnalysisRegistry() {
            return this.analysisRegistry;
        }

        public void setAnalysisRegistry(AnalysisRegistry analysisRegistry) {
            this.analysisRegistry = analysisRegistry;
        }
    }
}

