/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.gen.jsr181;

import com.sun.codemodel.ClassType;
import com.sun.codemodel.JAnnotationUse;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JVar;
import java.util.ArrayList;
import java.util.List;
import javax.jws.Oneway;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.jws.WebService;
import javax.xml.namespace.QName;
import org.codehaus.xfire.gen.GenerationContext;
import org.codehaus.xfire.gen.jsr181.AbstractServiceGenerator;
import org.codehaus.xfire.service.Binding;
import org.codehaus.xfire.service.MessagePartInfo;
import org.codehaus.xfire.service.OperationInfo;
import org.codehaus.xfire.service.Service;
import org.codehaus.xfire.service.ServiceInfo;
import org.codehaus.xfire.soap.AbstractSoapBinding;

public class ServiceInterfaceGenerator
extends AbstractServiceGenerator {
    public static final String SERVICE_INTERFACE = "service.interface";
    private JAnnotationUse wpann;
    private JAnnotationUse wmAnn;
    private List<ServiceInfo> serviceInfos = new ArrayList<ServiceInfo>();

    public void generate(GenerationContext context, Service service) throws Exception {
        if (service.getEndpoints().size() == 0) {
            return;
        }
        super.generate(context, service);
    }

    protected boolean isWritten(GenerationContext context) {
        if (this.serviceInfos.contains(this.getCurrentService().getServiceInfo())) {
            return true;
        }
        this.serviceInfos.add(this.getCurrentService().getServiceInfo());
        return false;
    }

    protected ClassType getClassType() {
        return ClassType.INTERFACE;
    }

    protected void annotate(GenerationContext context, Service service, JDefinedClass jc) {
        JAnnotationUse ann = jc.annotate(WebService.class);
        ann.param("name", service.getServiceInfo().getPortType().getLocalPart());
        ann.param("targetNamespace", service.getTargetNamespace());
        service.setProperty(SERVICE_INTERFACE, (Object)jc);
    }

    protected void annotate(GenerationContext context, OperationInfo op, JMethod method) {
        this.wmAnn = method.annotate(WebMethod.class);
        this.wmAnn.param("operationName", op.getName());
    }

    protected void annotate(GenerationContext context, OperationInfo op, JMethod method, Binding binding) {
        String action;
        if (binding instanceof AbstractSoapBinding && (action = ((AbstractSoapBinding)binding).getSoapAction(op)) != null) {
            this.wmAnn.param("action", action);
        }
    }

    protected void annotateOutParam(MessagePartInfo part, JVar jvar) {
        JAnnotationUse wpann = jvar.annotate(WebParam.class);
        wpann.param("name", part.getName().getLocalPart());
        wpann.param("targetNamespace", part.getName().getNamespaceURI());
        wpann.param("mode", (Enum)WebParam.Mode.OUT);
    }

    protected void annotateOutParam(MessagePartInfo part, JVar jvar, Binding binding) {
        JAnnotationUse wpann = jvar.annotate(WebParam.class);
        wpann.param("name", part.getName().getLocalPart());
        wpann.param("targetNamespace", part.getName().getNamespaceURI());
        wpann.param("mode", (Enum)WebParam.Mode.OUT);
        wpann.param("header", true);
    }

    protected void annotateReturnType(JMethod method, MessagePartInfo returnPart) {
        JAnnotationUse wrAnn = method.annotate(WebResult.class);
        wrAnn.param("name", returnPart.getName().getLocalPart());
        wrAnn.param("targetNamespace", returnPart.getName().getNamespaceURI());
    }

    protected void annotateOneWay(JMethod method) {
        method.annotate(Oneway.class);
    }

    protected void annotate(MessagePartInfo part, JVar jvar) {
        this.wpann = jvar.annotate(WebParam.class);
        this.wpann.param("name", part.getName().getLocalPart());
        this.wpann.param("targetNamespace", part.getName().getNamespaceURI());
    }

    protected void annotate(MessagePartInfo part, JVar jvar, Binding binding) {
        this.wpann = jvar.annotate(WebParam.class);
        this.wpann.param("name", part.getName().getLocalPart());
        this.wpann.param("targetNamespace", part.getName().getNamespaceURI());
        this.wpann.param("header", true);
    }

    protected String getClassName(GenerationContext context, Service service) {
        QName name = service.getServiceInfo().getPortType();
        String pckg = context.getDestinationPackage();
        String clsName = this.javify(name.getLocalPart());
        return pckg + "." + clsName;
    }
}

