/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.gen.jaxb;

import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JType;
import com.sun.tools.xjc.api.ErrorListener;
import com.sun.tools.xjc.api.Mapping;
import com.sun.tools.xjc.api.S2JJAXBModel;
import com.sun.tools.xjc.api.SchemaCompiler;
import com.sun.tools.xjc.api.TypeAndAnnotation;
import com.sun.tools.xjc.api.XJC;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import javax.wsdl.Definition;
import javax.wsdl.extensions.UnknownExtensibilityElement;
import javax.xml.namespace.QName;
import org.codehaus.xfire.aegis.AegisBindingProvider;
import org.codehaus.xfire.aegis.type.TypeMappingRegistry;
import org.codehaus.xfire.gen.GenerationContext;
import org.codehaus.xfire.gen.GenerationException;
import org.codehaus.xfire.gen.SchemaSupport;
import org.codehaus.xfire.gen.jaxb.ErrorReceiverImpl;
import org.codehaus.xfire.jaxb2.JaxbTypeRegistry;
import org.codehaus.xfire.service.binding.BindingProvider;
import org.w3c.dom.Element;

public class JAXBSchemaSupport
implements SchemaSupport {
    SchemaCompiler schemaCompiler;
    private AegisBindingProvider provider = new AegisBindingProvider((TypeMappingRegistry)new JaxbTypeRegistry());
    private S2JJAXBModel model;
    private JCodeModel jaxbModel;

    public void initialize(GenerationContext context) throws Exception {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(new URLClassLoader(new URL[0], cl));
        ErrorReceiverImpl er = new ErrorReceiverImpl();
        this.schemaCompiler = XJC.createSchemaCompiler();
        this.schemaCompiler.setErrorListener((ErrorListener)er);
        Definition def = (Definition)context.getWsdl();
        ArrayList<Element> elements = new ArrayList<Element>();
        for (Object o : def.getTypes().getExtensibilityElements()) {
            if (o instanceof UnknownExtensibilityElement) {
                UnknownExtensibilityElement uee = (UnknownExtensibilityElement)o;
                elements.add(uee.getElement());
                continue;
            }
            try {
                Method mth = o.getClass().getMethod("getElement", new Class[0]);
                Object val = mth.invoke(o, new Object[0]);
                elements.add((Element)val);
            }
            catch (Exception e) {}
        }
        int schemaElementCount = 1;
        for (Element schemaElement : elements) {
            String systemId = new String("#types?schema" + schemaElementCount++);
            this.schemaCompiler.parseSchema(systemId, schemaElement);
        }
        this.model = this.schemaCompiler.bind();
        this.jaxbModel = this.model.generateCode(null, (ErrorListener)er);
        this.jaxbModel.build(context.getOutputDirectory());
        Thread.currentThread().setContextClassLoader(cl);
    }

    public JType getType(GenerationContext context, QName concreteType, QName schemaType) throws GenerationException {
        JCodeModel codeModel = context.getCodeModel();
        Mapping mapping = this.model.get(concreteType);
        if (mapping == null) {
            mapping = this.model.get(schemaType);
        }
        JType typeClass = null;
        if (mapping != null) {
            typeClass = mapping.getType().getTypeClass();
        }
        if (typeClass == null) {
            TypeAndAnnotation def = this.model.getJavaType(concreteType);
            if (def == null) {
                def = this.model.getJavaType(schemaType);
            }
            if (def != null) {
                return def.getTypeClass();
            }
        }
        if (typeClass == null) {
            Class clazz = this.provider.getTypeClass(concreteType, null);
            if (clazz == null) {
                clazz = this.provider.getTypeClass(schemaType, null);
            }
            if (clazz == null) {
                throw new GenerationException("Could not find type " + concreteType);
            }
            typeClass = codeModel._ref(clazz);
        }
        return typeClass;
    }

    public BindingProvider getBindingProvider() {
        return this.provider;
    }

    public JExpression getBindingProviderExpr(GenerationContext context) {
        JType aegis = context.getCodeModel()._ref(AegisBindingProvider.class);
        JInvocation expr = JExpr._new((JType)aegis);
        JType xbean = context.getCodeModel()._ref(JaxbTypeRegistry.class);
        expr.arg((JExpression)JExpr._new((JType)xbean));
        return expr;
    }
}

