/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.gen;

import com.sun.codemodel.JCodeModel;
import java.io.File;
import org.codehaus.xfire.gen.GenerationContext;
import org.codehaus.xfire.gen.GeneratorPlugin;
import org.codehaus.xfire.gen.PluginProfile;
import org.codehaus.xfire.gen.SchemaSupport;
import org.codehaus.xfire.gen.WSDLInputStreamLoader;
import org.codehaus.xfire.gen.jsr181.Jsr181Profile;
import org.codehaus.xfire.util.ClassLoaderUtils;
import org.codehaus.xfire.wsdl11.parser.WSDLServiceBuilder;

public class Wsdl11Generator {
    public static final String JAXB = "jaxb";
    public static final String XMLBEANS = "xmlbeans";
    private String wsdl;
    private String outputDirectory;
    private String destinationPackage;
    private JCodeModel codeModel = new JCodeModel();
    private String profile;
    private String binding = "jaxb";
    private SchemaSupport support;

    public void generate() throws Exception {
        File dest = new File(this.outputDirectory);
        if (!dest.exists()) {
            dest.mkdirs();
        }
        if (this.support == null) {
            if (this.binding.equals(JAXB)) {
                this.support = this.loadSupport("org.codehaus.xfire.gen.jaxb.JAXBSchemaSupport");
            } else if (this.binding.equals(XMLBEANS)) {
                this.support = this.loadSupport("org.codehaus.xfire.gen.xmlbeans.XmlBeansSchemaSupport");
            } else {
                throw new Exception("Illegal binding: " + this.binding);
            }
        }
        WSDLServiceBuilder builder = new WSDLServiceBuilder(new WSDLInputStreamLoader().getInputStream(this.wsdl));
        builder.setBindingProvider(this.support.getBindingProvider());
        builder.walkTree();
        if (this.profile == null) {
            this.profile = Jsr181Profile.class.getName();
        }
        PluginProfile profileObj = (PluginProfile)ClassLoaderUtils.loadClass((String)this.profile, this.getClass()).newInstance();
        GenerationContext context = new GenerationContext(this.codeModel, builder.getDefinition());
        context.setOutputDirectory(dest);
        context.setWsdlLocation(this.wsdl);
        this.support.initialize(context);
        context.setServices(builder.getServices());
        context.setDestinationPackage(this.getDestinationPackage());
        context.setSchemaGenerator(this.support);
        for (GeneratorPlugin plugin : profileObj.getPlugins()) {
            plugin.generate(context);
        }
        this.codeModel.build(dest);
    }

    private SchemaSupport loadSupport(String name) throws Exception {
        return (SchemaSupport)ClassLoaderUtils.loadClass((String)name, this.getClass()).newInstance();
    }

    public SchemaSupport getSchemaSupport() {
        return this.support;
    }

    public void setSchemaSupport(SchemaSupport support) {
        this.support = support;
    }

    public String getOutputDirectory() {
        return this.outputDirectory;
    }

    public void setOutputDirectory(String outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public JCodeModel getCodeModel() {
        return this.codeModel;
    }

    public String getWsdl() {
        return this.wsdl;
    }

    public void setWsdl(String wsdl) {
        this.wsdl = wsdl;
    }

    public String getDestinationPackage() {
        return this.destinationPackage;
    }

    public void setDestinationPackage(String destinationPackage) {
        this.destinationPackage = destinationPackage;
    }

    public String getBinding() {
        return this.binding;
    }

    public void setBinding(String binding) {
        this.binding = binding;
    }

    public String getProfile() {
        return this.profile;
    }

    public void setProfile(String profile) {
        this.profile = profile;
    }
}

