/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.aegis.type;

import java.beans.PropertyDescriptor;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.xfire.XFireRuntimeException;
import org.codehaus.xfire.aegis.type.AbstractTypeCreator;
import org.codehaus.xfire.aegis.type.Type;
import org.codehaus.xfire.aegis.type.basic.BeanType;
import org.codehaus.xfire.aegis.type.basic.XMLBeanTypeInfo;
import org.codehaus.xfire.util.ClassLoaderUtils;
import org.codehaus.xfire.util.NamespaceHelper;
import org.codehaus.xfire.util.jdom.StaxBuilder;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.xpath.XPath;

public class XMLTypeCreator
extends AbstractTypeCreator {
    private static final Log log = LogFactory.getLog((Class)XMLTypeCreator.class);
    private Map documents = new HashMap();
    private static List stopClasses = new ArrayList();

    protected Document getDocument(Class clazz) {
        if (clazz == null) {
            return null;
        }
        Document doc = (Document)this.documents.get(clazz.getName());
        if (doc != null) {
            return doc;
        }
        String path = '/' + clazz.getName().replace('.', '/') + ".aegis.xml";
        InputStream is = clazz.getResourceAsStream(path);
        if (is == null) {
            log.debug((Object)("Mapping file : " + path + " not found."));
            return null;
        }
        log.debug((Object)("Found mapping file : " + path));
        try {
            doc = new StaxBuilder().build(is);
            this.documents.put(clazz.getName(), doc);
            return doc;
        }
        catch (XMLStreamException e) {
            log.error((Object)("Error loading file " + path), (Throwable)e);
            return null;
        }
    }

    protected boolean isEnum(Class javaType) {
        Element mapping = this.findMapping(javaType);
        if (mapping != null) {
            return super.isEnum(javaType);
        }
        return this.nextCreator.isEnum(javaType);
    }

    public Type createEnumType(AbstractTypeCreator.TypeClassInfo info) {
        Element mapping = this.findMapping(info.getTypeClass());
        if (mapping != null) {
            return super.createEnumType(info);
        }
        return this.nextCreator.createEnumType(info);
    }

    public Type createCollectionType(AbstractTypeCreator.TypeClassInfo info) {
        if (info.getGenericType() instanceof Class || info.getGenericType() instanceof AbstractTypeCreator.TypeClassInfo) {
            return this.createCollectionTypeFromGeneric(info);
        }
        return this.nextCreator.createCollectionType(info);
    }

    public AbstractTypeCreator.TypeClassInfo createClassInfo(PropertyDescriptor pd) {
        Element mapping = this.findMapping(pd.getReadMethod().getDeclaringClass());
        if (mapping == null) {
            return this.nextCreator.createClassInfo(pd);
        }
        Element propertyEl = this.getMatch(mapping, "./property[@name='" + pd.getName() + "']");
        if (propertyEl == null) {
            return this.nextCreator.createClassInfo(pd);
        }
        AbstractTypeCreator.TypeClassInfo info = new AbstractTypeCreator.TypeClassInfo();
        info.setTypeClass(pd.getReadMethod().getReturnType());
        this.readMetadata(info, mapping, propertyEl);
        return info;
    }

    protected Element findMapping(Class clazz) {
        Document doc = this.getDocument(clazz);
        if (doc == null) {
            return null;
        }
        Element mapping = this.getMatch(doc, "/mappings/mapping[@uri='" + this.getTypeMapping().getEncodingStyleURI() + "']");
        if (mapping == null) {
            mapping = this.getMatch(doc, "/mappings/mapping[not(@uri)]");
        }
        return mapping;
    }

    protected List findMappings(Class clazz) {
        ArrayList<Element> mappings = new ArrayList<Element>();
        Element top = this.findMapping(clazz);
        if (top != null) {
            mappings.add(top);
        }
        Class parent = clazz;
        while (true) {
            Class<?>[] interfaces = parent.getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                Class<?> interfaze = interfaces[i];
                List interfaceMappings = this.findMappings(interfaze);
                mappings.addAll(interfaceMappings);
            }
            Class sup = parent.getSuperclass();
            if (sup == null || stopClasses.contains(sup)) break;
            Element mapping = this.findMapping(sup);
            if (mapping != null) {
                mappings.add(mapping);
            }
            parent = sup;
        }
        return mappings;
    }

    public Type createDefaultType(AbstractTypeCreator.TypeClassInfo info) {
        Element mapping = this.findMapping(info.getTypeClass());
        List mappings = this.findMappings(info.getTypeClass());
        if (mapping != null || mappings.size() > 0) {
            String typeNameAtt = null;
            if (mapping != null) {
                typeNameAtt = mapping.getAttributeValue("name");
            }
            String extensibleElements = null;
            if (mapping != null) {
                extensibleElements = mapping.getAttributeValue("extensibleElements");
            }
            String extensibleAttributes = null;
            if (mapping != null) {
                extensibleAttributes = mapping.getAttributeValue("extensibleAttributes");
            }
            String defaultNS = NamespaceHelper.makeNamespaceFromClassName(info.getTypeClass().getName(), "http");
            QName name = null;
            if (typeNameAtt != null) {
                name = NamespaceHelper.createQName(mapping, typeNameAtt, defaultNS);
                defaultNS = name.getNamespaceURI();
            }
            XMLBeanTypeInfo btinfo = new XMLBeanTypeInfo(info.getTypeClass(), mappings, defaultNS);
            btinfo.setTypeMapping(this.getTypeMapping());
            btinfo.setDefaultMinOccurs(this.getConfiguration().getDefaultMinOccurs());
            btinfo.setDefaultNillable(this.getConfiguration().isDefaultNillable());
            if (extensibleElements != null) {
                btinfo.setExtensibleElements(Boolean.valueOf(extensibleElements));
            } else {
                btinfo.setExtensibleElements(this.getConfiguration().isDefaultExtensibleElements());
            }
            if (extensibleAttributes != null) {
                btinfo.setExtensibleAttributes(Boolean.valueOf(extensibleAttributes));
            } else {
                btinfo.setExtensibleAttributes(this.getConfiguration().isDefaultExtensibleAttributes());
            }
            BeanType type = new BeanType(btinfo);
            if (name == null) {
                name = this.createQName(info.getTypeClass());
            }
            type.setSchemaType(name);
            type.setTypeClass(info.getTypeClass());
            type.setTypeMapping(this.getTypeMapping());
            return type;
        }
        return this.nextCreator.createDefaultType(info);
    }

    public AbstractTypeCreator.TypeClassInfo createClassInfo(Method m, int index) {
        Element mapping = this.findMapping(m.getDeclaringClass());
        if (mapping == null) {
            return this.nextCreator.createClassInfo(m, index);
        }
        AbstractTypeCreator.TypeClassInfo info = new AbstractTypeCreator.TypeClassInfo();
        if (index >= 0) {
            if (index >= m.getParameterTypes().length) {
                throw new XFireRuntimeException("Method " + m + " does not have a parameter at index " + index);
            }
            List nodes = this.getMatches(mapping, "./method[@name='" + m.getName() + "']/parameter[@index='" + index + "']/parent::*");
            if (nodes.size() == 0) {
                return this.nextCreator.createClassInfo(m, index);
            }
            Element bestMatch = this.getBestMatch(mapping, m, nodes);
            if (bestMatch == null) {
                return this.nextCreator.createClassInfo(m, index);
            }
            info.setTypeClass(m.getParameterTypes()[index]);
            Element parameter = this.getMatch(bestMatch, "parameter[@index='" + index + "']");
            this.readMetadata(info, mapping, parameter);
        } else {
            List nodes = this.getMatches(mapping, "./method[@name='" + m.getName() + "']/return-type/parent::*");
            if (nodes.size() == 0) {
                return this.nextCreator.createClassInfo(m, index);
            }
            Element bestMatch = this.getBestMatch(mapping, m, nodes);
            if (bestMatch == null) {
                return this.nextCreator.createClassInfo(m, index);
            }
            info.setTypeClass(m.getReturnType());
            Element rtElement = bestMatch.getChild("return-type");
            this.readMetadata(info, mapping, rtElement);
        }
        return info;
    }

    protected void readMetadata(AbstractTypeCreator.TypeClassInfo info, Element mapping, Element parameter) {
        String flat;
        String max;
        info.setTypeName(this.createQName(parameter, parameter.getAttributeValue("typeName")));
        info.setMappedName(this.createQName(parameter, parameter.getAttributeValue("mappedName")));
        this.setComponentType(info, mapping, parameter);
        this.setKeyType(info, mapping, parameter);
        this.setType(info, parameter);
        String min = parameter.getAttributeValue("minOccurs");
        if (min != null) {
            info.setMinOccurs(Long.parseLong(min));
        }
        if ((max = parameter.getAttributeValue("maxOccurs")) != null) {
            info.setMaxOccurs(Long.parseLong(max));
        }
        if ((flat = parameter.getAttributeValue("flat")) != null) {
            info.setFlat(Boolean.valueOf(flat.toLowerCase()));
        }
    }

    protected Type getOrCreateGenericType(AbstractTypeCreator.TypeClassInfo info) {
        Type type = null;
        if (info.getGenericType() != null) {
            type = this.createTypeFromGeneric(info.getGenericType());
        }
        if (type == null) {
            type = super.getOrCreateGenericType(info);
        }
        return type;
    }

    private Type createTypeFromGeneric(Object cType) {
        if (cType instanceof AbstractTypeCreator.TypeClassInfo) {
            return this.createTypeForClass((AbstractTypeCreator.TypeClassInfo)cType);
        }
        if (cType instanceof Class) {
            return this.createType((Class)cType);
        }
        return null;
    }

    protected Type getOrCreateMapKeyType(AbstractTypeCreator.TypeClassInfo info) {
        Type type = null;
        if (info.getKeyType() != null) {
            type = this.createTypeFromGeneric(info.getKeyType());
        }
        if (type == null) {
            type = super.getOrCreateMapKeyType(info);
        }
        return type;
    }

    protected Type getOrCreateMapValueType(AbstractTypeCreator.TypeClassInfo info) {
        Type type = null;
        if (info.getGenericType() != null) {
            type = this.createTypeFromGeneric(info.getGenericType());
        }
        if (type == null) {
            type = super.getOrCreateMapValueType(info);
        }
        return type;
    }

    protected void setComponentType(AbstractTypeCreator.TypeClassInfo info, Element mapping, Element parameter) {
        String componentType = parameter.getAttributeValue("componentType");
        if (componentType != null) {
            info.setGenericType(this.loadGeneric(info, mapping, componentType));
        }
    }

    private Object loadGeneric(AbstractTypeCreator.TypeClassInfo info, Element mapping, String componentType) {
        if (componentType.startsWith("#")) {
            String name = componentType.substring(1);
            Element propertyEl = this.getMatch(mapping, "./component[@name='" + name + "']");
            if (propertyEl == null) {
                throw new XFireRuntimeException("Could not find <component> element in mapping named '" + name + "'");
            }
            AbstractTypeCreator.TypeClassInfo componentInfo = new AbstractTypeCreator.TypeClassInfo();
            this.readMetadata(componentInfo, mapping, propertyEl);
            String className = propertyEl.getAttributeValue("class");
            if (className == null) {
                throw new XFireRuntimeException("A 'class' attribute must be specified for <component> " + name);
            }
            componentInfo.setTypeClass(this.loadComponentClass(className));
            return componentInfo;
        }
        return this.loadComponentClass(componentType);
    }

    private Class loadComponentClass(String componentType) {
        try {
            return ClassLoaderUtils.loadClass(componentType, this.getClass());
        }
        catch (ClassNotFoundException e) {
            throw new XFireRuntimeException("Unable to load component type class " + componentType, e);
        }
    }

    protected void setType(AbstractTypeCreator.TypeClassInfo info, Element parameter) {
        String type = parameter.getAttributeValue("type");
        if (type != null) {
            try {
                info.setType(ClassLoaderUtils.loadClass(type, this.getClass()));
            }
            catch (ClassNotFoundException e) {
                throw new XFireRuntimeException("Unable to load type class " + type, e);
            }
        }
    }

    protected void setKeyType(AbstractTypeCreator.TypeClassInfo info, Element mapping, Element parameter) {
        String componentType = parameter.getAttributeValue("keyType");
        if (componentType != null) {
            info.setKeyType(this.loadGeneric(info, mapping, componentType));
        }
    }

    private Element getBestMatch(Element mapping, Method method, List availableNodes) {
        Element element;
        Iterator iterator;
        List nodes = this.getMatches(mapping, "./method[@name='" + method.getName() + "']");
        if (availableNodes != null) {
            nodes.retainAll(availableNodes);
        }
        if (nodes.size() == 0) {
            return null;
        }
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (parameterTypes.length == 0) {
            return (Element)nodes.get(0);
        }
        for (int i = 0; i < parameterTypes.length; ++i) {
            Class<?> parameterType = parameterTypes[i];
            iterator = nodes.iterator();
            while (iterator.hasNext()) {
                element = (Element)iterator.next();
                Element match = this.getMatch(element, "parameter[@index='" + i + "']");
                if (match == null || match.getAttributeValue("class") == null || match.getAttributeValue("class").equals(parameterType.getName())) continue;
                iterator.remove();
            }
        }
        if (nodes.size() == 1) {
            return (Element)nodes.get(0);
        }
        Element bestCandidate = null;
        int highestSpecified = 0;
        iterator = nodes.iterator();
        while (iterator.hasNext()) {
            element = (Element)iterator.next();
            int availableParameters = element.getChildren("parameter").size();
            if (availableParameters <= highestSpecified) continue;
            bestCandidate = element;
            highestSpecified = availableParameters;
        }
        return bestCandidate;
    }

    private Element getMatch(Object doc, String xpath) {
        try {
            XPath path = XPath.newInstance((String)xpath);
            return (Element)path.selectSingleNode(doc);
        }
        catch (JDOMException e) {
            throw new XFireRuntimeException("Error evaluating xpath " + xpath, e);
        }
    }

    private List getMatches(Object doc, String xpath) {
        try {
            XPath path = XPath.newInstance((String)xpath);
            List result = path.selectNodes(doc);
            return result;
        }
        catch (JDOMException e) {
            throw new XFireRuntimeException("Error evaluating xpath " + xpath, e);
        }
    }

    protected QName createQName(Element e, String value) {
        if (value == null || value.length() == 0) {
            return null;
        }
        int index = value.indexOf(":");
        if (index == -1) {
            return new QName(this.getTypeMapping().getEncodingStyleURI(), value);
        }
        String prefix = value.substring(0, index);
        String localName = value.substring(index + 1);
        Namespace ns = e.getNamespace(prefix);
        if (ns == null || localName == null) {
            throw new XFireRuntimeException("Invalid QName in mapping: " + value);
        }
        return new QName(ns.getURI(), localName, prefix);
    }

    static {
        stopClasses.add(Object.class);
        stopClasses.add(Exception.class);
        stopClasses.add(RuntimeException.class);
        stopClasses.add(Throwable.class);
    }
}

