/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.updatecenter.common;

import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Date;
import java.util.Set;
import java.util.SortedSet;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.sonar.updatecenter.common.Artifact;
import org.sonar.updatecenter.common.Version;

public class Release
implements Comparable<Release> {
    private Artifact artifact;
    private Version version;
    private String description;
    private String downloadUrl;
    private String changelogUrl;
    private boolean isPublic;
    private boolean isArchived;
    private String groupId;
    private String artifactId;
    private Set<Release> outgoingDependencies;
    private Set<Release> incomingDependencies;
    private SortedSet<Version> compatibleSqVersions;
    private Date date;

    public Release(Artifact artifact, Version version) {
        this.artifact = artifact;
        this.version = version;
        this.isPublic = true;
        this.isArchived = false;
        this.compatibleSqVersions = Sets.newTreeSet();
        this.outgoingDependencies = Sets.newHashSet();
        this.incomingDependencies = Sets.newHashSet();
    }

    public Release(Artifact artifact, String version) {
        this(artifact, Version.create(version));
    }

    public Artifact getArtifact() {
        return this.artifact;
    }

    public Version getVersion() {
        return this.version;
    }

    public Release setVersion(Version version) {
        this.version = version;
        return this;
    }

    public String getDownloadUrl() {
        return this.downloadUrl;
    }

    public Release setDownloadUrl(String s) {
        this.downloadUrl = s;
        return this;
    }

    public String getFilename() {
        return StringUtils.substringAfterLast((String)this.downloadUrl, (String)"/");
    }

    public SortedSet<Version> getRequiredSonarVersions() {
        return this.compatibleSqVersions;
    }

    public boolean supportSonarVersion(Version providedSqVersion) {
        for (Version sqVersion : this.compatibleSqVersions) {
            if (!sqVersion.isCompatibleWith(providedSqVersion)) continue;
            return true;
        }
        return false;
    }

    public Release addRequiredSonarVersions(Version ... versions) {
        if (versions != null) {
            this.compatibleSqVersions.addAll(Arrays.asList(versions));
        }
        return this;
    }

    public Release addRequiredSonarVersions(String ... versions) {
        if (versions != null) {
            for (String v : versions) {
                this.compatibleSqVersions.add(Version.create(v));
            }
        }
        return this;
    }

    public Version getLastRequiredSonarVersion() {
        if (!this.compatibleSqVersions.isEmpty()) {
            return this.compatibleSqVersions.last();
        }
        return null;
    }

    public Version getMinimumRequiredSonarVersion() {
        if (!this.compatibleSqVersions.isEmpty()) {
            return this.compatibleSqVersions.first();
        }
        return null;
    }

    public Date getDate() {
        return this.date != null ? new Date(this.date.getTime()) : null;
    }

    public Release setDate(Date date) {
        this.date = date != null ? new Date(date.getTime()) : null;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public Release setDescription(String description) {
        this.description = description;
        return this;
    }

    public String getChangelogUrl() {
        return this.changelogUrl;
    }

    public Release setChangelogUrl(String changelogUrl) {
        this.changelogUrl = changelogUrl;
        return this;
    }

    public Set<Release> getOutgoingDependencies() {
        return ImmutableSortedSet.copyOf(this.outgoingDependencies);
    }

    public Release addOutgoingDependency(Release required) {
        this.outgoingDependencies.add(required);
        return this;
    }

    public Set<Release> getIncomingDependencies() {
        return ImmutableSortedSet.copyOf(this.incomingDependencies);
    }

    public Release addIncomingDependency(Release required) {
        this.incomingDependencies.add(required);
        return this;
    }

    public String getKey() {
        return this.getArtifact().getKey();
    }

    public Version getAdjustedVersion() {
        return this.version.removeQualifier();
    }

    public boolean isPublic() {
        return this.isPublic;
    }

    public void setPublic(boolean isPublic) {
        this.isPublic = isPublic;
    }

    public boolean isArchived() {
        return this.isArchived;
    }

    public void setArchived(boolean isArchived) {
        this.isArchived = isArchived;
    }

    public String groupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String artifactId() {
        return this.artifactId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Release release = (Release)o;
        if (!this.artifact.equals(release.artifact)) {
            return false;
        }
        return this.version.equals(release.version);
    }

    public int hashCode() {
        int result = this.artifact.hashCode();
        result = 31 * result + this.version.hashCode();
        return result;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("version", (Object)this.version).append("downloadUrl", (Object)this.downloadUrl).append("changelogUrl", (Object)this.changelogUrl).append("description", (Object)this.description).toString();
    }

    @Override
    public int compareTo(Release o) {
        return this.getVersion().compareTo(o.getVersion());
    }
}

