/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.updatecenter.common;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.sonar.updatecenter.common.Artifact;
import org.sonar.updatecenter.common.Plugin;
import org.sonar.updatecenter.common.PluginManifest;
import org.sonar.updatecenter.common.PluginReferential;
import org.sonar.updatecenter.common.Release;
import org.sonar.updatecenter.common.Version;

public class PluginReferentialManifestConverter {
    private PluginReferentialManifestConverter() {
    }

    public static PluginReferential fromPluginManifests(List<PluginManifest> pluginManifestList) {
        ArrayList plugins = Lists.newArrayList();
        for (PluginManifest pluginManifest : pluginManifestList) {
            Plugin plugin = new Plugin(pluginManifest.getKey());
            plugin.merge(pluginManifest);
            Release release = new Release((Artifact)plugin, pluginManifest.getVersion());
            release.addRequiredSonarVersions(Version.create(pluginManifest.getSonarVersion()));
            plugin.addRelease(release);
            plugins.add(plugin);
        }
        PluginReferential pluginReferential = PluginReferential.create(plugins);
        for (PluginManifest pluginManifest : pluginManifestList) {
            Plugin plugin = pluginReferential.findPlugin(pluginManifest.getKey());
            for (String requiresPluginKey : pluginManifest.getRequirePlugins()) {
                if (!StringUtils.isNotBlank((String)requiresPluginKey)) continue;
                for (Release release : plugin.getReleases()) {
                    Iterator split = Splitter.on((char)':').split((CharSequence)requiresPluginKey).iterator();
                    String requiredPluginReleaseKey = (String)split.next();
                    String requiredMinimumReleaseVersion = (String)split.next();
                    pluginReferential.addOutgoingDependency(release, requiredPluginReleaseKey, requiredMinimumReleaseVersion);
                }
            }
        }
        return pluginReferential;
    }
}

