/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.rules;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.rules.RuleParam;
import org.sonar.api.rules.RulePriority;
import org.sonar.api.rules.RulesCategory;
import org.sonar.api.utils.SonarException;
import org.sonar.check.Cardinality;

@Entity
@Table(name="rules")
public final class Rule {
    public static final String STATUS_BETA = "BETA";
    public static final String STATUS_DEPRECATED = "DEPRECATED";
    public static final String STATUS_READY = "READY";
    public static final String STATUS_REMOVED = "REMOVED";
    @Id
    @Column(name="id")
    @GeneratedValue
    private Integer id;
    public static final RulePriority DEFAULT_PRIORITY = RulePriority.MAJOR;
    @Column(name="name", updatable=true, nullable=true, length=200)
    private String name;
    @Column(name="plugin_rule_key", updatable=false, nullable=true, length=200)
    private String key;
    @Column(name="plugin_config_key", updatable=true, nullable=true, length=500)
    private String configKey;
    @Column(name="priority", updatable=true, nullable=true)
    @Enumerated(value=EnumType.ORDINAL)
    private RulePriority priority = DEFAULT_PRIORITY;
    @Column(name="description", updatable=true, nullable=true, length=0xFFFFFF)
    private String description;
    @Column(name="plugin_name", updatable=true, nullable=false)
    private String pluginName;
    @Enumerated(value=EnumType.STRING)
    @Column(name="cardinality", updatable=true, nullable=false)
    private Cardinality cardinality = Cardinality.SINGLE;
    @Column(name="status", updatable=true, nullable=true)
    private String status = "READY";
    @Column(name="language", updatable=true, nullable=true)
    private String language;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="parent_id", updatable=true, nullable=true)
    private Rule parent = null;
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    @OneToMany(mappedBy="rule")
    private List<RuleParam> params = new ArrayList<RuleParam>();
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="created_at", updatable=true, nullable=true)
    private Date createdAt;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="updated_at", updatable=true, nullable=true)
    private Date updatedAt;

    @Deprecated
    public Rule() {
    }

    @Deprecated
    public Rule(String pluginName, String key) {
        this.pluginName = pluginName;
        this.key = key;
        this.configKey = key;
    }

    @Deprecated
    public Rule(String pluginKey, String key, String name, RulesCategory rulesCategory, RulePriority severity) {
        this.setName(name);
        this.key = key;
        this.configKey = key;
        this.priority = severity;
        this.pluginName = pluginKey;
    }

    @Deprecated
    public Rule(String name, String key, RulesCategory rulesCategory, String pluginName, String description) {
        this();
        this.setName(name);
        this.key = key;
        this.configKey = key;
        this.pluginName = pluginName;
        this.description = description;
    }

    @Deprecated
    public Rule(String name, String key, String configKey, RulesCategory rulesCategory, String pluginName, String description) {
        this();
        this.setName(name);
        this.key = key;
        this.configKey = configKey;
        this.pluginName = pluginName;
        this.description = description;
    }

    public Integer getId() {
        return this.id;
    }

    @Deprecated
    public void setId(Integer id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public Rule setName(String name) {
        this.name = this.removeNewLineCharacters(name);
        return this;
    }

    public String getKey() {
        return this.key;
    }

    public Rule setKey(String key) {
        this.key = key;
        return this;
    }

    @Deprecated
    public String getPluginName() {
        return this.pluginName;
    }

    @Deprecated
    public Rule setPluginName(String pluginName) {
        this.pluginName = pluginName;
        return this;
    }

    public String getConfigKey() {
        return this.configKey;
    }

    public Rule setConfigKey(String configKey) {
        this.configKey = configKey;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public Rule setDescription(String description) {
        this.description = StringUtils.strip((String)description);
        return this;
    }

    @Deprecated
    public Rule setEnabled(Boolean enabled) {
        throw new UnsupportedOperationException("No more supported since version 3.6.");
    }

    public Boolean isEnabled() {
        return !STATUS_REMOVED.equals(this.status);
    }

    public List<RuleParam> getParams() {
        return this.params;
    }

    public RuleParam getParam(String key) {
        for (RuleParam param : this.params) {
            if (!StringUtils.equals((String)key, (String)param.getKey())) continue;
            return param;
        }
        return null;
    }

    public Rule setParams(List<RuleParam> params) {
        this.params.clear();
        for (RuleParam param : params) {
            param.setRule(this);
            this.params.add(param);
        }
        return this;
    }

    public RuleParam createParameter() {
        RuleParam parameter = new RuleParam().setRule(this);
        this.params.add(parameter);
        return parameter;
    }

    public RuleParam createParameter(String key) {
        RuleParam parameter = new RuleParam().setKey(key).setRule(this);
        this.params.add(parameter);
        return parameter;
    }

    @Deprecated
    public Integer getCategoryId() {
        return null;
    }

    public RulePriority getSeverity() {
        return this.priority;
    }

    public Rule setSeverity(RulePriority severity) {
        this.priority = severity == null ? DEFAULT_PRIORITY : severity;
        return this;
    }

    @Deprecated
    public RulePriority getPriority() {
        return this.priority;
    }

    @Deprecated
    public Rule setPriority(RulePriority priority) {
        return this.setSeverity(priority);
    }

    public String getRepositoryKey() {
        return this.pluginName;
    }

    public Rule setRepositoryKey(String s) {
        this.pluginName = s;
        return this;
    }

    public Rule setUniqueKey(String repositoryKey, String key) {
        return this.setRepositoryKey(repositoryKey).setKey(key).setConfigKey(key);
    }

    public Cardinality getCardinality() {
        return this.cardinality;
    }

    public Rule setCardinality(Cardinality c) {
        this.cardinality = c;
        return this;
    }

    public Rule getParent() {
        return this.parent;
    }

    public Rule setParent(Rule parent) {
        this.parent = parent;
        return this;
    }

    public String getStatus() {
        return this.status;
    }

    public Rule setStatus(String status) {
        if (!Rule.getStatusList().contains(status)) {
            throw new SonarException("The status of a rule can only contain : " + Joiner.on((String)", ").join(Rule.getStatusList()));
        }
        this.status = status;
        return this;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public Rule setCreatedAt(Date d) {
        this.createdAt = d;
        return this;
    }

    public Date getUpdatedAt() {
        return this.updatedAt;
    }

    public Rule setUpdatedAt(Date updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    public String getLanguage() {
        return this.language;
    }

    public Rule setLanguage(String language) {
        this.language = language;
        return this;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Rule)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        Rule other = (Rule)obj;
        return new EqualsBuilder().append((Object)this.pluginName, (Object)other.getRepositoryKey()).append((Object)this.key, (Object)other.getKey()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.pluginName).append((Object)this.key).toHashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("id", (Object)this.id).append("name", (Object)this.name).append("key", (Object)this.key).append("configKey", (Object)this.configKey).append("plugin", (Object)this.pluginName).append("severity", (Object)this.priority).append("cardinality", (Object)this.cardinality).append("status", (Object)this.status).append("language", (Object)this.language).append("parent", (Object)this.parent).toString();
    }

    private String removeNewLineCharacters(String text) {
        String removedCRLF = StringUtils.remove((String)text, (String)"\n");
        removedCRLF = StringUtils.remove((String)removedCRLF, (String)"\r");
        removedCRLF = StringUtils.remove((String)removedCRLF, (String)"\n\r");
        removedCRLF = StringUtils.remove((String)removedCRLF, (String)"\r\n");
        return removedCRLF;
    }

    public static Rule create() {
        return new Rule();
    }

    public static Rule create(String repositoryKey, String key, String name) {
        return new Rule().setUniqueKey(repositoryKey, key).setName(name);
    }

    public static Rule create(String repositoryKey, String key) {
        return new Rule().setUniqueKey(repositoryKey, key);
    }

    public static Set<String> getStatusList() {
        return ImmutableSet.of((Object)STATUS_READY, (Object)STATUS_BETA, (Object)STATUS_DEPRECATED, (Object)STATUS_REMOVED);
    }

    public RuleKey ruleKey() {
        return RuleKey.of(this.getRepositoryKey(), this.getKey());
    }
}

