/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions.utils;

import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Stream;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.ModelBase;
import org.apache.maven.model.PluginConfiguration;
import org.apache.maven.model.PluginContainer;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.versions.api.VersionRetrievalException;
import org.codehaus.mojo.versions.utils.DependencyBuilder;
import org.codehaus.mojo.versions.utils.DependencyComparator;

public class MavenProjectUtils {
    private MavenProjectUtils() {
    }

    public static Set<Dependency> extractPluginDependenciesFromPluginsInPluginManagement(MavenProject project) {
        return Optional.ofNullable(project.getBuild()).map(PluginConfiguration::getPluginManagement).map(PluginContainer::getPlugins).orElse(Collections.emptyList()).stream().filter(plugin -> plugin.getDependencies() != null).flatMap(plugin -> plugin.getDependencies().stream()).collect(() -> new TreeSet<Dependency>(DependencyComparator.INSTANCE), Set::add, Set::addAll);
    }

    public static Set<Dependency> extractDependenciesFromPlugins(MavenProject project) {
        return project.getBuildPlugins().stream().filter(plugin -> plugin.getDependencies() != null).flatMap(plugin -> plugin.getDependencies().stream()).collect(() -> new TreeSet<Dependency>(DependencyComparator.INSTANCE), Set::add, Set::addAll);
    }

    public static Set<Dependency> extractDependenciesFromDependencyManagement(MavenProject project, boolean processDependencyManagementTransitive, Log log) throws VersionRetrievalException {
        Stream<Dependency> dependencies = processDependencyManagementTransitive ? Optional.ofNullable(project.getDependencyManagement()).map(DependencyManagement::getDependencies).map(Collection::stream).orElse(Stream.empty()) : Stream.concat(Optional.ofNullable(project.getOriginalModel().getDependencyManagement()).map(DependencyManagement::getDependencies).map(Collection::stream).orElse(Stream.empty()), Optional.ofNullable(project.getOriginalModel().getProfiles()).flatMap(profiles -> profiles.stream().map(ModelBase::getDependencyManagement).filter(Objects::nonNull).map(DependencyManagement::getDependencies).map(Collection::stream).reduce(Stream::concat)).orElse(Stream.empty()));
        return dependencies.peek(dependency -> log.debug((CharSequence)("dependency from pom: " + dependency.getGroupId() + ":" + dependency.getArtifactId() + ":" + dependency.getVersion() + ":" + dependency.getScope()))).map(dependency -> dependency.getVersion() != null ? MavenProjectUtils.interpolateVersion(dependency.getVersion(), project).map(v -> {
            Dependency result = dependency.clone();
            result.setVersion(v);
            return result;
        }).orElse((Dependency)dependency) : MavenProjectUtils.getVersionFromParent(dependency, project, processDependencyManagementTransitive, log).orElse((Dependency)dependency)).collect(() -> new TreeSet<Dependency>(DependencyComparator.INSTANCE), Set::add, Set::addAll);
    }

    private static Optional<Dependency> getVersionFromParent(Dependency dependency, MavenProject project, boolean processDependencyManagementTransitive, Log log) {
        if (project.hasParent()) {
            log.debug((CharSequence)"Reading parent dependencyManagement information");
            return Optional.ofNullable(processDependencyManagementTransitive ? project.getParent().getDependencyManagement() : project.getParent().getOriginalModel().getDependencyManagement()).map(DependencyManagement::getDependencies).map(Collection::stream).flatMap(s -> s.filter(d -> dependency.getGroupId().equals(d.getGroupId())).filter(d -> dependency.getArtifactId().equals(d.getArtifactId())).filter(d -> dependency.getType().equals(d.getType())).findAny());
        }
        String message = "We can't getModel the version for the dependency " + dependency.getGroupId() + ":" + dependency.getArtifactId() + " because there does not exist a parent.";
        log.warn((CharSequence)message);
        return Optional.empty();
    }

    public static Optional<String> interpolateVersion(String versionString, MavenProject project) {
        while (versionString != null && versionString.startsWith("${")) {
            String propertyName = versionString.substring(2, versionString.length() - 1);
            versionString = Optional.ofNullable(project.getOriginalModel()).map(ModelBase::getProperties).map(p -> p.getProperty(propertyName)).orElse(null);
        }
        return Optional.ofNullable(versionString);
    }

    public static boolean dependencyVersionLocalToReactor(Dependency dependency) {
        return dependency.getLocation((Object)DependencyBuilder.Location.VERSION.toString()).getSource() == dependency.getLocation((Object)DependencyBuilder.Location.ARTIFACT_ID.toString()).getSource();
    }
}

