/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.cobertura;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.mojo.cobertura.AbstractCoberturaMojo;
import org.codehaus.mojo.cobertura.configuration.ConfigInstrumentation;
import org.codehaus.mojo.cobertura.tasks.InstrumentTask;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;

public class CoberturaInstrumentMojo
extends AbstractCoberturaMojo {
    private ArtifactFactory factory;

    public void execute() throws MojoExecutionException {
        block12: {
            File outputDirectory;
            block11: {
                ArtifactHandler artifactHandler = this.project.getArtifact().getArtifactHandler();
                if ("java".equals(artifactHandler.getLanguage())) break block11;
                this.getLog().info((CharSequence)"Not executing cobertura:instrument as the project is not a Java classpath-capable package");
                break block12;
            }
            File instrumentedDirectory = new File(this.project.getBuild().getDirectory(), "generated-classes/cobertura");
            if (!instrumentedDirectory.exists()) {
                instrumentedDirectory.mkdirs();
            }
            if (this.instrumentation == null) {
                this.instrumentation = new ConfigInstrumentation();
            }
            if (this.instrumentation.getIncludes().isEmpty()) {
                this.instrumentation.addInclude("**/*.class");
            }
            if (!(outputDirectory = new File(this.project.getBuild().getOutputDirectory())).exists()) {
                outputDirectory.mkdirs();
            }
            try {
                FileUtils.copyDirectoryStructure((File)outputDirectory, (File)instrumentedDirectory);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Unable to prepare instrumentation directory.", (Exception)e);
            }
            this.instrumentation.setBasedir(instrumentedDirectory);
            if (!this.dataFile.getParentFile().exists()) {
                this.dataFile.getParentFile().mkdirs();
            }
            InstrumentTask task = new InstrumentTask();
            this.setTaskDefaults(task);
            task.setConfig(this.instrumentation);
            task.setDestinationDir(instrumentedDirectory);
            task.setDataFile(this.dataFile);
            task.execute();
            this.addCoberturaDependenciesToTestClasspath();
            System.setProperty("net.sourceforge.cobertura.datafile", this.dataFile.getPath());
            Properties props = new Properties();
            props.setProperty("net.sourceforge.cobertura.datafile", this.dataFile.getPath());
            File coberturaPropertiesFile = new File(instrumentedDirectory, "cobertura.properties");
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(coberturaPropertiesFile);
                props.store(fos, "Generated by maven-cobertura-plugin for project " + this.project.getId());
            }
            catch (IOException e) {
                try {
                    throw new MojoExecutionException("Unable to write cobertura.properties file.", (Exception)e);
                }
                catch (Throwable throwable) {
                    IOUtil.close(fos);
                    throw throwable;
                }
            }
            IOUtil.close((OutputStream)fos);
            this.project.getBuild().setOutputDirectory(instrumentedDirectory.getPath());
            System.setProperty("project.build.outputDirectory", instrumentedDirectory.getPath());
        }
    }

    private void addCoberturaDependenciesToTestClasspath() throws MojoExecutionException {
        Map pluginArtifactMap = ArtifactUtils.artifactMapByVersionlessId((Collection)this.pluginClasspathList);
        Artifact coberturaArtifact = (Artifact)pluginArtifactMap.get("net.sourceforge.cobertura:cobertura-runtime");
        if (coberturaArtifact == null) {
            System.out.println("pluginArtifactMap: " + pluginArtifactMap);
            throw new MojoExecutionException("Couldn't find 'cobertura' artifact in plugin dependencies");
        }
        coberturaArtifact = this.artifactScopeToTest(coberturaArtifact);
        if (this.project.getDependencyArtifacts() != null) {
            LinkedHashSet<Artifact> set = new LinkedHashSet<Artifact>(this.project.getDependencyArtifacts());
            set.add(coberturaArtifact);
            this.project.setDependencyArtifacts(set);
        }
    }

    private Artifact artifactScopeToTest(Artifact artifact) {
        return this.factory.createArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), "test", artifact.getType());
    }
}

