/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.axistools;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class HelpMojo
extends AbstractMojo {
    private boolean detail;
    private String goal;
    private int lineLength;
    private int indentSize;

    public void execute() throws MojoExecutionException {
        if (this.lineLength <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'lineLength' should be positive, using '80' as default.");
            this.lineLength = 80;
        }
        if (this.indentSize <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'indentSize' should be positive, using '2' as default.");
            this.indentSize = 2;
        }
        StringBuffer sb = new StringBuffer();
        this.append(sb, "org.codehaus.mojo:axistools-maven-plugin:1.4", 0);
        this.append(sb, "", 0);
        this.append(sb, "Axis Tools Maven Plugin", 0);
        this.append(sb, "This plugin supports the wsdl2java and java2wsdl tools from the Apache Axis (1) project.", 1);
        this.append(sb, "", 0);
        if (this.goal == null || this.goal.length() <= 0) {
            this.append(sb, "This plugin has 4 goals:", 0);
            this.append(sb, "", 0);
        }
        if (this.goal == null || this.goal.length() <= 0 || "admin".equals(this.goal)) {
            this.append(sb, "axistools:admin", 0);
            this.append(sb, "Utility for turning xml into Axis deployment operations (wraps org.apache.axis.utils.Admin)", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "configOutputDirectory (Default: ${basedir}/src/main/webapp/WEB-INF)", 2);
                this.append(sb, "Where the server-config.wsdd or client-config.wsdd should go.", 3);
                this.append(sb, "", 0);
                this.append(sb, "inputFiles", 2);
                this.append(sb, "Files used to create deployment file.", 3);
                this.append(sb, "", 0);
                this.append(sb, "isServerConfig (Default: true)", 2);
                this.append(sb, "Generate a server or client deployment file.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "help".equals(this.goal)) {
            this.append(sb, "axistools:help", 0);
            this.append(sb, "Display help information on axistools-maven-plugin.\nCall\n\u00a0\u00a0mvn\u00a0axistools:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "detail (Default: false)", 2);
                this.append(sb, "If true, display all settable properties for each goal.", 3);
                this.append(sb, "", 0);
                this.append(sb, "goal", 2);
                this.append(sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3);
                this.append(sb, "", 0);
                this.append(sb, "indentSize (Default: 2)", 2);
                this.append(sb, "The number of spaces per indentation level, should be positive.", 3);
                this.append(sb, "", 0);
                this.append(sb, "lineLength (Default: 80)", 2);
                this.append(sb, "The maximum length of a display line, should be positive.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "java2wsdl".equals(this.goal)) {
            this.append(sb, "axistools:java2wsdl", 0);
            this.append(sb, "A Plugin for generating WSDL files using Axis Java2WSDL.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "all", 2);
                this.append(sb, "Look for allowed methods in inherited class. Corresponds to the -a, --all option in the Java2WSDL command line tool.", 3);
                this.append(sb, "", 0);
                this.append(sb, "bindingName", 2);
                this.append(sb, "Indicates the name to use for the binding element. If not specified, the value of the servicePortName + 'SoapBinding' is used. Corresponds to the -b, --bindingName option in the Java2WSDL command line tool.", 3);
                this.append(sb, "", 0);
                this.append(sb, "classesDirectory (Default: ${project.build.outputDirectory})", 2);
                this.append(sb, "The directory the compile objects will be located for java2wsdl to source from.", 3);
                this.append(sb, "", 0);
                this.append(sb, "classOfPortType", 2);
                this.append(sb, "The class-of-portType.", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludes", 2);
                this.append(sb, "List of methods not to export. Corresponds to the -x, --exclude option in the Java2WSDL command line tool.", 3);
                this.append(sb, "", 0);
                this.append(sb, "extraClasses", 2);
                this.append(sb, "Specify a list of class names which should be included in the types section of the WSDL document. This is useful in the case where your service interface references a base class and you would like your WSDL to contain XML Schema type definitions for these other classes. Corresponds to the -e, --extraClasses option in the Java2WSDL command line tool.", 3);
                this.append(sb, "", 0);
                this.append(sb, "filename", 2);
                this.append(sb, "Indicates the name of the output WSDL file. Corresponds to the -o, --output option in the Java2WSDL command line tool, together with the outputDirectory parameter.", 3);
                this.append(sb, "", 0);
                this.append(sb, "implClass", 2);
                this.append(sb, "Sometimes extra information is available in the implementation class file. Use this option to specify the implementation class. Corresponds to the -i, --implClass option in the Java2WSDL command line tool.", 3);
                this.append(sb, "", 0);
                this.append(sb, "importSchema", 2);
                this.append(sb, "A file or URL to an XML Schema that should be physically imported into the generated WSDL. Corresponds to the -C, --importSchema option in the Java2WSDL command line tool.", 3);
                this.append(sb, "", 0);
                this.append(sb, "input", 2);
                this.append(sb, "Optional parameter that indicates the name of the input wsdl file. The output wsdl file will contain everything from the input wsdl file plus the new constructs. If a new construct is already present in the input wsdl file, it is not added. This option is useful for constructing a wsdl file with multiple ports, bindings, or portTypes. Corresponds to the -I, --input option in the Java2WSDL command line tool.", 3);
                this.append(sb, "", 0);
                this.append(sb, "location", 2);
                this.append(sb, "Indicates the url of the location of the service. The name after the last slash or backslash is the name of the service port (unless overridden by the servicePortName option). The service port address location attribute is assigned the specified value. Corresponds to the -l, --location option in the Java2WSDL command line tool.", 3);
                this.append(sb, "", 0);
                this.append(sb, "locationImport", 2);
                this.append(sb, "Used to indicate the location of the interface WSDL when generating an implementation WSDL. Corresponds to the -L, --locationImport option in the Java2WSDL command line tool.", 3);
                this.append(sb, "", 0);
                this.append(sb, "methods", 2);
                this.append(sb, "Methods to export. Corresponds to the -m, --methods option in the Java2WSDL command line tool.", 3);
                this.append(sb, "", 0);
                this.append(sb, "namespace", 2);
                this.append(sb, "Indicates the name of the target namespace of the WSDL. Corresponds to the -n, --namespace option in the Java2WSDL command line tool.", 3);
                this.append(sb, "", 0);
                this.append(sb, "namespaceImpl", 2);
                this.append(sb, "Namespace of the implementation WSDL. Corresponds to the -N, --namespaceImpl option in the Java2WSDL command line tool.", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputDirectory (Default: ${project.build.directory}/generated-sources/axistools/java2wsdl)", 2);
                this.append(sb, "Directory for generated content. Corresponds to the -o, --output option in the Java2WSDL command line tool, together with the filename parameter.", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputImpl", 2);
                this.append(sb, "Use this option to indicate the name of the output implementation WSDL file. If specified, Java2WSDL will produce interface and implementation WSDL files. If this option is used, the outputWSDLMode option is ignored. Corresponds to the -O, --outputImpl option in the Java2WSDL command line tool.", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputWSDLMode", 2);
                this.append(sb, "Indicates the kind of WSDL to generate. Accepted values are:\n-\tAll --- (default) Generates wsdl containing both interface and implementation WSDL constructs.\n-\tInterface --- Generates a WSDL containing the interface constructs (no service element).\n-\tImplementation -- Generates a WSDL containing the implementation. The interface WSDL is imported via the locationImport option.\nCorresponds to the -w, --outputWsdlMode option in the Java2WSDL command line tool.", 3);
                this.append(sb, "", 0);
                this.append(sb, "packageToNamespace", 2);
                this.append(sb, "Package=namespace, name value pair. The plugin currently only supports one name value pair. Corresponds to the -p, --PkgtoNS option in the Java2WSDL command line tool.", 3);
                this.append(sb, "", 0);
                this.append(sb, "portTypeName", 2);
                this.append(sb, "Indicates the name to use for the portType element. If not specified, the classOfPortType name is used. Corresponds to the -P, --portTypeName option in the Java2WSDL command line tool.", 3);
                this.append(sb, "", 0);
                this.append(sb, "serviceElementName", 2);
                this.append(sb, "Service element name (defaults to servicePortName value + 'Service'). Corresponds to the -S, --serviceElementName option in the Java2WSDL command line tool.", 3);
                this.append(sb, "", 0);
                this.append(sb, "servicePortName", 2);
                this.append(sb, "Indicates the name of the service port. If not specified, the service port name is derived from the location value. Corresponds to the -s, --servicePortName option in the Java2WSDL command line tool.", 3);
                this.append(sb, "", 0);
                this.append(sb, "soapAction", 2);
                this.append(sb, "The value of the operations soapAction field. Values are DEFAULT, OPERATION or NONE. OPERATION forces soapAction to the name of the operation. DEFAULT causes the soapAction to be set according to the operation's meta data (usually ''). NONE forces the soapAction to ''. The default is DEFAULT. Corresponds to the -A, --soapAction option in the Java2WSDL command line tool.", 3);
                this.append(sb, "", 0);
                this.append(sb, "stopClasses", 2);
                this.append(sb, "List of classes which stop the Java2WSDL inheritance search. Corresponds to the -c, --stopClasses option in the Java2WSDL command line tool.", 3);
                this.append(sb, "", 0);
                this.append(sb, "style", 2);
                this.append(sb, "The style of the WSDL document: RPC, DOCUMENT or WRAPPED. The default is RPC. If RPC is specified, an rpc wsdl is generated. If DOCUMENT is specified, a document wsdl is generated. If WRAPPED is specified, a document/literal wsdl is generated using the wrapped approach. Wrapped style forces the use attribute to be literal. Corresponds to the -y, --style option in the Java2WSDL command line tool.", 3);
                this.append(sb, "", 0);
                this.append(sb, "typeMappingVersion", 2);
                this.append(sb, "Choose the default type mapping registry to use. Either 1.1 or 1.2. Corresponds to the -T, --typeMappingVersion option in the Java2WSDL command line tool.", 3);
                this.append(sb, "", 0);
                this.append(sb, "use", 2);
                this.append(sb, "The use of the WSDL document: LITERAL or ENCODED. If LITERAL is specified, the XML Schema defines the representation of the XML for the request. If ENCODED is specified, SOAP encoding is specified in the generated WSDL. Corresponds to the -u, --use option in the Java2WSDL command line tool.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "wsdl2java".equals(this.goal)) {
            this.append(sb, "axistools:wsdl2java", 0);
            this.append(sb, "A Plugin for generating stubs for WSDL files using Axis WSDL2Java.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "allElements", 2);
                this.append(sb, "Generate code for all elements, even unreferenced ones. By default, WSDL2Java only generates code for those elements in the WSDL file that are referenced. A note about what it means to be referenced. We cannot simply say: start with the services, generate all bindings referenced by the service, generate all portTypes referenced by the referenced bindings, etc. What if we're generating code from a WSDL file that only contains portTypes, messages, and types? If WSDL2Java used service as an anchor, and there's no service in the file, then nothing will be generated. So the anchor is the lowest element that exists in the WSDL file in the order:\n1.\ttypes\n2.\tportTypes\n3.\tbindings\n4.\tservices\nFor example, if a WSDL file only contained types, then all the listed types would be generated. But if a WSDL file contained types and a portType, then that portType will be generated and only those types that are referenced by that portType. Note that the anchor is searched for in the WSDL file appearing on the command line, not in imported WSDL files. This allows one WSDL file to import constructs defined in another WSDL file without the nuisance of having all the imported WSDL file's constructs generated. Corresponds to the -a, --all option in the WSDL2Java command line tool.", 3);
                this.append(sb, "", 0);
                this.append(sb, "debug (Default: false)", 2);
                this.append(sb, "Print debug information, which currently is WSDL2Java's symbol table. Note that this is only printed after the symbol table is complete, ie., after the WSDL is parsed successfully. Corresponds to the -D, --Debug option in the WSDL2Java command line tool.", 3);
                this.append(sb, "", 0);
                this.append(sb, "deployScope", 2);
                this.append(sb, "Add scope to deploy.xml: 'Application', 'Request', 'Session'. Corresponds to the -d, --deployScope option in the WSDL2Java command line tool.", 3);
                this.append(sb, "", 0);
                this.append(sb, "factory", 2);
                this.append(sb, "Name of a custom class that implements GeneratorFactory interface (for extending Java generation functions). Corresponds to the -F, --factory option in the WSDL2Java command line tool.", 3);
                this.append(sb, "", 0);
                this.append(sb, "fileNamespaceToPackage", 2);
                this.append(sb, "File containing namespace to package mappings. Corresponds to the -f, --fileNStoPkg option in the WSDL2Java command line tool.", 3);
                this.append(sb, "", 0);
                this.append(sb, "helperGen (Default: false)", 2);
                this.append(sb, "Emits separate Helper classes for meta data. Corresponds to the -H, --helperGen option in the WSDL2Java command line tool.", 3);
                this.append(sb, "", 0);
                this.append(sb, "implementationClassName", 2);
                this.append(sb, "Use this as the implementation class. Corresponds to the -c, --implementationClassName option in the WSDL2Java command line tool.", 3);
                this.append(sb, "", 0);
                this.append(sb, "mappings", 2);
                this.append(sb, "Mappings of <namespace> to <targetPackage>.", 3);
                this.append(sb, "", 0);
                this.append(sb, "namespaceToPackage", 2);
                this.append(sb, "Mapping of namespace to package. This is only used when useEmitter is set to true. If useEmitter is set to false you should use mappings instead. Corresponds to the -N, --NStoPkg option in the WSDL2Java command line tool.", 3);
                this.append(sb, "", 0);
                this.append(sb, "noImports (Default: false)", 2);
                this.append(sb, "Only generate code for the immediate WSDL document. Corresponds to the -n, --noImports option in the WSDL2Java command line tool.", 3);
                this.append(sb, "", 0);
                this.append(sb, "noWrapped (Default: false)", 2);
                this.append(sb, "Turn off support for 'wrapped' document/literal. Corresponds to the -W, --noWrapped option in the WSDL2Java command line tool.", 3);
                this.append(sb, "", 0);
                this.append(sb, "nsExcludes", 2);
                this.append(sb, "Namespace to specifically exclude from the generated code (defaults to none excluded until first namespace included with nsIncludes option). Corresponds to the -x, --nsExclude option in the WSDL2Java command line tool.", 3);
                this.append(sb, "", 0);
                this.append(sb, "nsIncludes", 2);
                this.append(sb, "Namescape to specifically include in the generated code (defaults to all namespaces unless specifically excluded with the nsExcludes option). Corresponds to the -i, --nsInclude option in the WSDL2Java command line tool.", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputDirectory (Default: ${project.build.directory}/generated-sources/axistools/wsdl2java)", 2);
                this.append(sb, "Location to place generated java source files. Corresponds to the -o, --output option in the WSDL2Java command line tool.", 3);
                this.append(sb, "", 0);
                this.append(sb, "packageSpace", 2);
                this.append(sb, "Package to create the java files under, for example com.company.wsdl. Corresponds to the -p, --package option in the WSDL2Java command line tool.", 3);
                this.append(sb, "", 0);
                this.append(sb, "password", 2);
                this.append(sb, "Password to access the WSDL-URI. Corresponds to the -P, --password option in the WSDL2Java command line tool.", 3);
                this.append(sb, "", 0);
                this.append(sb, "runTestCasesAsUnitTests (Default: false)", 2);
                this.append(sb, "Copy the generated test cases to a generated-sources test directory to be compiled and run as normal Surefire unit tests.", 3);
                this.append(sb, "", 0);
                this.append(sb, "serverSide", 2);
                this.append(sb, "Emit server-side bindings for web service. Corresponds to the -s, --server-side option in the WSDL2Java command line tool.", 3);
                this.append(sb, "", 0);
                this.append(sb, "skeletonDeploy (Default: false)", 2);
                this.append(sb, "Deploy skeleton (true) or implementation (false) in deploy.wsdd. Corresponds to the -S, --skeletonDeploy option in the WSDL2Java command line tool.", 3);
                this.append(sb, "", 0);
                this.append(sb, "sourceDependencies", 2);
                this.append(sb, "List of source dependencies in the format groupId:artifactId:version:file.", 3);
                this.append(sb, "", 0);
                this.append(sb, "sourceDependencyDirectory (Default: ${project.build.directory}/axistools/wsdl2java/sourceDependencies)", 2);
                this.append(sb, "Cache directory for WSDLs from sourceDependencies.", 3);
                this.append(sb, "", 0);
                this.append(sb, "sourceDirectory (Default: ${basedir}/src/main/wsdl)", 2);
                this.append(sb, "Source directory that contains .wsdl files.", 3);
                this.append(sb, "", 0);
                this.append(sb, "staleMillis (Default: 0)", 2);
                this.append(sb, "The granularity in milliseconds of the last modification date for testing whether a source needs recompilation.", 3);
                this.append(sb, "", 0);
                this.append(sb, "subPackageByFileName", 2);
                this.append(sb, "load.wsdl would further subpackage into load.*", 3);
                this.append(sb, "", 0);
                this.append(sb, "testCases", 2);
                this.append(sb, "Generate the test cases. Corresponds to the -t, --testCase option in the WSDL2Java command line tool.", 3);
                this.append(sb, "", 0);
                this.append(sb, "testSourceDirectory (Default: ${project.build.directory}/generated-test-sources/wsdl)", 2);
                this.append(sb, "Location to place generated test source files.", 3);
                this.append(sb, "", 0);
                this.append(sb, "timeout", 2);
                this.append(sb, "Timeout in seconds (default is 45, specify -1 to disable). Corresponds to the -O, --timeout option in the WSDL2Java command line tool.", 3);
                this.append(sb, "", 0);
                this.append(sb, "timestampDirectory (Default: ${project.build.directory})", 2);
                this.append(sb, "Directory used when evaluating whether files are up to date or stale.", 3);
                this.append(sb, "", 0);
                this.append(sb, "typeMappingVersion (Default: 1.1)", 2);
                this.append(sb, "Indicate either 1.1 or 1.2, where 1.1 means SOAP 1.1 JAX-RPC compliant and 1.2 indicates SOAP 1.1 encoded. Corresponds to the -T, --typeMappingVersion option in the WSDL2Java command line tool.", 3);
                this.append(sb, "", 0);
                this.append(sb, "urlDownloadDirectory (Default: ${project.build.directory}/axistools/wsdl2java/urlDownloads)", 2);
                this.append(sb, "Cache directory for WSDLs from URLs.", 3);
                this.append(sb, "", 0);
                this.append(sb, "urls", 2);
                this.append(sb, "List of URLs to process.", 3);
                this.append(sb, "", 0);
                this.append(sb, "useEmitter (Default: false)", 2);
                this.append(sb, "Use the Emitter for generating the java files as opposed to the commandline wsdl2java tool.", 3);
                this.append(sb, "", 0);
                this.append(sb, "username", 2);
                this.append(sb, "Username to access the WSDL-URI. Corresponds to the -U, --user option in the WSDL2Java command line tool.", 3);
                this.append(sb, "", 0);
                this.append(sb, "verbose", 2);
                this.append(sb, "See what the tool is generating as it is generating it. Corresponds to the -v, --verbose option in the WSDL2Java command line tool.", 3);
                this.append(sb, "", 0);
                this.append(sb, "wrapArrays (Default: true)", 2);
                this.append(sb, "Prefer generating JavaBean classes like 'ArrayOfString' for certain schema array patterns. Corresponds to the -w, --wrapArrays option in the WSDL2Java command line tool.", 3);
                this.append(sb, "", 0);
                this.append(sb, "wsdlFiles", 2);
                this.append(sb, "List of WSDL files from sourceDirectory to process. The files will be processed in the order they appear in your configuration.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)sb.toString());
        }
    }

    private static String repeat(String str, int repeat) {
        StringBuffer buffer = new StringBuffer(repeat * str.length());
        for (int i = 0; i < repeat; ++i) {
            buffer.append(str);
        }
        return buffer.toString();
    }

    private void append(StringBuffer sb, String description, int indent) {
        Iterator it = HelpMojo.toLines(description, indent, this.indentSize, this.lineLength).iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString()).append('\n');
        }
    }

    private static List toLines(String text, int indent, int indentSize, int lineLength) {
        ArrayList lines = new ArrayList();
        String ind = HelpMojo.repeat("\t", indent);
        String[] plainLines = text.split("(\r\n)|(\r)|(\n)");
        for (int i = 0; i < plainLines.length; ++i) {
            HelpMojo.toLines(lines, ind + plainLines[i], indentSize, lineLength);
        }
        return lines;
    }

    private static void toLines(List lines, String line, int indentSize, int lineLength) {
        int lineIndent = HelpMojo.getIndentLevel(line);
        StringBuffer buf = new StringBuffer(256);
        String[] tokens = line.split(" +");
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (i > 0) {
                if (buf.length() + token.length() >= lineLength) {
                    lines.add(buf.toString());
                    buf.setLength(0);
                    buf.append(HelpMojo.repeat(" ", lineIndent * indentSize));
                } else {
                    buf.append(' ');
                }
            }
            for (int j = 0; j < token.length(); ++j) {
                char c = token.charAt(j);
                if (c == '\t') {
                    buf.append(HelpMojo.repeat(" ", indentSize - buf.length() % indentSize));
                    continue;
                }
                if (c == '\u00a0') {
                    buf.append(' ');
                    continue;
                }
                buf.append(c);
            }
        }
        lines.add(buf.toString());
    }

    private static int getIndentLevel(String line) {
        int i;
        int level = 0;
        for (i = 0; i < line.length() && line.charAt(i) == '\t'; ++i) {
            ++level;
        }
        for (i = level + 1; i <= level + 4 && i < line.length(); ++i) {
            if (line.charAt(i) != '\t') continue;
            ++level;
            break;
        }
        return level;
    }
}

