/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.event;

import com.izforge.izpack.api.adaptator.IXMLElement;
import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.data.Pack;
import com.izforge.izpack.api.data.PackFile;
import com.izforge.izpack.api.event.ProgressListener;
import com.izforge.izpack.api.event.ProgressNotifiers;
import com.izforge.izpack.api.exception.InstallerException;
import com.izforge.izpack.api.exception.IzPackException;
import com.izforge.izpack.api.resource.Resources;
import com.izforge.izpack.api.substitutor.VariableSubstitutor;
import com.izforge.izpack.event.AbstractProgressInstallerListener;
import com.izforge.izpack.event.BSFAction;
import com.izforge.izpack.installer.data.UninstallData;
import com.izforge.izpack.util.file.FileUtils;
import com.izforge.izpack.util.helper.SpecHelper;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class BSFInstallerListener
extends AbstractProgressInstallerListener {
    public static final String SPEC_FILE_NAME = "BSFActionsSpec.xml";
    private final Map<String, List<BSFAction>> actions = new HashMap<String, List<BSFAction>>();
    private final List<BSFAction> uninstActions = new ArrayList<BSFAction>();
    private final VariableSubstitutor replacer;
    private UninstallData uninstallData;
    private final Resources resources;
    private SpecHelper spec;
    private static final Logger logger = Logger.getLogger(BSFInstallerListener.class.getName());

    public BSFInstallerListener(InstallData installData, VariableSubstitutor replacer, Resources resources, UninstallData uninstallData, ProgressNotifiers notifiers) {
        super(installData, notifiers);
        this.replacer = replacer;
        this.uninstallData = uninstallData;
        this.resources = resources;
        this.spec = new SpecHelper(resources);
    }

    public void initialise() {
        try {
            this.spec.readSpec(SPEC_FILE_NAME, this.replacer);
        }
        catch (Exception exception) {
            throw new IzPackException("Failed to read: BSFActionsSpec.xml", (Throwable)exception);
        }
    }

    public void beforePacks(List<Pack> packs) {
        if (this.spec == null) {
            return;
        }
        for (Pack pack : packs) {
            IXMLElement packElement = this.spec.getPackForName(pack.getName());
            if (packElement == null) continue;
            ArrayList<BSFAction> packActions = new ArrayList<BSFAction>();
            List scriptEntries = packElement.getChildrenNamed("script");
            if (scriptEntries != null && !scriptEntries.isEmpty()) {
                for (IXMLElement scriptEntry : scriptEntries) {
                    BSFAction action = this.readAction(scriptEntry);
                    if (action == null) continue;
                    packActions.add(action);
                    String script = action.getScript().toLowerCase();
                    if (!script.contains("beforedelete") && !script.contains("afterdelete") && !script.contains("beforedeletion") && !script.contains("afterdeletion")) continue;
                    this.uninstActions.add(action);
                }
                if (!packActions.isEmpty()) {
                    this.setProgressNotifier();
                }
            }
            this.actions.put(pack.getName(), packActions);
        }
        for (Pack pack : packs) {
            this.performAllActions(pack, "beforepacks", null, packs, packs.size());
        }
    }

    public void beforePack(Pack pack, int i) {
        this.performAllActions(pack, "beforepack", null, pack, i);
    }

    public void afterPack(Pack pack, int i) {
        this.performAllActions(pack, "afterpack", null, pack, i);
    }

    public void afterPacks(List<Pack> packs, ProgressListener listener) {
        if (this.notifyProgress()) {
            listener.nextStep(this.getMessage("BSFAction.pack"), this.getProgressNotifierId(), this.getActionCount(packs));
        }
        for (Pack pack : packs) {
            this.performAllActions(pack, "afterpacks", listener, packs);
        }
        if (!this.uninstActions.isEmpty()) {
            this.uninstallData.addAdditionalData("bsfActions", this.uninstActions);
        }
    }

    public boolean isFileListener() {
        return true;
    }

    public void beforeDir(File dir, PackFile packFile, Pack pack) {
        this.performAllActions(pack, "beforedir", null, dir, packFile);
    }

    public void afterDir(File dir, PackFile packFile, Pack pack) {
        this.performAllActions(pack, "afterdir", null, dir, packFile);
    }

    public void beforeFile(File file, PackFile packFile, Pack pack) {
        this.performAllActions(pack, "beforefile", null, file, packFile);
    }

    public void afterFile(File file, PackFile packFile, Pack pack) {
        this.performAllActions(pack, "afterfile", null, file, packFile);
    }

    private int getActionCount(List<Pack> packs) {
        int count = 0;
        for (Pack pack : packs) {
            List<BSFAction> actList = this.actions.get(pack.getName());
            if (actList == null) continue;
            count += actList.size();
        }
        return count;
    }

    private void performAllActions(Pack pack, String order, ProgressListener listener, Object ... args) {
        String packName = pack.getName();
        List<BSFAction> actList = this.actions.get(packName);
        if (actList == null || actList.isEmpty()) {
            return;
        }
        logger.fine("Executing all " + order + " BSF actions of pack " + packName + " ...");
        for (BSFAction act : actList) {
            if (this.notifyProgress() && order.equals("afterpacks")) {
                listener.progress(act.getMessageID() != null ? this.getMessage(act.getMessageID()) : "");
            }
            if ("beforepacks".equalsIgnoreCase(order)) {
                act.init();
            }
            act.execute(order, args, this.getInstallData());
            if (!"afterpacks".equalsIgnoreCase(order)) continue;
            act.destroy();
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private BSFAction readAction(IXMLElement element) {
        BSFAction action = new BSFAction();
        String src = element.getAttribute("src");
        if (src != null) {
            InputStream is = null;
            InputStream subis = null;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                int read;
                byte[] buf = new byte[10240];
                is = this.resources.getInputStream(src);
                subis = new SpecHelper(this.resources).substituteVariables(is, this.replacer);
                while ((read = subis.read(buf)) != -1) {
                    baos.write(buf, 0, read);
                }
                action.setScript(new String(baos.toByteArray()));
            }
            catch (IzPackException exception) {
                try {
                    throw exception;
                    catch (Exception exception2) {
                        throw new InstallerException((Throwable)exception2);
                    }
                }
                catch (Throwable throwable) {
                    FileUtils.close(subis);
                    FileUtils.close(is);
                    throw throwable;
                }
            }
            FileUtils.close((Closeable)subis);
            FileUtils.close((Closeable)is);
        } else {
            String script = element.getContent();
            if (script == null) {
                script = "";
            }
            action.setScript(script);
        }
        String language = element.getAttribute("language");
        action.setLanguage(language);
        return action;
    }
}

