/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.api.data;

import com.izforge.izpack.api.data.ConfigurationOption;
import com.izforge.izpack.api.data.PanelActionConfiguration;
import com.izforge.izpack.api.data.binding.Action;
import com.izforge.izpack.api.data.binding.Help;
import com.izforge.izpack.api.data.binding.OsModel;
import com.izforge.izpack.api.rules.RulesEngine;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Panel
implements Serializable {
    static final long serialVersionUID = 8886445274940938809L;
    private String className;
    private List<OsModel> osConstraints = Collections.emptyList();
    private String panelId;
    private String condition;
    private boolean displayHidden = false;
    private String displayHiddenCondition;
    private boolean readonly = false;
    private String readonlyCondition;
    private List<String> validators = new ArrayList<String>();
    private Set<String> affectedVariableNames;
    private Map<Integer, String> validatorConditionIds = new HashMap<Integer, String>();
    @Deprecated
    private List<Action> actions;
    private transient boolean visited = false;
    private List<PanelActionConfiguration> preConstructionActions = null;
    private List<PanelActionConfiguration> preActivationActions = null;
    private List<PanelActionConfiguration> preValidationActions = null;
    private List<PanelActionConfiguration> postValidationActions = null;
    private List<Help> helps = null;
    private Map<String, ConfigurationOption> configuration = null;
    private ConfirmQuitType confirmQuitType = ConfirmQuitType.DYNAMIC;

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public boolean hasPanelId() {
        return this.panelId != null;
    }

    public String getPanelId() {
        return this.panelId;
    }

    public void setPanelId(String panelId) {
        this.panelId = panelId;
    }

    @Deprecated
    public String getPanelid() {
        return this.getPanelId();
    }

    @Deprecated
    public void setPanelid(String panelId) {
        this.setPanelId(panelId);
    }

    public String getCondition() {
        return this.condition;
    }

    public void setCondition(String condition) {
        this.condition = condition;
    }

    public boolean hasCondition() {
        return this.condition != null;
    }

    public String getDisplayHiddenCondition() {
        return this.displayHiddenCondition;
    }

    public void setDisplayHiddenCondition(String condition) {
        this.displayHiddenCondition = condition;
    }

    public boolean hasDisplayHiddenCondition() {
        return this.displayHiddenCondition != null;
    }

    public boolean isDisplayHidden() {
        return this.displayHidden;
    }

    public void setDisplayHidden(boolean flag) {
        this.displayHidden = flag;
    }

    public boolean isReadonly() {
        return this.readonly;
    }

    public void setReadonly(boolean flag) {
        this.readonly = flag;
    }

    public String getReadonlyCondition() {
        return this.readonlyCondition;
    }

    public void setReadonlyCondition(String condition) {
        this.readonlyCondition = condition;
    }

    public boolean hasReadonlyCondition() {
        return this.readonlyCondition != null;
    }

    public List<String> getValidators() {
        return this.validators;
    }

    public String getValidatorCondition(int index) {
        return this.validatorConditionIds.get(index);
    }

    public void addValidator(String validatorClassName, String validatorConditionId) {
        this.validators.add(validatorClassName);
        if (validatorConditionId != null) {
            this.validatorConditionIds.put(this.validators.size() - 1, validatorConditionId);
        }
    }

    public List<Help> getHelps() {
        return this.helps;
    }

    public void setHelps(List<Help> helps) {
        this.helps = helps;
    }

    public List<PanelActionConfiguration> getPreConstructionActions() {
        return this.preConstructionActions;
    }

    public void addPreConstructionAction(PanelActionConfiguration action) {
        if (this.preConstructionActions == null) {
            this.preConstructionActions = new ArrayList<PanelActionConfiguration>();
        }
        this.preConstructionActions.add(action);
    }

    public List<PanelActionConfiguration> getPreActivationActions() {
        return this.preActivationActions;
    }

    public void addPreActivationAction(PanelActionConfiguration action) {
        if (this.preActivationActions == null) {
            this.preActivationActions = new ArrayList<PanelActionConfiguration>();
        }
        this.preActivationActions.add(action);
    }

    public List<PanelActionConfiguration> getPreValidationActions() {
        return this.preValidationActions;
    }

    public void addPreValidationAction(PanelActionConfiguration action) {
        if (this.preValidationActions == null) {
            this.preValidationActions = new ArrayList<PanelActionConfiguration>();
        }
        this.preValidationActions.add(action);
    }

    public List<PanelActionConfiguration> getPostValidationActions() {
        return this.postValidationActions;
    }

    public void addPostValidationAction(PanelActionConfiguration action) {
        if (this.postValidationActions == null) {
            this.postValidationActions = new ArrayList<PanelActionConfiguration>();
        }
        this.postValidationActions.add(action);
    }

    public void addConfigurationOption(String name, ConfigurationOption option) {
        if (this.configuration == null) {
            this.configuration = new HashMap<String, ConfigurationOption>();
        }
        this.configuration.put(name, option);
    }

    public String getConfigurationOptionValue(String name, RulesEngine rules) {
        String result = null;
        ConfigurationOption option = null;
        if (this.configuration != null) {
            option = this.configuration.get(name);
        }
        if (option != null) {
            result = option.getValue(rules);
        }
        return result;
    }

    public List<OsModel> getOsConstraints() {
        return this.osConstraints;
    }

    public void setOsConstraints(List<OsModel> osConstraints) {
        this.osConstraints = osConstraints;
    }

    public String getHelpUrl(String localeISO3) {
        if (this.helps == null) {
            return null;
        }
        for (Help help : this.helps) {
            if (!help.getIso3().equals(localeISO3)) continue;
            return help.getSrc();
        }
        return null;
    }

    @Deprecated
    public List<Action> getActions() {
        return this.actions;
    }

    @Deprecated
    public void setActions(List<Action> actions) {
        this.actions = actions;
    }

    public boolean isVisited() {
        return this.visited;
    }

    public void setVisited(boolean visited) {
        this.visited = visited;
    }

    public Set<String> getAffectedVariableNames() {
        return this.affectedVariableNames;
    }

    public void setAffectedVariableNames(Set<String> names) {
        this.affectedVariableNames = names;
    }

    public ConfirmQuitType getConfirmQuitType() {
        return this.confirmQuitType;
    }

    public void setConfirmQuitType(ConfirmQuitType value) {
        this.confirmQuitType = value;
    }

    public String toString() {
        return "Panel{className='" + this.className + '\'' + ", osConstraints=" + this.osConstraints + ", panelid='" + this.getPanelId() + '\'' + ", condition='" + this.condition + '\'' + ", actions=" + this.actions + ", validator count='" + this.validators.size() + '\'' + ", helps=" + this.helps + '\'' + ", affected variables count='" + this.affectedVariableNames.size() + '\'' + '}';
    }

    public static enum ConfirmQuitType {
        DYNAMIC,
        CONFIRM,
        SILENT;

    }
}

