/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swinghelper.debug;

import griffon.core.GriffonExceptionHandler;
import java.applet.Applet;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Window;
import java.lang.ref.WeakReference;
import javax.swing.JComponent;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckThreadViolationRepaintManager
extends RepaintManager {
    private static final Logger LOG = LoggerFactory.getLogger(CheckThreadViolationRepaintManager.class);
    private boolean completeCheck = true;
    private WeakReference<JComponent> lastComponent;
    private final RepaintManager delegate;

    public CheckThreadViolationRepaintManager() {
        this(new RepaintManager());
    }

    public CheckThreadViolationRepaintManager(RepaintManager delegate) {
        if (delegate == null || delegate instanceof CheckThreadViolationRepaintManager) {
            throw new IllegalArgumentException();
        }
        this.delegate = delegate;
    }

    public boolean isCompleteCheck() {
        return this.completeCheck;
    }

    public void setCompleteCheck(boolean completeCheck) {
        this.completeCheck = completeCheck;
    }

    @Override
    public synchronized void addInvalidComponent(JComponent component) {
        this.checkThreadViolations(component);
        this.delegate.addInvalidComponent(component);
    }

    @Override
    public void addDirtyRegion(JComponent component, int x, int y, int w, int h) {
        this.checkThreadViolations(component);
        this.delegate.addDirtyRegion(component, x, y, w, h);
    }

    private void checkThreadViolations(JComponent c) {
        if (!SwingUtilities.isEventDispatchThread() && (this.completeCheck || c.isShowing())) {
            StackTraceElement[] stackTrace;
            boolean repaint = false;
            boolean fromSwing = false;
            boolean imageUpdate = false;
            for (StackTraceElement st : stackTrace = Thread.currentThread().getStackTrace()) {
                if (repaint && st.getClassName().startsWith("javax.swing.") && !st.getClassName().startsWith("javax.swing.SwingWorker")) {
                    fromSwing = true;
                }
                if (repaint && "imageUpdate".equals(st.getMethodName())) {
                    imageUpdate = true;
                }
                if (!"repaint".equals(st.getMethodName())) continue;
                repaint = true;
                fromSwing = false;
            }
            if (imageUpdate) {
                return;
            }
            if (repaint && !fromSwing) {
                return;
            }
            if (this.lastComponent != null && c == this.lastComponent.get()) {
                return;
            }
            this.lastComponent = new WeakReference<JComponent>(c);
            this.violationFound(c, stackTrace);
        }
    }

    protected void violationFound(JComponent c, StackTraceElement[] stackTrace) {
        stackTrace = GriffonExceptionHandler.sanitize((StackTraceElement[])stackTrace);
        StringBuilder sb = new StringBuilder("EDT violation detected").append('\n');
        sb.append(c).append('\n');
        for (StackTraceElement st : stackTrace) {
            sb.append("\tat ").append(st).append('\n');
        }
        if (LOG.isWarnEnabled()) {
            LOG.warn(sb.toString());
        }
    }

    public static RepaintManager currentManager(Component component) {
        return RepaintManager.currentManager(component);
    }

    public static RepaintManager currentManager(JComponent jComponent) {
        return RepaintManager.currentManager(jComponent);
    }

    @Override
    public Rectangle getDirtyRegion(JComponent jComponent) {
        return this.delegate.getDirtyRegion(jComponent);
    }

    @Override
    public Dimension getDoubleBufferMaximumSize() {
        return this.delegate.getDoubleBufferMaximumSize();
    }

    @Override
    public Image getOffscreenBuffer(Component component, int i, int i1) {
        return this.delegate.getOffscreenBuffer(component, i, i1);
    }

    @Override
    public Image getVolatileOffscreenBuffer(Component component, int i, int i1) {
        return this.delegate.getVolatileOffscreenBuffer(component, i, i1);
    }

    @Override
    public boolean isCompletelyDirty(JComponent jComponent) {
        return this.delegate.isCompletelyDirty(jComponent);
    }

    @Override
    public boolean isDoubleBufferingEnabled() {
        return this.delegate.isDoubleBufferingEnabled();
    }

    @Override
    public void markCompletelyClean(JComponent jComponent) {
        this.delegate.markCompletelyClean(jComponent);
    }

    @Override
    public void markCompletelyDirty(JComponent jComponent) {
        this.delegate.markCompletelyDirty(jComponent);
    }

    @Override
    public void paintDirtyRegions() {
        this.delegate.paintDirtyRegions();
    }

    @Override
    public void removeInvalidComponent(JComponent jComponent) {
        this.delegate.removeInvalidComponent(jComponent);
    }

    public static void setCurrentManager(RepaintManager repaintManager) {
        RepaintManager.setCurrentManager(repaintManager);
    }

    @Override
    public void setDoubleBufferingEnabled(boolean b) {
        this.delegate.setDoubleBufferingEnabled(b);
    }

    @Override
    public void setDoubleBufferMaximumSize(Dimension dimension) {
        this.delegate.setDoubleBufferMaximumSize(dimension);
    }

    @Override
    public String toString() {
        return this.delegate.toString();
    }

    @Override
    public void validateInvalidComponents() {
        this.delegate.validateInvalidComponents();
    }

    @Override
    public void addDirtyRegion(Window window, int i, int i1, int i2, int i3) {
        this.delegate.addDirtyRegion(window, i, i1, i2, i3);
    }

    @Override
    public void addDirtyRegion(Applet applet, int i, int i1, int i2, int i3) {
        this.delegate.addDirtyRegion(applet, i, i1, i2, i3);
    }
}

