/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.runtime.swing.controller;

import griffon.core.artifact.GriffonController;
import griffon.core.controller.ActionManager;
import griffon.core.controller.ActionMetadata;
import griffon.core.editors.PropertyEditorResolver;
import griffon.core.threading.UIThreadManager;
import griffon.swing.support.SwingAction;
import griffon.util.GriffonNameUtils;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyEditor;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.swing.Icon;
import javax.swing.KeyStroke;
import org.codehaus.griffon.runtime.core.controller.AbstractAction;

public class SwingGriffonControllerAction
extends AbstractAction {
    public static final String KEY_SHORT_DESCRIPTION = "shortDescription";
    public static final String KEY_LONG_DESCRIPTION = "longDescription";
    public static final String KEY_SMALL_ICON = "smallIcon";
    public static final String KEY_LARGE_ICON = "largeIcon";
    public static final String KEY_SELECTED = "selected";
    public static final String KEY_ACCELERATOR = "accelerator";
    public static final String KEY_MNEMONIC = "mnemonic";
    public static final String KEY_COMMAND = "command";
    private final SwingAction toolkitAction;
    private String shortDescription;
    private String longDescription;
    private String smallIcon;
    private String largeIcon;
    private String accelerator;
    private String mnemonic;
    private String command;
    private boolean selected;

    public SwingGriffonControllerAction(@Nonnull UIThreadManager uiThreadManager, @Nonnull ActionManager actionManager, @Nonnull GriffonController controller, @Nonnull ActionMetadata actionMetadata) {
        super(actionManager, controller, actionMetadata);
        Objects.requireNonNull(uiThreadManager, "Argument 'uiThreadManager' must not be null");
        this.toolkitAction = this.createAction(actionManager, controller, actionMetadata.getActionName());
        this.addPropertyChangeListener(evt -> uiThreadManager.runInsideUIAsync(() -> this.handlePropertyChange(evt)));
    }

    @Nonnull
    protected SwingAction createAction(@Nonnull ActionManager actionManager, @Nonnull GriffonController controller, @Nonnull String actionName) {
        return new SwingAction(args -> actionManager.invokeAction(controller, actionName, args));
    }

    protected void handlePropertyChange(@Nonnull PropertyChangeEvent evt) {
        if ("name".equals(evt.getPropertyName())) {
            this.toolkitAction.putValue("Name", evt.getNewValue());
        } else if (KEY_COMMAND.equals(evt.getPropertyName())) {
            this.toolkitAction.putValue("ActionCommandKey", evt.getNewValue());
        } else if (KEY_SHORT_DESCRIPTION.equals(evt.getPropertyName())) {
            this.toolkitAction.putValue("ShortDescription", evt.getNewValue());
        } else if (KEY_LONG_DESCRIPTION.equals(evt.getPropertyName())) {
            this.toolkitAction.putValue("LongDescription", evt.getNewValue());
        } else if ("enabled".equals(evt.getPropertyName())) {
            this.toolkitAction.setEnabled((Boolean)evt.getNewValue());
        } else if (KEY_SELECTED.equals(evt.getPropertyName())) {
            this.toolkitAction.putValue("SwingSelectedKey", evt.getNewValue());
        } else if (KEY_MNEMONIC.equals(evt.getPropertyName())) {
            String mnemonic = (String)evt.getNewValue();
            if (GriffonNameUtils.isNotBlank((String)mnemonic)) {
                this.toolkitAction.putValue("MnemonicKey", KeyStroke.getKeyStroke(mnemonic).getKeyCode());
            }
        } else if (KEY_ACCELERATOR.equals(evt.getPropertyName())) {
            String accelerator = (String)evt.getNewValue();
            if (GriffonNameUtils.isNotBlank((String)accelerator)) {
                this.toolkitAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(accelerator));
            }
        } else if (KEY_SMALL_ICON.equals(evt.getPropertyName())) {
            this.handleIcon(evt.getNewValue(), "SmallIcon");
        } else if (KEY_LARGE_ICON.equals(evt.getPropertyName())) {
            this.handleIcon(evt.getNewValue(), "SwingLargeIconKey");
        }
    }

    protected void handleIcon(@Nullable Object value, @Nonnull String key) {
        if (value != null) {
            PropertyEditor editor = PropertyEditorResolver.findEditor(Icon.class);
            editor.setValue(value);
            this.toolkitAction.putValue(key, editor.getValue());
        }
    }

    protected void doInitialize() {
        String accelerator;
        this.toolkitAction.putValue("Name", this.getName());
        this.toolkitAction.putValue("ActionCommandKey", this.getCommand());
        this.toolkitAction.putValue("ShortDescription", this.getShortDescription());
        this.toolkitAction.putValue("LongDescription", this.getLongDescription());
        this.toolkitAction.setEnabled(this.isEnabled());
        this.toolkitAction.putValue("SwingSelectedKey", this.isSelected());
        String mnemonic = this.getMnemonic();
        if (GriffonNameUtils.isNotBlank((String)mnemonic)) {
            this.toolkitAction.putValue("MnemonicKey", KeyStroke.getKeyStroke(mnemonic).getKeyCode());
        }
        if (GriffonNameUtils.isNotBlank((String)(accelerator = this.getAccelerator()))) {
            this.toolkitAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(accelerator));
        }
        this.handleIcon(this.getSmallIcon(), "SmallIcon");
        this.handleIcon(this.getLargeIcon(), "SwingLargeIconKey");
    }

    @Nullable
    public String getAccelerator() {
        return this.accelerator;
    }

    public void setAccelerator(@Nullable String accelerator) {
        this.accelerator = accelerator;
        this.firePropertyChange(KEY_ACCELERATOR, this.accelerator, this.accelerator);
    }

    @Nullable
    public String getLargeIcon() {
        return this.largeIcon;
    }

    public void setLargeIcon(@Nullable String largeIcon) {
        this.largeIcon = largeIcon;
        this.firePropertyChange(KEY_LARGE_ICON, this.largeIcon, this.largeIcon);
    }

    @Nullable
    public String getLongDescription() {
        return this.longDescription;
    }

    public void setLongDescription(@Nullable String longDescription) {
        this.longDescription = longDescription;
        this.firePropertyChange(KEY_LONG_DESCRIPTION, this.longDescription, this.longDescription);
    }

    @Nullable
    public String getMnemonic() {
        return this.mnemonic;
    }

    public void setMnemonic(@Nullable String mnemonic) {
        this.mnemonic = mnemonic;
        this.firePropertyChange(KEY_MNEMONIC, this.mnemonic, this.mnemonic);
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
        this.firePropertyChange(KEY_SELECTED, this.selected, this.selected);
    }

    @Nullable
    public String getShortDescription() {
        return this.shortDescription;
    }

    public void setShortDescription(@Nullable String shortDescription) {
        this.shortDescription = shortDescription;
        this.firePropertyChange(KEY_SHORT_DESCRIPTION, this.shortDescription, this.shortDescription);
    }

    @Nullable
    public String getSmallIcon() {
        return this.smallIcon;
    }

    public void setSmallIcon(@Nullable String smallIcon) {
        this.smallIcon = smallIcon;
        this.firePropertyChange(KEY_SMALL_ICON, this.smallIcon, this.smallIcon);
    }

    @Nullable
    public String getCommand() {
        return this.command;
    }

    public void setCommand(@Nullable String command) {
        this.command = command;
        this.firePropertyChange(KEY_SMALL_ICON, this.command, this.command);
    }

    @Nonnull
    public Object getToolkitAction() {
        return this.toolkitAction;
    }

    protected void doExecute(Object ... args) {
        ActionEvent event = null;
        if (args != null && args.length == 1 && args[0] instanceof ActionEvent) {
            event = (ActionEvent)args[0];
        }
        this.toolkitAction.actionPerformed(event);
    }
}

