/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.runtime.swing.controller;

import griffon.core.GriffonApplication;
import griffon.core.artifact.GriffonController;
import griffon.core.controller.Action;
import griffon.core.controller.ActionFactory;
import griffon.core.controller.ActionMetadataFactory;
import griffon.util.GriffonApplicationUtils;
import griffon.util.GriffonNameUtils;
import griffon.util.TypeUtils;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import org.codehaus.griffon.runtime.core.controller.AbstractActionManager;
import org.codehaus.griffon.runtime.swing.controller.SwingGriffonControllerAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwingActionManager
extends AbstractActionManager {
    private static final Logger LOG = LoggerFactory.getLogger(SwingActionManager.class);
    private static final String KEY_SELECTED = "selected";
    private static final String KEY_ENABLED = "enabled";
    private static final String KEY_LARGE_ICON = "large_icon";
    private static final String KEY_SMALL_ICON = "small_icon";
    private static final String KEY_LONG_DESCRIPTION = "long_description";
    private static final String KEY_SHORT_DESCRIPTION = "short_description";
    private static final String KEY_COMMAND = "command";
    private static final String KEY_ACCELERATOR = "accelerator";
    private static final String KEY_NAME = "name";
    private static final String KEY_MNEMONIC = "mnemonic";
    private static final String KEY_CTRL = "ctrl";
    private static final String KEY_META = "meta";
    private static final String EMPTY_STRING = "";
    private static final String DOT = ".";
    private static final String EQUALS = " = ";

    @Inject
    public SwingActionManager(@Nonnull GriffonApplication application, @Nonnull ActionFactory actionFactory, @Nonnull ActionMetadataFactory actionMetadataFactory) {
        super(application, actionFactory, actionMetadataFactory);
    }

    protected void doConfigureAction(@Nonnull Action action, @Nonnull GriffonController controller, @Nonnull String normalizeNamed, @Nonnull String keyPrefix) {
        controller.getApplication().addPropertyChangeListener("locale", evt -> this.configureAction((SwingGriffonControllerAction)action, controller, normalizeNamed, keyPrefix));
        this.configureAction((SwingGriffonControllerAction)action, controller, normalizeNamed, keyPrefix);
    }

    protected void configureAction(@Nonnull SwingGriffonControllerAction action, @Nonnull GriffonController controller, @Nonnull String normalizeNamed, @Nonnull String keyPrefix) {
        this.resolveName(action, controller, normalizeNamed, keyPrefix);
        this.resolveAccelerator(action, controller, normalizeNamed, keyPrefix);
        this.resolveCommand(action, controller, normalizeNamed, keyPrefix);
        this.resolveShortDescription(action, controller, normalizeNamed, keyPrefix);
        this.resolveLongDescription(action, controller, normalizeNamed, keyPrefix);
        this.resolveMnemonic(action, controller, normalizeNamed, keyPrefix);
        this.resolveSmallIcon(action, controller, normalizeNamed, keyPrefix);
        this.resolveLargeIcon(action, controller, normalizeNamed, keyPrefix);
        this.resolveEnabled(action, controller, normalizeNamed, keyPrefix);
        this.resolveSelected(action, controller, normalizeNamed, keyPrefix);
    }

    protected void resolveName(@Nonnull SwingGriffonControllerAction action, @Nonnull GriffonController controller, @Nonnull String normalizeNamed, @Nonnull String keyPrefix) {
        String rsActionName = this.msg(keyPrefix, normalizeNamed, KEY_NAME, GriffonNameUtils.getNaturalName((String)normalizeNamed));
        if (GriffonNameUtils.isNotBlank((String)rsActionName)) {
            this.trace(keyPrefix + normalizeNamed, KEY_NAME, rsActionName);
            action.setName(rsActionName);
        }
    }

    protected void resolveAccelerator(@Nonnull SwingGriffonControllerAction action, @Nonnull GriffonController controller, @Nonnull String normalizeNamed, @Nonnull String keyPrefix) {
        String rsAccelerator = this.msg(keyPrefix, normalizeNamed, KEY_ACCELERATOR, EMPTY_STRING);
        if (GriffonNameUtils.isNotBlank((String)rsAccelerator)) {
            if (!GriffonApplicationUtils.isMacOSX() && rsAccelerator.contains(KEY_META) && !rsAccelerator.contains(KEY_CTRL)) {
                rsAccelerator = rsAccelerator.replace(KEY_META, KEY_CTRL);
            }
            this.trace(keyPrefix + normalizeNamed, KEY_ACCELERATOR, rsAccelerator);
            action.setAccelerator(rsAccelerator);
        }
    }

    protected void resolveCommand(@Nonnull SwingGriffonControllerAction action, @Nonnull GriffonController controller, @Nonnull String normalizeNamed, @Nonnull String keyPrefix) {
        String rsCommand = this.msg(keyPrefix, normalizeNamed, KEY_COMMAND, EMPTY_STRING);
        if (GriffonNameUtils.isNotBlank((String)rsCommand)) {
            this.trace(keyPrefix + normalizeNamed, KEY_COMMAND, rsCommand);
            action.setCommand(rsCommand);
        }
    }

    protected void resolveShortDescription(@Nonnull SwingGriffonControllerAction action, @Nonnull GriffonController controller, @Nonnull String normalizeNamed, @Nonnull String keyPrefix) {
        String rsShortDescription = this.msg(keyPrefix, normalizeNamed, KEY_SHORT_DESCRIPTION, EMPTY_STRING);
        if (GriffonNameUtils.isNotBlank((String)rsShortDescription)) {
            this.trace(keyPrefix + normalizeNamed, KEY_SHORT_DESCRIPTION, rsShortDescription);
            action.setShortDescription(rsShortDescription);
        }
    }

    protected void resolveLongDescription(@Nonnull SwingGriffonControllerAction action, @Nonnull GriffonController controller, @Nonnull String normalizeNamed, @Nonnull String keyPrefix) {
        String rsLongDescription = this.msg(keyPrefix, normalizeNamed, KEY_LONG_DESCRIPTION, EMPTY_STRING);
        if (GriffonNameUtils.isNotBlank((String)rsLongDescription)) {
            this.trace(keyPrefix + normalizeNamed, KEY_LONG_DESCRIPTION, rsLongDescription);
            action.setLongDescription(rsLongDescription);
        }
    }

    protected void resolveMnemonic(@Nonnull SwingGriffonControllerAction action, @Nonnull GriffonController controller, @Nonnull String normalizeNamed, @Nonnull String keyPrefix) {
        String rsMnemonic = this.msg(keyPrefix, normalizeNamed, KEY_MNEMONIC, EMPTY_STRING);
        if (GriffonNameUtils.isNotBlank((String)rsMnemonic)) {
            this.trace(keyPrefix + normalizeNamed, KEY_MNEMONIC, rsMnemonic);
            action.setMnemonic(rsMnemonic);
        }
    }

    protected void resolveSmallIcon(@Nonnull SwingGriffonControllerAction action, @Nonnull GriffonController controller, @Nonnull String normalizeNamed, @Nonnull String keyPrefix) {
        String rsSmallIcon = this.msg(keyPrefix, normalizeNamed, KEY_SMALL_ICON, EMPTY_STRING);
        if (GriffonNameUtils.isNotBlank((String)rsSmallIcon)) {
            this.trace(keyPrefix + normalizeNamed, KEY_SMALL_ICON, rsSmallIcon);
            action.setSmallIcon(rsSmallIcon);
        }
    }

    protected void resolveLargeIcon(@Nonnull SwingGriffonControllerAction action, @Nonnull GriffonController controller, @Nonnull String normalizeNamed, @Nonnull String keyPrefix) {
        String rsLargeIcon = this.msg(keyPrefix, normalizeNamed, KEY_LARGE_ICON, EMPTY_STRING);
        if (GriffonNameUtils.isNotBlank((String)rsLargeIcon)) {
            this.trace(keyPrefix + normalizeNamed, KEY_LARGE_ICON, rsLargeIcon);
            action.setLargeIcon(rsLargeIcon);
        }
    }

    protected void resolveEnabled(@Nonnull SwingGriffonControllerAction action, @Nonnull GriffonController controller, @Nonnull String normalizeNamed, @Nonnull String keyPrefix) {
        String rsEnabled = this.msg(keyPrefix, normalizeNamed, KEY_ENABLED, "true");
        if (GriffonNameUtils.isNotBlank((String)rsEnabled)) {
            this.trace(keyPrefix + normalizeNamed, KEY_ENABLED, rsEnabled);
            action.setEnabled(TypeUtils.castToBoolean((Object)rsEnabled));
        }
    }

    protected void resolveSelected(@Nonnull SwingGriffonControllerAction action, @Nonnull GriffonController controller, @Nonnull String normalizeNamed, @Nonnull String keyPrefix) {
        String rsSelected = this.msg(keyPrefix, normalizeNamed, KEY_SELECTED, "false");
        if (GriffonNameUtils.isNotBlank((String)rsSelected)) {
            this.trace(keyPrefix + normalizeNamed, KEY_SELECTED, rsSelected);
            action.setSelected(TypeUtils.castToBoolean((Object)rsSelected));
        }
    }

    protected void trace(@Nonnull String actionKey, @Nonnull String key, @Nonnull String value) {
        if (LOG.isTraceEnabled()) {
            LOG.trace(actionKey + DOT + key + EQUALS + value);
        }
    }
}

