/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.runtime.swing;

import griffon.core.CallableWithArgs;
import griffon.core.GriffonApplication;
import griffon.core.GriffonExceptionHandler;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Named;
import javax.swing.RepaintManager;
import org.codehaus.griffon.runtime.core.addon.AbstractGriffonAddon;
import org.jdesktop.swinghelper.debug.CheckThreadViolationRepaintManager;
import org.jdesktop.swinghelper.debug.EventDispatchThreadHangMonitor;
import sun.awt.AppContext;

@Named(value="swing")
public class SwingAddon
extends AbstractGriffonAddon {
    private static final String SWING_EDT_VIOLATIONS_KEY = "griffon.swing.edt.violations.check";
    private static final String SWING_EDT_HANG_MONITOR_KEY = "griffon.swing.edt.hang.monitor";
    private static final String SWING_EDT_HANG_MONITOR_TIMEOUT_KEY = "griffon.swing.edt.hang.monitor.timeout";
    private static final String[] EXCLUDED_PACKAGES = System.getProperty("groovy.sanitized.stacktraces", "groovy.,org.codehaus.groovy.,java.,javax.,sun.,gjdk.groovy.," + CheckThreadViolationRepaintManager.class.getPackage().getName()).split("(\\s|,)+");

    public void init(@Nonnull GriffonApplication application) {
        String value = System.getProperty(SWING_EDT_VIOLATIONS_KEY);
        if (value != null && Boolean.parseBoolean(value)) {
            RepaintManager currentRepaintManager;
            if (this.getLog().isInfoEnabled()) {
                this.getLog().info("EDT violations check enabled.");
            }
            if (null == (currentRepaintManager = this.getCurrentRepaintManager())) {
                currentRepaintManager = new RepaintManager();
            }
            if (currentRepaintManager instanceof CheckThreadViolationRepaintManager) {
                return;
            }
            RepaintManager.setCurrentManager(new CheckThreadViolationRepaintManager(currentRepaintManager));
            GriffonExceptionHandler.addClassTest((CallableWithArgs)new CallableWithArgs<Boolean>(){

                @Nullable
                public Boolean call(Object ... args) {
                    String className = (String)args[0];
                    for (String groovyPackage : EXCLUDED_PACKAGES) {
                        if (!className.startsWith(groovyPackage)) continue;
                        return false;
                    }
                    return true;
                }
            });
        }
        if ((value = System.getProperty(SWING_EDT_HANG_MONITOR_KEY)) != null && Boolean.parseBoolean(value)) {
            if (this.getLog().isInfoEnabled()) {
                this.getLog().info("EDT hang monitor enabled.");
            }
            EventDispatchThreadHangMonitor.initMonitoring();
            value = System.getProperty(SWING_EDT_HANG_MONITOR_TIMEOUT_KEY);
            if (value != null) {
                try {
                    EventDispatchThreadHangMonitor.getInstance().setTimeout(Long.parseLong(value));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
    }

    private RepaintManager getCurrentRepaintManager() {
        return (RepaintManager)AppContext.getAppContext().get(RepaintManager.class);
    }
}

