/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.runtime.swing;

import griffon.core.ApplicationEvent;
import griffon.core.GriffonApplication;
import griffon.core.env.ApplicationPhase;
import griffon.core.view.WindowDisplayHandler;
import griffon.swing.SwingWindowDisplayHandler;
import griffon.swing.SwingWindowManager;
import griffon.util.GriffonNameUtils;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.swing.JInternalFrame;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import org.codehaus.griffon.runtime.core.view.AbstractWindowManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSwingWindowManager
extends AbstractWindowManager<Window>
implements SwingWindowManager {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultSwingWindowManager.class);
    private final WindowHelper windowHelper = new WindowHelper();
    private final ComponentHelper componentHelper = new ComponentHelper();
    private final InternalFrameHelper internalFrameHelper = new InternalFrameHelper();
    private final Map<String, JInternalFrame> internalFrames = Collections.synchronizedMap(new LinkedHashMap());
    private boolean hideBeforeHandler = false;

    @Inject
    @Nonnull
    public DefaultSwingWindowManager(@Nonnull GriffonApplication application, @Nonnull @Named(value="windowDisplayHandler") SwingWindowDisplayHandler windowDisplayHandler) {
        super(application, (WindowDisplayHandler)windowDisplayHandler);
        Objects.requireNonNull(application.getEventRouter(), "Argument 'application.eventRouter' must not be null");
    }

    public JInternalFrame findInternalFrame(String name) {
        if (!GriffonNameUtils.isBlank((String)name)) {
            for (JInternalFrame internalFrame : this.internalFrames.values()) {
                if (!name.equals(internalFrame.getName())) continue;
                return internalFrame;
            }
        }
        return null;
    }

    @Override
    @Nonnull
    public Set<String> getInternalWindowNames() {
        return Collections.unmodifiableSet(this.internalFrames.keySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public String findInternalWindowName(@Nonnull JInternalFrame window) {
        Objects.requireNonNull(window, "Argument 'window' must not be null");
        Map<String, JInternalFrame> map = this.internalFrames;
        synchronized (map) {
            for (Map.Entry<String, JInternalFrame> e : this.internalFrames.entrySet()) {
                if (!e.getValue().equals(window)) continue;
                return e.getKey();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int indexOfInternal(@Nonnull JInternalFrame window) {
        Objects.requireNonNull(window, "Argument 'window' must not be null");
        Map<String, JInternalFrame> map = this.internalFrames;
        synchronized (map) {
            int index = 0;
            for (JInternalFrame w : this.internalFrames.values()) {
                if (window.equals(w)) {
                    return index;
                }
                ++index;
            }
        }
        return -1;
    }

    public Collection<JInternalFrame> getInternalFrames() {
        return Collections.unmodifiableCollection(this.internalFrames.values());
    }

    public void attach(@Nonnull String name, @Nonnull JInternalFrame internalFrame) {
        JInternalFrame window2;
        GriffonNameUtils.requireNonBlank((String)name, (String)"Argument 'name' must not be blank");
        Objects.requireNonNull(internalFrame, "Argument 'window' must not be null");
        if (this.internalFrames.containsKey(name) && (window2 = this.internalFrames.get(name)) != internalFrame) {
            this.detach(name);
        }
        this.doAttach(internalFrame);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Attaching internal frame with name: '" + name + "' at index " + this.internalFrames.size() + " " + internalFrame);
        }
        this.internalFrames.put(name, internalFrame);
        this.event(ApplicationEvent.WINDOW_ATTACHED, Arrays.asList(name, internalFrame));
    }

    protected void doAttach(@Nonnull JInternalFrame internalFrame) {
        internalFrame.addInternalFrameListener(this.internalFrameHelper);
        internalFrame.setDefaultCloseOperation(0);
    }

    public void detach(@Nonnull String name) {
        GriffonNameUtils.requireNonBlank((String)name, (String)"Argument 'name' must not be blank");
        if (this.internalFrames.containsKey(name)) {
            JInternalFrame window = this.internalFrames.get(name);
            this.doDetach(window);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Detaching internalFrame with name: '" + name + "' " + window);
            }
            this.internalFrames.remove(name);
            this.event(ApplicationEvent.WINDOW_DETACHED, Arrays.asList(name, window));
        }
    }

    protected void doDetach(@Nonnull JInternalFrame internalFrame) {
        internalFrame.removeInternalFrameListener(this.internalFrameHelper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void show(@Nonnull JInternalFrame internalFrame) {
        Objects.requireNonNull(internalFrame, "Argument 'window' must not be null");
        if (!this.internalFrames.containsValue(internalFrame)) {
            return;
        }
        String windowName = null;
        int windowIndex = -1;
        Map<String, JInternalFrame> map = this.internalFrames;
        synchronized (map) {
            int i = 0;
            for (Map.Entry<String, JInternalFrame> entry : this.internalFrames.entrySet()) {
                if (entry.getValue() == internalFrame) {
                    windowName = entry.getKey();
                    windowIndex = i;
                    break;
                }
                ++i;
            }
        }
        String name = windowName;
        int index = windowIndex;
        this.getApplication().getUIThreadManager().runInsideUIAsync(() -> {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Showing window with name: '" + name + "' at index " + index + " " + internalFrame);
            }
            this.resolveSwingWindowDisplayHandler().show(name, internalFrame);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void hide(@Nonnull JInternalFrame internalFrame) {
        Objects.requireNonNull(internalFrame, "Argument 'window' must not be null");
        if (!this.internalFrames.containsValue(internalFrame)) {
            return;
        }
        String windowName = null;
        int windowIndex = -1;
        Map<String, JInternalFrame> map = this.internalFrames;
        synchronized (map) {
            int i = 0;
            for (Map.Entry<String, JInternalFrame> entry : this.internalFrames.entrySet()) {
                if (entry.getValue() == internalFrame) {
                    windowName = entry.getKey();
                    windowIndex = i;
                    break;
                }
                ++i;
            }
        }
        String name = windowName;
        int index = windowIndex;
        this.getApplication().getUIThreadManager().runInsideUIAsync(() -> {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Hiding window with name: '" + name + "' at index " + index + " " + internalFrame);
            }
            this.resolveSwingWindowDisplayHandler().hide(name, internalFrame);
        });
    }

    public boolean isHideBeforeHandler() {
        return this.hideBeforeHandler;
    }

    public void setHideBeforeHandler(boolean hideBeforeHandler) {
        this.hideBeforeHandler = hideBeforeHandler;
    }

    @Nonnull
    protected SwingWindowDisplayHandler resolveSwingWindowDisplayHandler() {
        return (SwingWindowDisplayHandler)this.resolveWindowDisplayHandler();
    }

    protected void doAttach(@Nonnull Window window) {
        Objects.requireNonNull(window, "Argument 'window' must not be null");
        window.addWindowListener(this.windowHelper);
        window.addComponentListener(this.componentHelper);
    }

    protected void doDetach(@Nonnull Window window) {
        Objects.requireNonNull(window, "Argument 'window' must not be null");
        window.removeWindowListener(this.windowHelper);
        window.removeComponentListener(this.componentHelper);
    }

    protected boolean isWindowVisible(@Nonnull Window window) {
        Objects.requireNonNull(window, "Argument 'window' must not be null");
        return window.isVisible();
    }

    private class InternalFrameHelper
    extends InternalFrameAdapter {
        private InternalFrameHelper() {
        }

        @Override
        public void internalFrameClosing(InternalFrameEvent event) {
            DefaultSwingWindowManager.this.hide(event.getInternalFrame());
        }

        @Override
        public void internalFrameOpened(InternalFrameEvent event) {
            JInternalFrame window = (JInternalFrame)event.getSource();
            DefaultSwingWindowManager.this.event(ApplicationEvent.WINDOW_SHOWN, Arrays.asList(DefaultSwingWindowManager.this.findInternalWindowName(window), window));
        }

        @Override
        public void internalFrameClosed(InternalFrameEvent event) {
            JInternalFrame window = (JInternalFrame)event.getSource();
            DefaultSwingWindowManager.this.event(ApplicationEvent.WINDOW_HIDDEN, Arrays.asList(DefaultSwingWindowManager.this.findInternalWindowName(window), window));
        }
    }

    private class ComponentHelper
    extends ComponentAdapter {
        private ComponentHelper() {
        }

        @Override
        public void componentShown(ComponentEvent event) {
            Window window = (Window)event.getSource();
            DefaultSwingWindowManager.this.event(ApplicationEvent.WINDOW_SHOWN, Arrays.asList(DefaultSwingWindowManager.this.findWindowName(window), window));
        }

        @Override
        public void componentHidden(ComponentEvent event) {
            Window window = (Window)event.getSource();
            DefaultSwingWindowManager.this.event(ApplicationEvent.WINDOW_HIDDEN, Arrays.asList(DefaultSwingWindowManager.this.findWindowName(window), window));
        }
    }

    private class WindowHelper
    extends WindowAdapter {
        private WindowHelper() {
        }

        @Override
        public void windowClosing(WindowEvent event) {
            if (DefaultSwingWindowManager.this.getApplication().getPhase() == ApplicationPhase.SHUTDOWN) {
                return;
            }
            int visibleWindows = DefaultSwingWindowManager.this.countVisibleWindows();
            if (DefaultSwingWindowManager.this.isHideBeforeHandler() || visibleWindows > 0) {
                DefaultSwingWindowManager.this.hide(event.getWindow());
            }
            if (visibleWindows <= 1 && DefaultSwingWindowManager.this.isAutoShutdown()) {
                LOG.debug("Attempting to shutdown application");
                if (!DefaultSwingWindowManager.this.getApplication().shutdown()) {
                    DefaultSwingWindowManager.this.show(event.getWindow());
                }
            }
        }
    }
}

