/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.runtime.swing;

import griffon.core.CallableWithArgs;
import griffon.core.GriffonApplication;
import griffon.core.RunnableWithArgs;
import griffon.core.view.WindowDisplayHandler;
import griffon.exceptions.InstanceNotFoundException;
import griffon.swing.SwingWindowDisplayHandler;
import griffon.util.AnnotationUtils;
import griffon.util.GriffonNameUtils;
import java.awt.Window;
import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Named;
import javax.swing.JInternalFrame;
import org.codehaus.griffon.runtime.core.view.ConfigurableWindowDisplayHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurableSwingWindowDisplayHandler
extends ConfigurableWindowDisplayHandler<Window>
implements SwingWindowDisplayHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigurableSwingWindowDisplayHandler.class);
    private static final String HANDLER = "handler";

    @Inject
    public ConfigurableSwingWindowDisplayHandler(@Nonnull GriffonApplication application, @Nonnull @Named(value="defaultWindowDisplayHandler") SwingWindowDisplayHandler delegateWindowsDisplayHandler) {
        super(application, (WindowDisplayHandler)delegateWindowsDisplayHandler);
    }

    @Override
    public void show(@Nonnull String name, @Nonnull JInternalFrame window) {
        Object defaultShow;
        Object handler;
        GriffonNameUtils.requireNonBlank((String)name, (String)"Argument 'name' must not be blank");
        Objects.requireNonNull(window, "Argument 'window' must not be null");
        Map options = this.windowBlock(name);
        if (!options.isEmpty()) {
            handler = options.get("show");
            if (this.canBeRun(handler)) {
                LOG.trace("Showing {} with show: handler", (Object)name);
                this.run(handler, name, window);
                return;
            }
            if (options.get(HANDLER) instanceof SwingWindowDisplayHandler) {
                LOG.trace("Showing {} with handler: handler", (Object)name);
                ((SwingWindowDisplayHandler)options.get(HANDLER)).show(name, window);
                return;
            }
        }
        if ((handler = this.resolveSwingWindowDisplayHandler(name)) != null) {
            LOG.trace("Showing {} with injected handler", (Object)name);
            handler.show(name, window);
            return;
        }
        options = this.windowManagerBlock();
        if (!options.isEmpty() && this.canBeRun(defaultShow = options.get("defaultShow"))) {
            LOG.trace("Showing {} with defaultShow: handler", (Object)name);
            this.run(defaultShow, name, window);
            return;
        }
        LOG.trace("Showing {} with default handler", (Object)name);
        this.fetchDefaultWindowDisplayHandler().show(name, window);
    }

    @Override
    public void hide(@Nonnull String name, @Nonnull JInternalFrame window) {
        Object defaultHide;
        Object handler;
        GriffonNameUtils.requireNonBlank((String)name, (String)"Argument 'name' must not be blank");
        Objects.requireNonNull(window, "Argument 'window' must not be null");
        Map options = this.windowBlock(name);
        if (!options.isEmpty()) {
            handler = options.get("hide");
            if (this.canBeRun(handler)) {
                LOG.trace("Hiding {} with hide: handler", (Object)name);
                this.run(handler, name, window);
                return;
            }
            if (options.get(HANDLER) instanceof SwingWindowDisplayHandler) {
                LOG.trace("Hiding {} with handler: handler", (Object)name);
                ((SwingWindowDisplayHandler)options.get(HANDLER)).hide(name, window);
                return;
            }
        }
        if ((handler = this.resolveSwingWindowDisplayHandler(name)) != null) {
            LOG.trace("Hiding {} with injected handler", (Object)name);
            handler.hide(name, window);
            return;
        }
        options = this.windowManagerBlock();
        if (!options.isEmpty() && this.canBeRun(defaultHide = options.get("defaultHide"))) {
            LOG.trace("Hiding {} with defaultHide: handler", (Object)name);
            this.run(defaultHide, name, window);
            return;
        }
        LOG.trace("Hiding {} with default handler", (Object)name);
        this.fetchDefaultWindowDisplayHandler().hide(name, window);
    }

    protected void run(@Nonnull Object handler, @Nonnull String name, @Nonnull JInternalFrame window) {
        if (handler instanceof RunnableWithArgs) {
            ((RunnableWithArgs)handler).run(new Object[]{name, window});
        } else if (handler instanceof CallableWithArgs) {
            ((CallableWithArgs)handler).call(new Object[]{name, window});
        }
    }

    @Nonnull
    protected SwingWindowDisplayHandler fetchDefaultWindowDisplayHandler() {
        Object handler = this.windowManagerBlock().get("defaultHandler");
        return (SwingWindowDisplayHandler)(handler instanceof SwingWindowDisplayHandler ? handler : this.getDelegateWindowsDisplayHandler());
    }

    protected boolean handleShowByInjectedHandler(@Nonnull String name, @Nonnull Window window) {
        try {
            SwingWindowDisplayHandler handler = (SwingWindowDisplayHandler)this.getApplication().getInjector().getInstance(SwingWindowDisplayHandler.class, (Annotation)AnnotationUtils.named((String)name));
            LOG.trace("Showing {} with injected handler", (Object)name);
            handler.show(name, window);
            return true;
        }
        catch (InstanceNotFoundException infe) {
            return super.handleShowByInjectedHandler(name, (Object)window);
        }
    }

    protected boolean handleHideByInjectedHandler(@Nonnull String name, @Nonnull Window window) {
        try {
            SwingWindowDisplayHandler handler = (SwingWindowDisplayHandler)this.getApplication().getInjector().getInstance(SwingWindowDisplayHandler.class, (Annotation)AnnotationUtils.named((String)name));
            LOG.trace("Hiding {} with injected handler", (Object)name);
            handler.hide(name, window);
            return true;
        }
        catch (InstanceNotFoundException infe) {
            return super.handleHideByInjectedHandler(name, (Object)window);
        }
    }

    protected SwingWindowDisplayHandler resolveSwingWindowDisplayHandler(@Nonnull String name) {
        try {
            return (SwingWindowDisplayHandler)this.getApplication().getInjector().getInstance(SwingWindowDisplayHandler.class, (Annotation)AnnotationUtils.named((String)name));
        }
        catch (InstanceNotFoundException infe1) {
            try {
                WindowDisplayHandler handler = (WindowDisplayHandler)this.getApplication().getInjector().getInstance(WindowDisplayHandler.class, (Annotation)AnnotationUtils.named((String)name));
                if (handler instanceof SwingWindowDisplayHandler) {
                    return (SwingWindowDisplayHandler)handler;
                }
            }
            catch (InstanceNotFoundException instanceNotFoundException) {
                // empty catch block
            }
            return null;
        }
    }
}

