/*
 * Decompiled with CFR 0.152.
 */
package griffon.swing.support;

import griffon.core.GriffonApplication;
import griffon.util.GriffonClassUtils;
import griffon.util.GriffonNameUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;

public class SwingUtils {
    private static final String ERROR_WINDOW_NULL = "Argument 'window' must not be null";

    private SwingUtils() {
    }

    public static void centerOnScreen(@Nonnull Window window) {
        Objects.requireNonNull(window, ERROR_WINDOW_NULL);
        Point center = GraphicsEnvironment.getLocalGraphicsEnvironment().getCenterPoint();
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        double w = Math.min(window.getWidth(), screen.width);
        double h = Math.min(window.getHeight(), screen.height);
        int x = (int)((double)center.x - w / 2.0);
        int y = (int)((double)center.y - h / 2.0);
        Point corner = new Point(x >= 0 ? x : 0, y >= 0 ? y : 0);
        window.setLocation(corner);
    }

    public static void centerOnScreen(@Nonnull JInternalFrame internalFrame) {
        Objects.requireNonNull(internalFrame, "Argument 'internalFrame' must not be null");
        JDesktopPane desktop = internalFrame.getDesktopPane();
        if (desktop == null) {
            return;
        }
        Dimension screen = desktop.getSize();
        Point center = new Point(screen.width / 2, screen.height / 2);
        double w = Math.min(internalFrame.getWidth(), screen.width);
        double h = Math.min(internalFrame.getHeight(), screen.height);
        int x = (int)((double)center.x - w / 2.0);
        int y = (int)((double)center.y - h / 2.0);
        Point corner = new Point(x >= 0 ? x : 0, y >= 0 ? y : 0);
        internalFrame.setLocation(corner);
    }

    public static float getWindowOpacity(@Nonnull Window window) {
        Objects.requireNonNull(window, ERROR_WINDOW_NULL);
        return window.getOpacity();
    }

    public static void setWindowOpacity(@Nonnull Window window, float opacity) {
        Objects.requireNonNull(window, ERROR_WINDOW_NULL);
        window.setOpacity(opacity);
    }

    @Nullable
    public static Component findComponentByName(@Nonnull String name, @Nonnull Container root) {
        Objects.requireNonNull(root, "Argument 'root' must not be null");
        GriffonNameUtils.requireNonBlank((String)name, (String)"Argument 'name' must not be blank");
        if (name.equals(root.getName())) {
            return root;
        }
        for (Component comp : root.getComponents()) {
            Component found;
            if (name.equals(comp.getName())) {
                return comp;
            }
            if (!(comp instanceof Container) || (found = SwingUtils.findComponentByName(name, (Container)comp)) == null) continue;
            return found;
        }
        return null;
    }

    @Nonnull
    public static Image takeSnapshot(@Nonnull Component component) {
        return SwingUtils.takeSnapshot(component, false);
    }

    @Nonnull
    public static Image takeSnapshot(@Nonnull Component component, boolean usePrint) {
        Objects.requireNonNull(component, "Argument 'component' must not be null");
        BufferedImage image = null;
        GraphicsEnvironment genv = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice gd = genv.getDefaultScreenDevice();
        GraphicsConfiguration gc = gd.getDefaultConfiguration();
        image = gc.getColorModel().hasAlpha() ? gc.createCompatibleImage((int)component.getSize().getWidth(), (int)component.getSize().getHeight()) : new BufferedImage((int)component.getSize().getWidth(), (int)component.getSize().getHeight(), 2);
        Graphics g = image.getGraphics();
        if (usePrint) {
            component.print(g);
        } else {
            component.paint(g);
        }
        g.dispose();
        return image;
    }

    @Nonnull
    public static Window createApplicationFrame(@Nonnull GriffonApplication application, @Nonnull Map<String, Object> attributes) {
        ClassLoader cl2;
        Objects.requireNonNull(application, "Argument 'application' must not be null");
        JFrame frame = null;
        String frameClass = application.getConfiguration().getAsString("application.frameClass", JFrame.class.getName());
        if (GriffonNameUtils.isNotBlank((String)frameClass)) {
            try {
                cl2 = SwingUtils.class.getClassLoader();
                frame = cl2 != null ? (JFrame)cl2.loadClass(frameClass).newInstance() : (JFrame)Class.forName(frameClass).newInstance();
            }
            catch (Throwable cl2) {
                // empty catch block
            }
        }
        if (frame == null) {
            try {
                cl2 = SwingUtils.class.getClassLoader();
                frame = cl2 != null ? (JFrame)cl2.loadClass("org.jdesktop.swingx.JXFrame").newInstance() : (JFrame)Class.forName("org.jdesktop.swingx.JXFrame").newInstance();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (frame == null) {
                frame = new JFrame();
            }
            frame.setDefaultCloseOperation(0);
        }
        GriffonClassUtils.setPropertiesNoException(frame, attributes);
        return frame;
    }
}

