/*
 * Decompiled with CFR 0.152.
 */
package griffon.swing.support;

import griffon.core.CallableWithArgs;
import griffon.core.RunnableWithArgs;
import griffon.util.GriffonNameUtils;
import java.awt.event.ActionEvent;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.KeyStroke;

public class SwingAction
extends AbstractAction {
    private static final long serialVersionUID = 4493562556110760713L;
    private static final String ERROR_CALLABLE_NULL = "Argument 'callable' must not be null";
    private static final String ERROR_RUNNABLE_NULL = "Argument 'runnable' must not be null";
    private final transient RunnableWithArgs runnable;

    @Deprecated
    public SwingAction(@Nonnull CallableWithArgs<?> callable) {
        Objects.requireNonNull(callable, ERROR_CALLABLE_NULL);
        this.runnable = arg_0 -> callable.call(arg_0);
    }

    public SwingAction(@Nonnull RunnableWithArgs runnable) {
        this.runnable = Objects.requireNonNull(runnable, ERROR_RUNNABLE_NULL);
    }

    @Nonnull
    public static ActionBuilder action() {
        return new ActionBuilder();
    }

    @Nonnull
    public static ActionBuilder action(@Nullable Action action) {
        return new ActionBuilder(action);
    }

    @Nonnull
    public static ActionBuilder action(@Nullable String name) {
        return new ActionBuilder().withName(name);
    }

    @Override
    public final void actionPerformed(ActionEvent evt) {
        this.runnable.run(new Object[]{evt});
    }

    public static class ActionBuilder {
        private String name;
        private int mnemonic;
        private KeyStroke accelerator;
        private String shortDescription;
        private String longDescription;
        private String command;
        private Icon smallIcon;
        private Icon largeIcon;
        private RunnableWithArgs runnable;
        private boolean enabled = true;
        private boolean selected = false;
        private Action action;
        private boolean mnemonicSet = false;
        private boolean enabledSet = false;
        private boolean selectedSet = false;

        public ActionBuilder() {
            this(null);
        }

        @Nonnull
        public ActionBuilder(@Nullable Action action) {
            this.action = action;
        }

        @Nonnull
        public ActionBuilder withName(@Nullable String name) {
            this.name = name;
            return this;
        }

        @Nonnull
        public ActionBuilder withShortDescription(@Nullable String shortDescription) {
            this.shortDescription = shortDescription;
            return this;
        }

        @Nonnull
        public ActionBuilder withLongDescription(@Nullable String longDescription) {
            this.longDescription = longDescription;
            return this;
        }

        @Nonnull
        public ActionBuilder withCommand(@Nullable String command) {
            this.command = command;
            return this;
        }

        @Nonnull
        public ActionBuilder withMnemonic(@Nullable String mnemonic) {
            if (GriffonNameUtils.isNotBlank((String)mnemonic)) {
                this.mnemonic = KeyStroke.getKeyStroke(mnemonic).getKeyCode();
            }
            this.mnemonicSet = true;
            return this;
        }

        @Nonnull
        public ActionBuilder withMnemonic(int mnemonic) {
            this.mnemonic = mnemonic;
            this.mnemonicSet = true;
            return this;
        }

        @Nonnull
        public ActionBuilder withAccelerator(@Nullable String accelerator) {
            if (GriffonNameUtils.isNotBlank((String)accelerator)) {
                this.accelerator = KeyStroke.getKeyStroke(accelerator);
            }
            return this;
        }

        @Nonnull
        public ActionBuilder withAccelerator(@Nullable KeyStroke accelerator) {
            this.accelerator = accelerator;
            return this;
        }

        @Nonnull
        public ActionBuilder withSmallIcon(@Nullable Icon smallIcon) {
            this.smallIcon = smallIcon;
            return this;
        }

        @Nonnull
        public ActionBuilder withLargeIcon(@Nullable Icon largeIcon) {
            this.largeIcon = largeIcon;
            return this;
        }

        @Nonnull
        @Deprecated
        public ActionBuilder withRunnable(@Nullable CallableWithArgs<?> callable) {
            Objects.requireNonNull(callable, SwingAction.ERROR_CALLABLE_NULL);
            this.runnable = arg_0 -> callable.call(arg_0);
            return this;
        }

        @Nonnull
        public ActionBuilder withRunnable(@Nullable RunnableWithArgs runnable) {
            this.runnable = runnable;
            return this;
        }

        @Nonnull
        public ActionBuilder withEnabled(boolean enabled) {
            this.enabled = enabled;
            this.enabledSet = true;
            return this;
        }

        @Nonnull
        public ActionBuilder withSelected(boolean selected) {
            this.selected = selected;
            this.selectedSet = true;
            return this;
        }

        @Nonnull
        public Action build() {
            if (this.runnable == null && this.action == null) {
                throw new IllegalArgumentException("Either runnable, callable, or action must have a value.");
            }
            if (this.action == null) {
                this.action = new SwingAction(this.runnable);
            }
            if (GriffonNameUtils.isNotBlank((String)this.command)) {
                this.action.putValue("ActionCommandKey", this.command);
            }
            if (GriffonNameUtils.isNotBlank((String)this.name)) {
                this.action.putValue("Name", this.name);
            }
            if (this.mnemonicSet) {
                this.action.putValue("MnemonicKey", this.mnemonic);
            }
            if (this.accelerator != null) {
                this.action.putValue("AcceleratorKey", this.accelerator);
            }
            if (this.largeIcon != null) {
                this.action.putValue("SwingLargeIconKey", this.largeIcon);
            }
            if (this.smallIcon != null) {
                this.action.putValue("SmallIcon", this.smallIcon);
            }
            if (GriffonNameUtils.isNotBlank((String)this.longDescription)) {
                this.action.putValue("LongDescription", this.longDescription);
            }
            if (GriffonNameUtils.isNotBlank((String)this.shortDescription)) {
                this.action.putValue("ShortDescription", this.shortDescription);
            }
            if (this.enabledSet) {
                this.action.setEnabled(this.enabled);
            }
            if (this.selectedSet) {
                this.action.putValue("SwingSelectedKey", this.selected);
            }
            return this.action;
        }
    }
}

