/*
 * Decompiled with CFR 0.152.
 */
package griffon.swing.formatters;

import griffon.core.formatters.AbstractFormatter;
import griffon.core.formatters.ParseException;
import griffon.swing.support.Colors;
import griffon.util.GriffonNameUtils;
import java.awt.Color;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ColorFormatter
extends AbstractFormatter<Color> {
    public static final String PATTERN_SHORT = "#RGB";
    public static final String PATTERN_SHORT_WITH_ALPHA = "#RGBA";
    public static final String PATTERN_LONG = "#RRGGBB";
    public static final String PATTERN_LONG_WITH_ALPHA = "#RRGGBBAA";
    public static final String DEFAULT_PATTERN = "#RRGGBB";
    private static final String[] PATTERNS = new String[]{"#RRGGBB", "#RRGGBBAA", "#RGB", "#RGBA"};
    public static final ColorFormatter SHORT = new ColorFormatter("#RGB");
    public static final ColorFormatter SHORT_WITH_ALPHA = new ColorFormatter("#RGBA");
    public static final ColorFormatter LONG = new ColorFormatter("#RRGGBB");
    public static final ColorFormatter LONG_WITH_ALPHA = new ColorFormatter("#RRGGBBAA");
    private final ColorFormatterDelegate delegate;

    @Nonnull
    public static ColorFormatter getInstance(@Nullable String pattern) {
        return new ColorFormatter(pattern);
    }

    protected ColorFormatter(@Nullable String pattern) {
        if (PATTERN_SHORT.equals(pattern)) {
            this.delegate = new ShortColorFormatterDelegate();
        } else if (PATTERN_SHORT_WITH_ALPHA.equals(pattern)) {
            this.delegate = new ShortWithAlphaColorFormatterDelegate();
        } else if ("#RRGGBB".equals(pattern)) {
            this.delegate = new LongColorFormatterDelegate();
        } else if (PATTERN_LONG_WITH_ALPHA.equals(pattern)) {
            this.delegate = new LongWithAlphaColorFormatterDelegate();
        } else if (GriffonNameUtils.isBlank((String)pattern)) {
            this.delegate = new LongColorFormatterDelegate();
        } else {
            throw new IllegalArgumentException("Invalid pattern '" + pattern + "'. Valid patterns are " + Arrays.toString(PATTERNS));
        }
    }

    @Nullable
    public String format(@Nullable Color color) {
        return color == null ? null : this.delegate.format(color);
    }

    @Nullable
    public Color parse(@Nullable String str) throws ParseException {
        return GriffonNameUtils.isBlank((String)str) ? null : this.delegate.parse(str);
    }

    @Nonnull
    public String getPattern() {
        return this.delegate.getPattern();
    }

    @Nonnull
    public static Color parseColor(@Nonnull String str) throws ParseException {
        GriffonNameUtils.requireNonBlank((String)str, (String)"Argument must not be blank");
        if (str.startsWith("#")) {
            switch (str.length()) {
                case 4: {
                    return SHORT.parse(str);
                }
                case 5: {
                    return SHORT_WITH_ALPHA.parse(str);
                }
                case 7: {
                    return LONG.parse(str);
                }
                case 9: {
                    return LONG_WITH_ALPHA.parse(str);
                }
            }
            throw ColorFormatter.parseError((Object)str, Color.class);
        }
        try {
            return Colors.valueOf(str.toUpperCase()).getColor();
        }
        catch (Exception e) {
            throw ColorFormatter.parseError((Object)str, Color.class, (Exception)e);
        }
    }

    private static String padLeft(String self, String padding) {
        return 2 <= self.length() ? self : padding + self;
    }

    private static class LongWithAlphaColorFormatterDelegate
    extends AbstractColorFormatterDelegate {
        private LongWithAlphaColorFormatterDelegate() {
            super(ColorFormatter.PATTERN_LONG_WITH_ALPHA);
        }

        @Override
        @Nonnull
        public String format(@Nonnull Color color) {
            Objects.requireNonNull(color, "Cannot format given Color because it's null");
            return "#" + ColorFormatter.padLeft(Integer.toHexString(color.getRed()), "0") + ColorFormatter.padLeft(Integer.toHexString(color.getGreen()), "0") + ColorFormatter.padLeft(Integer.toHexString(color.getBlue()), "0") + ColorFormatter.padLeft(Integer.toHexString(color.getAlpha()), "0");
        }

        @Override
        @Nonnull
        public Color parse(@Nonnull String str) throws ParseException {
            if (!str.startsWith("#") || str.length() != 9) {
                throw ColorFormatter.parseError((Object)str, (Class)Color.class);
            }
            int r = ColorFormatter.parseHexInt((String)("" + str.charAt(1) + str.charAt(2)).toUpperCase(), (Class)Color.class);
            int g = ColorFormatter.parseHexInt((String)("" + str.charAt(3) + str.charAt(4)).toUpperCase(), (Class)Color.class);
            int b = ColorFormatter.parseHexInt((String)("" + str.charAt(5) + str.charAt(6)).toUpperCase(), (Class)Color.class);
            int a = ColorFormatter.parseHexInt((String)("" + str.charAt(7) + str.charAt(8)).toUpperCase(), (Class)Color.class);
            return new Color(r, g, b, a);
        }
    }

    private static class LongColorFormatterDelegate
    extends AbstractColorFormatterDelegate {
        private LongColorFormatterDelegate() {
            super("#RRGGBB");
        }

        @Override
        @Nonnull
        public String format(@Nonnull Color color) {
            Objects.requireNonNull(color, "Cannot format given Color because it's null");
            return "#" + ColorFormatter.padLeft(Integer.toHexString(color.getRed()), "0") + ColorFormatter.padLeft(Integer.toHexString(color.getGreen()), "0") + ColorFormatter.padLeft(Integer.toHexString(color.getBlue()), "0");
        }

        @Override
        @Nonnull
        public Color parse(@Nonnull String str) throws ParseException {
            if (!str.startsWith("#") || str.length() != 7) {
                throw ColorFormatter.parseError((Object)str, (Class)Color.class);
            }
            int r = ColorFormatter.parseHexInt((String)("" + str.charAt(1) + str.charAt(2)).toUpperCase(), (Class)Color.class);
            int g = ColorFormatter.parseHexInt((String)("" + str.charAt(3) + str.charAt(4)).toUpperCase(), (Class)Color.class);
            int b = ColorFormatter.parseHexInt((String)("" + str.charAt(5) + str.charAt(6)).toUpperCase(), (Class)Color.class);
            return new Color(r, g, b);
        }
    }

    private static class ShortWithAlphaColorFormatterDelegate
    extends AbstractColorFormatterDelegate {
        private ShortWithAlphaColorFormatterDelegate() {
            super(ColorFormatter.PATTERN_SHORT_WITH_ALPHA);
        }

        @Override
        @Nonnull
        public String format(@Nonnull Color color) {
            Objects.requireNonNull(color, "Cannot format given Color because it's null");
            return "#" + Integer.toHexString(color.getRed()).charAt(0) + Integer.toHexString(color.getGreen()).charAt(0) + Integer.toHexString(color.getBlue()).charAt(0) + Integer.toHexString(color.getAlpha()).charAt(0);
        }

        @Override
        @Nonnull
        public Color parse(@Nonnull String str) throws ParseException {
            if (!str.startsWith("#") || str.length() != 5) {
                throw ColorFormatter.parseError((Object)str, (Class)Color.class);
            }
            int r = ColorFormatter.parseHexInt((String)("" + str.charAt(1) + str.charAt(1)).toUpperCase(), (Class)Color.class);
            int g = ColorFormatter.parseHexInt((String)("" + str.charAt(2) + str.charAt(2)).toUpperCase(), (Class)Color.class);
            int b = ColorFormatter.parseHexInt((String)("" + str.charAt(3) + str.charAt(3)).toUpperCase(), (Class)Color.class);
            int a = ColorFormatter.parseHexInt((String)("" + str.charAt(4) + str.charAt(4)).toUpperCase(), (Class)Color.class);
            return new Color(r, g, b, a);
        }
    }

    private static class ShortColorFormatterDelegate
    extends AbstractColorFormatterDelegate {
        private ShortColorFormatterDelegate() {
            super(ColorFormatter.PATTERN_SHORT);
        }

        @Override
        @Nonnull
        public String format(@Nonnull Color color) {
            Objects.requireNonNull(color, "Cannot format given Color because it's null");
            return "#" + Integer.toHexString(color.getRed()).charAt(0) + Integer.toHexString(color.getGreen()).charAt(0) + Integer.toHexString(color.getBlue()).charAt(0);
        }

        @Override
        @Nonnull
        public Color parse(@Nonnull String str) throws ParseException {
            if (!str.startsWith("#") || str.length() != 4) {
                throw ColorFormatter.parseError((Object)str, (Class)Color.class);
            }
            int r = ColorFormatter.parseHexInt((String)("" + str.charAt(1) + str.charAt(1)).toUpperCase(), (Class)Color.class);
            int g = ColorFormatter.parseHexInt((String)("" + str.charAt(2) + str.charAt(2)).toUpperCase(), (Class)Color.class);
            int b = ColorFormatter.parseHexInt((String)("" + str.charAt(3) + str.charAt(3)).toUpperCase(), (Class)Color.class);
            return new Color(r, g, b);
        }
    }

    private static abstract class AbstractColorFormatterDelegate
    implements ColorFormatterDelegate {
        private final String pattern;

        private AbstractColorFormatterDelegate(@Nonnull String pattern) {
            this.pattern = pattern;
        }

        @Override
        @Nonnull
        public String getPattern() {
            return this.pattern;
        }
    }

    private static interface ColorFormatterDelegate {
        @Nonnull
        public String getPattern();

        @Nonnull
        public String format(@Nonnull Color var1);

        @Nonnull
        public Color parse(@Nonnull String var1) throws ParseException;
    }
}

