/*
 * Decompiled with CFR 0.152.
 */
package griffon.swing.editors;

import griffon.core.editors.AbstractPropertyEditor;
import griffon.util.GriffonNameUtils;
import java.awt.Point;
import java.util.List;
import java.util.Map;

public class PointPropertyEditor
extends AbstractPropertyEditor {
    public String getAsText() {
        if (null == this.getValue()) {
            return null;
        }
        Point p = (Point)this.getValue();
        return p.getX() + ", " + p.getY();
    }

    protected void setValueInternal(Object value) {
        if (null == value) {
            super.setValueInternal(null);
        } else if (value instanceof CharSequence) {
            this.handleAsString(String.valueOf(value));
        } else if (value instanceof List) {
            this.handleAsList((List)value);
        } else if (value instanceof Map) {
            this.handleAsMap((Map)value);
        } else if (value instanceof Number) {
            this.handleAsNumber((Number)value);
        } else if (value instanceof Point) {
            super.setValueInternal(value);
        } else {
            throw this.illegalValue(value, Point.class);
        }
    }

    protected void handleAsString(String str) {
        if (GriffonNameUtils.isBlank((String)str)) {
            super.setValueInternal(null);
            return;
        }
        String[] parts = str.split(",");
        switch (parts.length) {
            case 1: {
                int s = this.parseValue(parts[0]);
                super.setValueInternal((Object)new Point(s, s));
                break;
            }
            case 2: {
                int x = this.parseValue(parts[0]);
                int y = this.parseValue(parts[1]);
                super.setValueInternal((Object)new Point(x, y));
                break;
            }
            default: {
                throw this.illegalValue(str, Point.class);
            }
        }
    }

    protected void handleAsList(List<?> list) {
        if (list.isEmpty()) {
            super.setValueInternal(null);
            return;
        }
        switch (list.size()) {
            case 1: {
                int s = this.parseValue(list.get(0));
                super.setValueInternal((Object)new Point(s, s));
                break;
            }
            case 2: {
                int x = this.parseValue(list.get(0));
                int y = this.parseValue(list.get(1));
                super.setValueInternal((Object)new Point(x, y));
                break;
            }
            default: {
                throw this.illegalValue(list, Point.class);
            }
        }
    }

    protected void handleAsMap(Map<?, ?> map) {
        if (map.isEmpty()) {
            super.setValueInternal(null);
            return;
        }
        int x = this.getMapValue(map, "x", 0);
        int y = this.getMapValue(map, "y", 0);
        super.setValueInternal((Object)new Point(x, y));
    }

    protected int parseValue(Object value) {
        if (value instanceof CharSequence) {
            return this.parse(String.valueOf(value));
        }
        if (value instanceof Number) {
            return this.parse((Number)value);
        }
        throw this.illegalValue(value, Point.class);
    }

    protected int parse(String val) {
        try {
            return Integer.parseInt(val.trim());
        }
        catch (NumberFormatException e) {
            throw this.illegalValue(val, Point.class, e);
        }
    }

    protected int parse(Number val) {
        return val.intValue();
    }

    protected int getMapValue(Map<?, ?> map, String key, int defaultValue) {
        Object val = map.get(key);
        if (null == val) {
            return defaultValue;
        }
        if (val instanceof CharSequence) {
            return this.parse(String.valueOf(val));
        }
        if (val instanceof Number) {
            return this.parse((Number)val);
        }
        throw this.illegalValue(map, Point.class);
    }

    protected void handleAsNumber(Number value) {
        int s = this.parse(value);
        super.setValueInternal((Object)new Point(s, s));
    }
}

