/*
 * Decompiled with CFR 0.152.
 */
package griffon.swing.editors;

import griffon.core.editors.AbstractPropertyEditor;
import griffon.util.GriffonNameUtils;
import java.awt.Image;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.imageio.stream.ImageInputStream;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class IconPropertyEditor
extends AbstractPropertyEditor {
    protected void setValueInternal(Object value) {
        if (null == value) {
            super.setValueInternal(null);
        } else if (value instanceof CharSequence) {
            this.handleAsString(String.valueOf(value));
        } else if (value instanceof File) {
            this.handleAsFile((File)value);
        } else if (value instanceof URL) {
            this.handleAsURL((URL)value);
        } else if (value instanceof URI) {
            this.handleAsURI((URI)value);
        } else if (value instanceof InputStream) {
            this.handleAsInputStream((InputStream)value);
        } else if (value instanceof ImageInputStream) {
            this.handleAsImageInputStream((ImageInputStream)value);
        } else if (value instanceof byte[]) {
            this.handleAsByteArray((byte[])value);
        } else if (value instanceof Image) {
            this.handleAsImage((Image)value);
        } else if (value instanceof Icon) {
            super.setValueInternal(value);
        } else {
            throw this.illegalValue(value, Icon.class);
        }
    }

    protected void handleAsString(String str) {
        if (GriffonNameUtils.isBlank((String)str)) {
            super.setValueInternal(null);
            return;
        }
        if (str.contains("|")) {
            this.handleAsClassWithArg(str);
        } else {
            this.handleAsURL(((Object)((Object)this)).getClass().getClassLoader().getResource(str));
        }
    }

    protected void handleAsClassWithArg(String str) {
        String[] args = str.split("\\|");
        if (args.length == 2) {
            Class<?> iconClass = null;
            try {
                iconClass = IconPropertyEditor.class.getClassLoader().loadClass(args[0]);
            }
            catch (ClassNotFoundException e) {
                throw this.illegalValue(str, Icon.class, e);
            }
            Constructor<?> constructor = null;
            try {
                constructor = iconClass.getConstructor(String.class);
            }
            catch (NoSuchMethodException e) {
                throw this.illegalValue(str, Icon.class, e);
            }
            try {
                super.setValueInternal(constructor.newInstance(args[1]));
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw this.illegalValue(str, Icon.class, e);
            }
        }
        throw this.illegalValue(str, Icon.class);
    }

    protected void handleAsFile(File file) {
        try {
            this.handleAsImage(ImageIO.read(file));
        }
        catch (IOException e) {
            throw this.illegalValue(file, Icon.class, e);
        }
    }

    protected void handleAsURL(URL url) {
        try {
            this.handleAsImage(ImageIO.read(url));
        }
        catch (IOException e) {
            throw this.illegalValue(url, Icon.class, e);
        }
    }

    protected void handleAsURI(URI uri) {
        try {
            this.handleAsURL(uri.toURL());
        }
        catch (MalformedURLException e) {
            throw this.illegalValue(uri, Icon.class, e);
        }
    }

    protected void handleAsInputStream(InputStream stream) {
        try {
            this.handleAsImage(ImageIO.read(stream));
        }
        catch (IOException e) {
            throw this.illegalValue(stream, Icon.class, e);
        }
    }

    protected void handleAsImageInputStream(ImageInputStream stream) {
        try {
            this.handleAsImage(ImageIO.read(stream));
        }
        catch (IOException e) {
            throw this.illegalValue(stream, Icon.class, e);
        }
    }

    protected void handleAsByteArray(byte[] bytes) {
        super.setValueInternal((Object)new ImageIcon(bytes));
    }

    protected void handleAsImage(Image img) {
        super.setValueInternal((Object)new ImageIcon(img));
    }
}

