/*
 * Decompiled with CFR 0.152.
 */
package griffon.swing.editors;

import griffon.core.editors.AbstractPropertyEditor;
import griffon.util.GriffonNameUtils;
import java.awt.Font;
import java.util.List;
import java.util.Map;

public class FontPropertyEditor
extends AbstractPropertyEditor {
    public String getAsText() {
        if (null == this.getValue()) {
            return null;
        }
        Font font = (Font)this.getValue();
        return font.getFamily() + "-" + this.formatStyle(font) + "-" + font.getSize();
    }

    protected String formatStyle(Font font) {
        if (font.isBold() && font.isItalic()) {
            return "BOLDITALIC";
        }
        if (font.isBold()) {
            return "BOLD";
        }
        if (font.isItalic()) {
            return "ITALIC";
        }
        return "PLAIN";
    }

    protected void setValueInternal(Object value) {
        if (null == value) {
            super.setValueInternal(null);
        } else if (value instanceof CharSequence) {
            this.handleAsString(String.valueOf(value));
        } else if (value instanceof List) {
            this.handleAsList((List)value);
        } else if (value instanceof Map) {
            this.handleAsMap((Map)value);
        } else if (value instanceof Font) {
            super.setValueInternal(value);
        } else {
            throw this.illegalValue(value, Font.class);
        }
    }

    protected void handleAsString(String str) {
        if (GriffonNameUtils.isBlank((String)str)) {
            super.setValueInternal(null);
            return;
        }
        String[] parts = str.split("-");
        if (parts.length != 3) {
            throw this.illegalValue(str, Font.class);
        }
        String family = parts[0];
        int style = this.resolveStyle(str, parts[1]);
        int size = this.parseSize(str, parts[2]);
        super.setValueInternal((Object)new Font(family, style, size));
    }

    protected void handleAsList(List<?> list) {
        if (list.isEmpty()) {
            super.setValueInternal(null);
            return;
        }
        if (list.size() != 3) {
            throw this.illegalValue(list, Font.class);
        }
        String family = String.valueOf(list.get(0));
        int style = this.resolveStyle(list, String.valueOf(list.get(1)));
        int size = this.parseSize(list, String.valueOf(list.get(2)));
        super.setValueInternal((Object)new Font(family, style, size));
    }

    protected void handleAsMap(Map<?, ?> map) {
        if (map.isEmpty()) {
            super.setValueInternal(null);
            return;
        }
        String family = this.getMapValue(map, "family", "");
        String style = this.getMapValue(map, "style", "");
        String size = this.getMapValue(map, "size", "");
        super.setValueInternal((Object)new Font(family, this.resolveStyle(map, style), this.parseSize(map, size)));
    }

    protected String getMapValue(Map<?, ?> map, String key, String defaultValue) {
        Object val = map.get(key);
        if (null == val) {
            val = map.get(String.valueOf(key.charAt(0)));
        }
        if (null == val) {
            return defaultValue;
        }
        if (val instanceof CharSequence) {
            return String.valueOf(val).trim();
        }
        throw this.illegalValue(map, Font.class);
    }

    protected int parseSize(Object source, String str) {
        int size;
        try {
            size = Integer.parseInt(str);
        }
        catch (NumberFormatException nfe) {
            throw this.illegalValue(source, Font.class);
        }
        return size;
    }

    protected int resolveStyle(Object source, String str) {
        if ("PLAIN".equalsIgnoreCase(str)) {
            return 0;
        }
        if ("BOLD".equalsIgnoreCase(str)) {
            return 1;
        }
        if ("ITALIC".equalsIgnoreCase(str)) {
            return 2;
        }
        if ("BOLDITALIC".equalsIgnoreCase(str)) {
            return 3;
        }
        throw this.illegalValue(source, Font.class);
    }
}

