/*
 * Decompiled with CFR 0.152.
 */
package griffon.swing.editors;

import griffon.core.editors.AbstractPropertyEditor;
import griffon.util.GriffonNameUtils;
import java.awt.Dimension;
import java.util.List;
import java.util.Map;

public class DimensionPropertyEditor
extends AbstractPropertyEditor {
    public String getAsText() {
        if (null == this.getValue()) {
            return null;
        }
        Dimension dimension = (Dimension)this.getValue();
        return dimension.getWidth() + ", " + dimension.getHeight();
    }

    protected void setValueInternal(Object value) {
        if (null == value) {
            super.setValueInternal(null);
        } else if (value instanceof CharSequence) {
            this.handleAsString(String.valueOf(value));
        } else if (value instanceof List) {
            this.handleAsList((List)value);
        } else if (value instanceof Map) {
            this.handleAsMap((Map)value);
        } else if (value instanceof Number) {
            this.handleAsNumber((Number)value);
        } else if (value instanceof Dimension) {
            super.setValueInternal(value);
        } else {
            throw this.illegalValue(value, Dimension.class);
        }
    }

    protected void handleAsString(String str) {
        if (GriffonNameUtils.isBlank((String)str)) {
            super.setValueInternal(null);
            return;
        }
        String[] parts = str.split(",");
        switch (parts.length) {
            case 1: {
                int s = this.parseValue(parts[0]);
                super.setValueInternal((Object)new Dimension(s, s));
                break;
            }
            case 2: {
                int w = this.parseValue(parts[0]);
                int h = this.parseValue(parts[1]);
                super.setValueInternal((Object)new Dimension(w, h));
                break;
            }
            default: {
                throw this.illegalValue(str, Dimension.class);
            }
        }
    }

    protected void handleAsList(List<?> list) {
        if (list.isEmpty()) {
            super.setValueInternal(null);
            return;
        }
        switch (list.size()) {
            case 1: {
                int s = this.parseValue(list.get(0));
                super.setValueInternal((Object)new Dimension(s, s));
                break;
            }
            case 2: {
                int w = this.parseValue(list.get(0));
                int h = this.parseValue(list.get(1));
                super.setValueInternal((Object)new Dimension(w, h));
                break;
            }
            default: {
                throw this.illegalValue(list, Dimension.class);
            }
        }
    }

    protected void handleAsMap(Map<?, ?> map) {
        if (map.isEmpty()) {
            super.setValueInternal(null);
            return;
        }
        int w = this.getMapValue(map, "width", 0);
        int h = this.getMapValue(map, "height", 0);
        super.setValueInternal((Object)new Dimension(w, h));
    }

    protected int parseValue(Object value) {
        if (value instanceof CharSequence) {
            return this.parse(String.valueOf(value));
        }
        if (value instanceof Number) {
            return this.parse((Number)value);
        }
        throw this.illegalValue(value, Dimension.class);
    }

    protected int parse(String val) {
        try {
            return Integer.parseInt(val.trim());
        }
        catch (NumberFormatException e) {
            throw this.illegalValue(val, Dimension.class, e);
        }
    }

    protected int parse(Number val) {
        return val.intValue();
    }

    protected int getMapValue(Map<?, ?> map, String key, int defaultValue) {
        Object val = map.get(key);
        if (null == val) {
            val = map.get(String.valueOf(key.charAt(0)));
        }
        if (null == val) {
            return defaultValue;
        }
        if (val instanceof CharSequence) {
            return this.parse(String.valueOf(val));
        }
        if (val instanceof Number) {
            return this.parse((Number)val);
        }
        throw this.illegalValue(map, Dimension.class);
    }

    protected void handleAsNumber(Number value) {
        int s = this.parse(value);
        super.setValueInternal((Object)new Dimension(s, s));
    }
}

