/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.maven3.configuration;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.cargo.container.ContainerType;
import org.codehaus.cargo.container.configuration.ConfigurationType;
import org.codehaus.cargo.container.configuration.FileConfig;
import org.codehaus.cargo.container.configuration.LocalConfiguration;
import org.codehaus.cargo.container.configuration.StandaloneLocalConfiguration;
import org.codehaus.cargo.generic.configuration.DefaultConfigurationFactory;
import org.codehaus.cargo.maven3.configuration.DataSource;
import org.codehaus.cargo.maven3.configuration.Deployable;
import org.codehaus.cargo.maven3.configuration.Resource;
import org.codehaus.cargo.maven3.configuration.User;
import org.codehaus.cargo.maven3.util.CargoProject;
import org.codehaus.cargo.util.XmlReplacement;

public class Configuration {
    private String type = ConfigurationType.STANDALONE.getType();
    private String implementation;
    private String home;
    private Map<String, String> properties;
    private File propertiesFile;
    private List<String> setProperties;
    private FileConfig[] fileConfigs;
    private FileConfig[] configfiles;
    private XmlReplacement[] xmlReplacements;
    private DataSource[] datasources;
    private Resource[] resources;
    private User[] users;

    public ConfigurationType getType() {
        return ConfigurationType.toType((String)this.type);
    }

    public void setType(ConfigurationType type) {
        this.type = type.getType();
    }

    public String getHome() {
        return this.home;
    }

    public void setHome(String home) {
        this.home = home;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public File getPropertiesFile() {
        return this.propertiesFile;
    }

    public void setPropertiesFile(File propertiesFile) {
        this.propertiesFile = propertiesFile;
    }

    public List<String> getSetProperties() {
        return this.setProperties;
    }

    public FileConfig[] getConfigfiles() {
        return this.configfiles;
    }

    public void setConfigfiles(FileConfig[] configfiles) {
        this.configfiles = configfiles;
    }

    public FileConfig[] getFiles() {
        return this.fileConfigs;
    }

    public void setFiles(FileConfig[] fileConfigs) {
        this.fileConfigs = fileConfigs;
    }

    public XmlReplacement[] getXmlReplacements() {
        return this.xmlReplacements;
    }

    public void setXmlReplacements(XmlReplacement[] xmlReplacements) {
        this.xmlReplacements = xmlReplacements;
    }

    public String getImplementation() {
        return this.implementation;
    }

    public void setImplementation(String implementation) {
        this.implementation = implementation;
    }

    public DataSource[] getDatasources() {
        return this.datasources;
    }

    public void setDatasources(DataSource[] datasources) {
        this.datasources = datasources;
    }

    public Resource[] getResources() {
        return this.resources;
    }

    public void setResources(Resource[] rlist) {
        this.resources = rlist;
    }

    public User[] getUsers() {
        return this.users;
    }

    public void setUsers(User[] users) {
        this.users = users;
    }

    public org.codehaus.cargo.container.configuration.Configuration createConfiguration(String containerId, ContainerType containerType, Deployable[] deployables, CargoProject project) throws MojoExecutionException {
        org.codehaus.cargo.container.configuration.Configuration configuration;
        DefaultConfigurationFactory factory = new DefaultConfigurationFactory();
        if (this.getImplementation() != null) {
            try {
                Class<?> configurationClass = Class.forName(this.getImplementation(), true, this.getClass().getClassLoader());
                factory.registerConfiguration(containerId, containerType, this.getType(), configurationClass);
            }
            catch (ClassNotFoundException cnfe) {
                throw new MojoExecutionException("Custom configuration implementation [" + this.getImplementation() + "] cannot be loaded", (Exception)cnfe);
            }
        }
        if (this.getHome() == null) {
            if (project.isDaemonRun()) {
                configuration = factory.createConfiguration(containerId, containerType, this.getType(), "");
            } else if (ConfigurationType.RUNTIME.equals((Object)this.getType())) {
                configuration = factory.createConfiguration(containerId, containerType, this.getType(), null);
            } else {
                File home = new File(project.getBuildDirectory(), "cargo/configurations/" + containerId);
                configuration = factory.createConfiguration(containerId, containerType, this.getType(), home.getAbsolutePath());
            }
        } else {
            configuration = factory.createConfiguration(containerId, containerType, this.getType(), this.getHome());
        }
        this.setProperties = new ArrayList<String>();
        if (this.getPropertiesFile() != null) {
            Properties properties = new Properties();
            try {
                try (FileInputStream fileInputStream = new FileInputStream(this.getPropertiesFile());){
                    properties.load(new BufferedInputStream(fileInputStream));
                }
                Enumeration<?> enumeration = properties.propertyNames();
                while (enumeration.hasMoreElements()) {
                    String propertyName = (String)enumeration.nextElement();
                    String propertyValue = properties.getProperty(propertyName);
                    configuration.setProperty(propertyName, propertyValue);
                    this.setProperties.add(propertyName);
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                configuration.getLogger().warn("Configuration property file [" + this.getPropertiesFile() + "] cannot be read", this.getClass().getName());
            }
            catch (IOException iOException) {
                throw new MojoExecutionException("Configuration property file [" + this.getPropertiesFile() + "] cannot be loaded", (Exception)iOException);
            }
        }
        if (this.getProperties() != null) {
            for (Map.Entry entry : this.getProperties().entrySet()) {
                String propertyValue = (String)entry.getValue();
                if (propertyValue == null) {
                    propertyValue = "";
                }
                configuration.setProperty((String)entry.getKey(), propertyValue);
                this.setProperties.add((String)entry.getKey());
            }
        }
        if (configuration instanceof StandaloneLocalConfiguration && this.getXmlReplacements() != null) {
            StandaloneLocalConfiguration standaloneLocalConfiguration = (StandaloneLocalConfiguration)configuration;
            for (XmlReplacement xmlReplacement : this.getXmlReplacements()) {
                standaloneLocalConfiguration.addXmlReplacement(xmlReplacement);
            }
        }
        if (configuration instanceof LocalConfiguration) {
            LocalConfiguration localConfiguration = (LocalConfiguration)configuration;
            if (deployables != null) {
                this.addStaticDeployables(containerId, localConfiguration, deployables, project);
            }
            if (this.getDatasources() != null) {
                this.addDatasources(localConfiguration);
            }
            if (this.getResources() != null) {
                this.addResources(containerId, localConfiguration, project);
            }
            if (this.getUsers() != null) {
                this.addUsers(this.getUsers(), localConfiguration);
            }
            if (this.getConfigfiles() != null) {
                for (FileConfig fileConfig : this.getConfigfiles()) {
                    localConfiguration.setConfigFileProperty(fileConfig);
                }
            }
            if (this.getFiles() != null) {
                for (FileConfig fileConfig : this.getFiles()) {
                    localConfiguration.setFileProperty(fileConfig);
                }
            }
        }
        return configuration;
    }

    private void addDatasources(LocalConfiguration configuration) throws MojoExecutionException {
        for (DataSource dataSource : this.datasources) {
            configuration.addDataSource(dataSource.createDataSource());
        }
    }

    private void addResources(String containerId, LocalConfiguration configuration, CargoProject project) throws MojoExecutionException {
        for (Resource resource : this.getResources()) {
            configuration.addResource(resource.createResource(containerId, project));
        }
    }

    private void addUsers(User[] users, LocalConfiguration configuration) {
        for (User user : users) {
            configuration.addUser(user.createUser());
        }
    }

    private void addStaticDeployables(String containerId, LocalConfiguration configuration, Deployable[] deployables, CargoProject project) throws MojoExecutionException {
        for (Deployable deployable : deployables) {
            project.getLog().debug((CharSequence)("Scheduling deployable for deployment: [groupId [" + deployable.getGroupId() + "], artifactId [" + deployable.getArtifactId() + "], type [" + deployable.getType() + "], location [" + deployable.getLocation() + "], pingURL [" + deployable.getPingURL() + "]]"));
            configuration.addDeployable(deployable.createDeployable(containerId, project));
        }
    }
}

