/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.tools.daemon;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;

public class UrlEncodedFormWriter {
    private final String charset = "ISO-8859-1";
    private final StringBuilder formData = new StringBuilder();
    private DataOutputStream out = null;

    public void addField(String name, String value) throws IOException {
        if (name == null) {
            throw new IllegalArgumentException("Name cannot be null or empty.");
        }
        if (this.formData.length() > 0) {
            this.formData.append("&");
        }
        this.formData.append(name + "=");
        if (value != null) {
            this.formData.append(URLEncoder.encode(value, "ISO-8859-1"));
        }
    }

    public void write(OutputStream os) throws IOException {
        if (os == null) {
            throw new IllegalArgumentException("Output stream is required.");
        }
        this.out = new DataOutputStream(os);
        this.out.writeBytes(this.formData.toString());
        this.out.flush();
        this.out.close();
    }

    public int getLength() {
        return this.formData.toString().length();
    }
}

