/*
 * Copyright (c) 1996, 2020, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */
package java.sql;

import org.checkerframework.checker.mustcall.qual.InheritableMustCall;
import org.checkerframework.framework.qual.AnnotatedFor;
import java.util.Properties;
import java.util.concurrent.Executor;

@AnnotatedFor({ "mustcall" })
@InheritableMustCall("close")
public interface Connection extends Wrapper, AutoCloseable {

    Statement createStatement() throws SQLException;

    PreparedStatement prepareStatement(String sql) throws SQLException;

    CallableStatement prepareCall(String sql) throws SQLException;

    String nativeSQL(String sql) throws SQLException;

    void setAutoCommit(boolean autoCommit) throws SQLException;

    boolean getAutoCommit() throws SQLException;

    void commit() throws SQLException;

    void rollback() throws SQLException;

    void close() throws SQLException;

    boolean isClosed() throws SQLException;

    DatabaseMetaData getMetaData() throws SQLException;

    void setReadOnly(boolean readOnly) throws SQLException;

    boolean isReadOnly() throws SQLException;

    void setCatalog(String catalog) throws SQLException;

    String getCatalog() throws SQLException;

    int TRANSACTION_NONE;

    int TRANSACTION_READ_UNCOMMITTED;

    int TRANSACTION_READ_COMMITTED;

    int TRANSACTION_REPEATABLE_READ;

    int TRANSACTION_SERIALIZABLE;

    void setTransactionIsolation(int level) throws SQLException;

    int getTransactionIsolation() throws SQLException;

    SQLWarning getWarnings() throws SQLException;

    void clearWarnings() throws SQLException;

    Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException;

    PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException;

    CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException;

    java.util.Map<String, Class<?>> getTypeMap() throws SQLException;

    void setTypeMap(java.util.Map<String, Class<?>> map) throws SQLException;

    void setHoldability(int holdability) throws SQLException;

    int getHoldability() throws SQLException;

    Savepoint setSavepoint() throws SQLException;

    Savepoint setSavepoint(String name) throws SQLException;

    void rollback(Savepoint savepoint) throws SQLException;

    void releaseSavepoint(Savepoint savepoint) throws SQLException;

    Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException;

    PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException;

    CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException;

    PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException;

    PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException;

    PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException;

    Clob createClob() throws SQLException;

    Blob createBlob() throws SQLException;

    NClob createNClob() throws SQLException;

    SQLXML createSQLXML() throws SQLException;

    boolean isValid(int timeout) throws SQLException;

    void setClientInfo(String name, String value) throws SQLClientInfoException;

    void setClientInfo(Properties properties) throws SQLClientInfoException;

    String getClientInfo(String name) throws SQLException;

    Properties getClientInfo() throws SQLException;

    Array createArrayOf(String typeName, Object[] elements) throws SQLException;

    Struct createStruct(String typeName, Object[] attributes) throws SQLException;

    void setSchema(String schema) throws SQLException;

    String getSchema() throws SQLException;

    void abort(Executor executor) throws SQLException;

    void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException;

    int getNetworkTimeout() throws SQLException;

    default void beginRequest() throws SQLException;

    default void endRequest() throws SQLException;

    default boolean setShardingKeyIfValid(ShardingKey shardingKey, ShardingKey superShardingKey, int timeout) throws SQLException;

    default boolean setShardingKeyIfValid(ShardingKey shardingKey, int timeout) throws SQLException;

    default void setShardingKey(ShardingKey shardingKey, ShardingKey superShardingKey) throws SQLException;

    default void setShardingKey(ShardingKey shardingKey) throws SQLException;
}
