/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl;

import java.util.Date;
import java.util.List;
import org.camunda.bpm.engine.history.HistoricActivityInstance;
import org.camunda.bpm.engine.history.HistoricDecisionInstance;
import org.camunda.bpm.engine.history.HistoricProcessInstance;
import org.camunda.bpm.engine.history.HistoricTaskInstance;
import org.camunda.bpm.engine.history.HistoricVariableUpdate;
import org.camunda.bpm.engine.history.UserOperationLogEntry;
import org.camunda.bpm.engine.impl.ServiceImpl;
import org.camunda.bpm.engine.impl.cmd.optimize.OptimizeCompletedHistoricActivityInstanceQueryCmd;
import org.camunda.bpm.engine.impl.cmd.optimize.OptimizeCompletedHistoricIncidentsQueryCmd;
import org.camunda.bpm.engine.impl.cmd.optimize.OptimizeCompletedHistoricProcessInstanceQueryCmd;
import org.camunda.bpm.engine.impl.cmd.optimize.OptimizeCompletedHistoricTaskInstanceQueryCmd;
import org.camunda.bpm.engine.impl.cmd.optimize.OptimizeHistoricDecisionInstanceQueryCmd;
import org.camunda.bpm.engine.impl.cmd.optimize.OptimizeHistoricIdentityLinkLogQueryCmd;
import org.camunda.bpm.engine.impl.cmd.optimize.OptimizeHistoricUserOperationsLogQueryCmd;
import org.camunda.bpm.engine.impl.cmd.optimize.OptimizeHistoricVariableUpdateQueryCmd;
import org.camunda.bpm.engine.impl.cmd.optimize.OptimizeOpenHistoricIncidentsQueryCmd;
import org.camunda.bpm.engine.impl.cmd.optimize.OptimizeRunningHistoricActivityInstanceQueryCmd;
import org.camunda.bpm.engine.impl.cmd.optimize.OptimizeRunningHistoricProcessInstanceQueryCmd;
import org.camunda.bpm.engine.impl.cmd.optimize.OptimizeRunningHistoricTaskInstanceQueryCmd;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricIncidentEntity;
import org.camunda.bpm.engine.impl.persistence.entity.optimize.OptimizeHistoricIdentityLinkLogEntity;

public class OptimizeService
extends ServiceImpl {
    public List<HistoricActivityInstance> getCompletedHistoricActivityInstances(Date finishedAfter, Date finishedAt, int maxResults) {
        return this.commandExecutor.execute(new OptimizeCompletedHistoricActivityInstanceQueryCmd(finishedAfter, finishedAt, maxResults));
    }

    public List<HistoricActivityInstance> getRunningHistoricActivityInstances(Date startedAfter, Date startedAt, int maxResults) {
        return this.commandExecutor.execute(new OptimizeRunningHistoricActivityInstanceQueryCmd(startedAfter, startedAt, maxResults));
    }

    public List<HistoricTaskInstance> getCompletedHistoricTaskInstances(Date finishedAfter, Date finishedAt, int maxResults) {
        return this.commandExecutor.execute(new OptimizeCompletedHistoricTaskInstanceQueryCmd(finishedAfter, finishedAt, maxResults));
    }

    public List<HistoricTaskInstance> getRunningHistoricTaskInstances(Date startedAfter, Date startedAt, int maxResults) {
        return this.commandExecutor.execute(new OptimizeRunningHistoricTaskInstanceQueryCmd(startedAfter, startedAt, maxResults));
    }

    public List<UserOperationLogEntry> getHistoricUserOperationLogs(Date occurredAfter, Date occurredAt, int maxResults) {
        return this.commandExecutor.execute(new OptimizeHistoricUserOperationsLogQueryCmd(occurredAfter, occurredAt, maxResults));
    }

    public List<OptimizeHistoricIdentityLinkLogEntity> getHistoricIdentityLinkLogs(Date occurredAfter, Date occurredAt, int maxResults) {
        return this.commandExecutor.execute(new OptimizeHistoricIdentityLinkLogQueryCmd(occurredAfter, occurredAt, maxResults));
    }

    public List<HistoricProcessInstance> getCompletedHistoricProcessInstances(Date finishedAfter, Date finishedAt, int maxResults) {
        return this.commandExecutor.execute(new OptimizeCompletedHistoricProcessInstanceQueryCmd(finishedAfter, finishedAt, maxResults));
    }

    public List<HistoricProcessInstance> getRunningHistoricProcessInstances(Date startedAfter, Date startedAt, int maxResults) {
        return this.commandExecutor.execute(new OptimizeRunningHistoricProcessInstanceQueryCmd(startedAfter, startedAt, maxResults));
    }

    public List<HistoricVariableUpdate> getHistoricVariableUpdates(Date occurredAfter, Date occurredAt, boolean excludeObjectValues, int maxResults) {
        return this.commandExecutor.execute(new OptimizeHistoricVariableUpdateQueryCmd(occurredAfter, occurredAt, excludeObjectValues, maxResults));
    }

    public List<HistoricIncidentEntity> getCompletedHistoricIncidents(Date finishedAfter, Date finishedAt, int maxResults) {
        return this.commandExecutor.execute(new OptimizeCompletedHistoricIncidentsQueryCmd(finishedAfter, finishedAt, maxResults));
    }

    public List<HistoricIncidentEntity> getOpenHistoricIncidents(Date createdAfter, Date createdAt, int maxResults) {
        return this.commandExecutor.execute(new OptimizeOpenHistoricIncidentsQueryCmd(createdAfter, createdAt, maxResults));
    }

    public List<HistoricDecisionInstance> getHistoricDecisionInstances(Date evaluatedAfter, Date evaluatedAt, int maxResults) {
        return this.commandExecutor.execute(new OptimizeHistoricDecisionInstanceQueryCmd(evaluatedAfter, evaluatedAt, maxResults));
    }
}

