/*
 * Decompiled with CFR 0.152.
 */
package camundajar.impl.com.cronutils.model.time.generator;

import camundajar.impl.com.cronutils.model.field.CronField;
import camundajar.impl.com.cronutils.model.field.expression.Between;
import camundajar.impl.com.cronutils.model.field.expression.Every;
import camundajar.impl.com.cronutils.model.field.expression.FieldExpression;
import camundajar.impl.com.cronutils.model.field.expression.On;
import camundajar.impl.com.cronutils.model.time.generator.BetweenFieldValueGenerator;
import camundajar.impl.com.cronutils.model.time.generator.FieldValueGenerator;
import camundajar.impl.com.cronutils.model.time.generator.NoSuchValueException;
import camundajar.impl.com.cronutils.utils.VisibleForTesting;
import java.util.ArrayList;
import java.util.List;

class EveryFieldValueGenerator
extends FieldValueGenerator {
    protected final int from;
    protected final int to;

    public EveryFieldValueGenerator(CronField cronField) {
        super(cronField);
        Every every = (Every)cronField.getExpression();
        FieldExpression everyExpression = every.getExpression();
        if (everyExpression instanceof Between) {
            Between between = (Between)everyExpression;
            this.from = Math.max(cronField.getConstraints().getStartRange(), BetweenFieldValueGenerator.map(between.getFrom()));
            this.to = Math.min(cronField.getConstraints().getEndRange(), BetweenFieldValueGenerator.map(between.getTo()));
        } else if (everyExpression instanceof On) {
            On on = (On)everyExpression;
            this.from = on.getTime().getValue();
            this.to = cronField.getConstraints().getEndRange();
        } else {
            this.from = cronField.getConstraints().getStartRange();
            this.to = cronField.getConstraints().getEndRange();
        }
    }

    @Override
    public int generateNextValue(int reference) throws NoSuchValueException {
        if (reference >= this.to) {
            throw new NoSuchValueException();
        }
        Every every = (Every)this.cronField.getExpression();
        int next = this.getNext(reference, every);
        if (next < this.from) {
            return this.from;
        }
        if (next > this.to) {
            throw new NoSuchValueException();
        }
        return next;
    }

    private int getNext(int reference, Every every) {
        int offset = this.offset();
        if (reference >= offset) {
            int referenceWithoutOffset = reference - offset;
            int period = every.getPeriod().getValue();
            int remainder = referenceWithoutOffset % period;
            return reference + (period - remainder);
        }
        return offset;
    }

    @Override
    public int generatePreviousValue(int reference) throws NoSuchValueException {
        Every every = (Every)this.cronField.getExpression();
        if (reference < this.from) {
            throw new NoSuchValueException();
        }
        if (reference > this.to) {
            return this.to;
        }
        int period = every.getPeriod().getValue();
        int remainder = (reference - this.from) % period;
        if (remainder == 0) {
            return reference - period;
        }
        return reference - remainder;
    }

    @Override
    protected List<Integer> generateCandidatesNotIncludingIntervalExtremes(int start, int end) {
        ArrayList<Integer> values = new ArrayList<Integer>();
        try {
            int offset = this.offset();
            if (start < offset && offset < end) {
                values.add(offset);
            }
            int reference = this.generateNextValue(start);
            while (reference < end) {
                if (reference != offset) {
                    values.add(reference);
                }
                reference = this.generateNextValue(reference);
            }
        }
        catch (NoSuchValueException noSuchValueException) {
            // empty catch block
        }
        return values;
    }

    @Override
    public boolean isMatch(int value) {
        Every every = (Every)this.cronField.getExpression();
        int start = this.offset();
        return value >= start && (value - start) % every.getPeriod().getValue() == 0 && value >= this.from && value <= this.to;
    }

    @Override
    protected boolean matchesFieldExpressionClass(FieldExpression fieldExpression) {
        return fieldExpression instanceof Every;
    }

    @VisibleForTesting
    int offset() {
        FieldExpression expression = ((Every)this.cronField.getExpression()).getExpression();
        if (expression instanceof On) {
            return ((On)expression).getTime().getValue();
        }
        return this.from;
    }
}

