/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.javacv;

import java.io.File;
import org.bytedeco.javacpp.Loader;
import org.bytedeco.javacpp.opencv_core;
import org.bytedeco.javacpp.opencv_highgui;
import org.bytedeco.javacv.FrameRecorder;

public class OpenCVFrameRecorder
extends FrameRecorder {
    private static FrameRecorder.Exception loadingException = null;
    private static final boolean windows = Loader.getPlatform().startsWith("windows");
    private String filename;
    private opencv_highgui.CvVideoWriter writer = null;

    public static OpenCVFrameRecorder createDefault(File f, int w, int h) throws FrameRecorder.Exception {
        return new OpenCVFrameRecorder(f, w, h);
    }

    public static OpenCVFrameRecorder createDefault(String f, int w, int h) throws FrameRecorder.Exception {
        return new OpenCVFrameRecorder(f, w, h);
    }

    public static void tryLoad() throws FrameRecorder.Exception {
        if (loadingException != null) {
            throw loadingException;
        }
        try {
            Loader.load(opencv_highgui.class);
        }
        catch (Throwable t) {
            loadingException = new FrameRecorder.Exception("Failed to load " + OpenCVFrameRecorder.class, t);
            throw loadingException;
        }
    }

    public OpenCVFrameRecorder(File file, int imageWidth, int imageHeight) {
        this(file.getAbsolutePath(), imageWidth, imageHeight);
    }

    public OpenCVFrameRecorder(String filename, int imageWidth, int imageHeight) {
        this.filename = filename;
        this.imageWidth = imageWidth;
        this.imageHeight = imageHeight;
        this.pixelFormat = 1;
        this.videoCodec = windows ? -1 : opencv_highgui.CV_FOURCC_DEFAULT;
        this.frameRate = 30.0;
    }

    @Override
    public void release() throws FrameRecorder.Exception {
        if (this.writer != null) {
            opencv_highgui.cvReleaseVideoWriter((opencv_highgui.CvVideoWriter)this.writer);
            this.writer = null;
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.release();
    }

    @Override
    public void start() throws FrameRecorder.Exception {
        this.writer = opencv_highgui.cvCreateVideoWriter((String)this.filename, (int)this.videoCodec, (double)this.frameRate, (opencv_core.CvSize)opencv_core.cvSize((int)this.imageWidth, (int)this.imageHeight), (int)this.pixelFormat);
        if (this.writer == null) {
            throw new FrameRecorder.Exception("cvCreateVideoWriter(): Could not create a writer");
        }
    }

    @Override
    public void stop() throws FrameRecorder.Exception {
        this.release();
    }

    @Override
    public boolean record(opencv_core.IplImage frame) throws FrameRecorder.Exception {
        if (this.writer != null) {
            if (opencv_highgui.cvWriteFrame((opencv_highgui.CvVideoWriter)this.writer, (opencv_core.IplImage)frame) == 0) {
                throw new FrameRecorder.Exception("cvWriteFrame(): Could not record frame");
            }
        } else {
            throw new FrameRecorder.Exception("Cannot record: There is no writer (Has start() been called?)");
        }
        return true;
    }
}

