/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.langgraph4j.spring.ai.serializer.jackson;

import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.module.SimpleModule;
import org.bsc.langgraph4j.serializer.plain_text.jackson.JacksonStateSerializer;
import org.bsc.langgraph4j.serializer.plain_text.jackson.TypeMapper;
import org.bsc.langgraph4j.spring.ai.serializer.jackson.AssistantMessageHandler;
import org.bsc.langgraph4j.spring.ai.serializer.jackson.SystemMessageHandler;
import org.bsc.langgraph4j.spring.ai.serializer.jackson.ToolResponseMessageHandler;
import org.bsc.langgraph4j.spring.ai.serializer.jackson.UserMessageHandler;
import org.bsc.langgraph4j.state.AgentState;
import org.bsc.langgraph4j.state.AgentStateFactory;
import org.springframework.ai.chat.messages.AssistantMessage;
import org.springframework.ai.chat.messages.MessageType;
import org.springframework.ai.chat.messages.SystemMessage;
import org.springframework.ai.chat.messages.ToolResponseMessage;
import org.springframework.ai.chat.messages.UserMessage;

public class SpringAIJacksonStateSerializer<State extends AgentState>
extends JacksonStateSerializer<State> {
    public SpringAIJacksonStateSerializer(AgentStateFactory<State> stateFactory) {
        super(stateFactory);
        SimpleModule module = new SimpleModule();
        ChatMessageSerializer.registerTo(module);
        ChatMessageDeserializer.registerTo(module);
        this.typeMapper.register((TypeMapper.Reference)new TypeMapper.Reference<ToolResponseMessage>(MessageType.TOOL.name()){}).register((TypeMapper.Reference)new TypeMapper.Reference<SystemMessage>(MessageType.SYSTEM.name()){}).register((TypeMapper.Reference)new TypeMapper.Reference<UserMessage>(MessageType.USER.name()){}).register((TypeMapper.Reference)new TypeMapper.Reference<AssistantMessage>(MessageType.ASSISTANT.name()){});
        this.objectMapper.registerModule((Module)module);
    }

    static interface ChatMessageSerializer {
        public static final SystemMessageHandler.Serializer system = new SystemMessageHandler.Serializer();
        public static final UserMessageHandler.Serializer user = new UserMessageHandler.Serializer();
        public static final AssistantMessageHandler.Serializer ai = new AssistantMessageHandler.Serializer();
        public static final ToolResponseMessageHandler.Serializer tool = new ToolResponseMessageHandler.Serializer();

        public static void registerTo(SimpleModule module) {
            module.addSerializer(ToolResponseMessage.class, (JsonSerializer)tool).addSerializer(SystemMessage.class, (JsonSerializer)system).addSerializer(UserMessage.class, (JsonSerializer)user).addSerializer(AssistantMessage.class, (JsonSerializer)ai);
        }
    }

    static interface ChatMessageDeserializer {
        public static final SystemMessageHandler.Deserializer system = new SystemMessageHandler.Deserializer();
        public static final UserMessageHandler.Deserializer user = new UserMessageHandler.Deserializer();
        public static final AssistantMessageHandler.Deserializer ai = new AssistantMessageHandler.Deserializer();
        public static final ToolResponseMessageHandler.Deserializer tool = new ToolResponseMessageHandler.Deserializer();

        public static void registerTo(SimpleModule module) {
            module.addDeserializer(ToolResponseMessage.class, (JsonDeserializer)tool).addDeserializer(SystemMessage.class, (JsonDeserializer)system).addDeserializer(UserMessage.class, (JsonDeserializer)user).addDeserializer(AssistantMessage.class, (JsonDeserializer)ai);
        }
    }
}

