/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.langgraph4j.spring.ai.serializer.std;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.bsc.langgraph4j.serializer.Serializer;
import org.bsc.langgraph4j.spring.ai.serializer.std.AssistantMessageSerializer;
import org.bsc.langgraph4j.spring.ai.serializer.std.SystemMessageSerializer;
import org.bsc.langgraph4j.spring.ai.serializer.std.ToolResponseMessageSerializer;
import org.bsc.langgraph4j.spring.ai.serializer.std.UserMessageSerializer;
import org.springframework.ai.chat.messages.AssistantMessage;
import org.springframework.ai.chat.messages.Message;
import org.springframework.ai.chat.messages.MessageType;
import org.springframework.ai.chat.messages.SystemMessage;
import org.springframework.ai.chat.messages.ToolResponseMessage;
import org.springframework.ai.chat.messages.UserMessage;

public class MessageSerializer
implements Serializer<Message> {
    final UserMessageSerializer user = new UserMessageSerializer();
    final AssistantMessageSerializer assistant = new AssistantMessageSerializer();
    final SystemMessageSerializer system = new SystemMessageSerializer();
    final ToolResponseMessageSerializer tool = new ToolResponseMessageSerializer();

    public void write(Message object, ObjectOutput out) throws IOException {
        out.writeObject(object.getMessageType());
        switch (object.getMessageType()) {
            case USER: {
                this.user.write((UserMessage)object, out);
                break;
            }
            case ASSISTANT: {
                this.assistant.write((AssistantMessage)object, out);
                break;
            }
            case SYSTEM: {
                this.system.write((SystemMessage)object, out);
                break;
            }
            case TOOL: {
                this.tool.write((ToolResponseMessage)object, out);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported message type: " + String.valueOf(object.getMessageType()));
            }
        }
    }

    public Message read(ObjectInput in) throws IOException, ClassNotFoundException {
        MessageType type = (MessageType)in.readObject();
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case MessageType.ASSISTANT -> this.assistant.read(in);
            case MessageType.USER -> this.user.read(in);
            case MessageType.SYSTEM -> this.system.read(in);
            case MessageType.TOOL -> this.tool.read(in);
        };
    }
}

