/*
 * Decompiled with CFR 0.152.
 */
package org.brickred.socialauth.spring.controller;

import java.util.HashMap;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.brickred.socialauth.AuthProvider;
import org.brickred.socialauth.SocialAuthManager;
import org.brickred.socialauth.spring.bean.SocialAuthTemplate;
import org.brickred.socialauth.util.SocialAuthUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"/socialauth"})
public class SocialAuthWebController {
    private String baseCallbackUrl;
    private String successPageURL;
    private String accessDeniedPageURL;
    @Autowired
    private SocialAuthTemplate socialAuthTemplate;
    @Autowired
    private SocialAuthManager socialAuthManager;
    private final Log LOG = LogFactory.getLog(this.getClass());

    @Inject
    public SocialAuthWebController(String applicationUrl, String successPageURL, String accessDeniedPageURL) {
        this.baseCallbackUrl = applicationUrl;
        this.successPageURL = successPageURL;
        this.accessDeniedPageURL = accessDeniedPageURL;
    }

    @RequestMapping(params={"id"})
    private String connect(@RequestParam(value="id") String providerId, HttpServletRequest request) throws Exception {
        this.LOG.debug((Object)("Getting Authentication URL for :" + providerId));
        String callbackURL = this.baseCallbackUrl + request.getServletPath();
        String url = this.socialAuthManager.getAuthenticationUrl(providerId, callbackURL);
        if (callbackURL.equals(url)) {
            url = this.successPageURL;
            this.socialAuthManager.connect(new HashMap());
        }
        this.socialAuthTemplate.setSocialAuthManager(this.socialAuthManager);
        return "redirect:" + url;
    }

    @RequestMapping(params={"oauth_token"})
    private String oauthCallback(HttpServletRequest request) {
        this.callback(request);
        return "redirect:/" + this.successPageURL;
    }

    @RequestMapping(params={"code"})
    private String oauth2Callback(HttpServletRequest request) {
        this.callback(request);
        return "redirect:/" + this.successPageURL;
    }

    @RequestMapping(params={"wrap_verification_code"})
    private String hotmailCallback(HttpServletRequest request) {
        this.callback(request);
        return "redirect:/" + this.successPageURL;
    }

    @RequestMapping(params={"openid.claimed_id"})
    private String openidCallback(HttpServletRequest request) {
        this.callback(request);
        return "redirect:/" + this.successPageURL;
    }

    private void callback(HttpServletRequest request) {
        SocialAuthManager m = this.socialAuthTemplate.getSocialAuthManager();
        if (m != null) {
            try {
                AuthProvider provider = m.connect(SocialAuthUtil.getRequestParametersMap((HttpServletRequest)request));
                this.LOG.debug((Object)("Connected Provider : " + provider.getProviderId()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            this.LOG.debug((Object)"Unable to connect provider because SocialAuthManager object is null.");
        }
    }

    @RequestMapping(params={"error", "error_reason"})
    private String fbCancel(@RequestParam(value="error_reason") String error) {
        this.LOG.debug((Object)("Facebook send an error : " + error));
        if ("user_denied".equals(error)) {
            return "redirect:/" + this.accessDeniedPageURL;
        }
        return "redirect:/";
    }

    @RequestMapping(params={"openid.mode=cancel"})
    private String googleCancel(@RequestParam(value="openid.mode") String error) {
        this.LOG.debug((Object)("Google send an error : " + error));
        if ("cancel".equals(error)) {
            return "redirect:/" + this.accessDeniedPageURL;
        }
        return "redirect:/";
    }

    @RequestMapping(params={"wrap_error_reason"})
    private String hotmailCancel(@RequestParam(value="wrap_error_reason") String error) {
        this.LOG.debug((Object)("Hotmail send an error : " + error));
        if ("user_denied".equals(error)) {
            return "redirect:/" + this.accessDeniedPageURL;
        }
        return "redirect:/";
    }

    @RequestMapping(params={"oauth_problem"})
    private String myspaceCancel(@RequestParam(value="oauth_problem") String error) {
        this.LOG.debug((Object)("MySpace send an error : " + error));
        if ("user_refused".equals(error)) {
            return "redirect:/" + this.accessDeniedPageURL;
        }
        return "redirect:/";
    }

    @RequestMapping(params={"error"})
    private String gitHubCancel(@RequestParam(value="error") String error) {
        this.LOG.debug((Object)("Provider send an error : " + error));
        if ("access_denied".equals(error)) {
            return "redirect:/" + this.accessDeniedPageURL;
        }
        return "redirect:/";
    }
}

