/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.fips;

import java.io.ByteArrayOutputStream;
import java.math.BigInteger;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.KDFCalculator;
import org.bouncycastle.crypto.Parameters;
import org.bouncycastle.crypto.PasswordConverter;
import org.bouncycastle.crypto.fips.ConcatenationKDFGenerator;
import org.bouncycastle.crypto.fips.FipsAES;
import org.bouncycastle.crypto.fips.FipsAgreementParameters;
import org.bouncycastle.crypto.fips.FipsAlgorithm;
import org.bouncycastle.crypto.fips.FipsEngineProvider;
import org.bouncycastle.crypto.fips.FipsKDFOperatorFactory;
import org.bouncycastle.crypto.fips.FipsParameters;
import org.bouncycastle.crypto.fips.FipsSHS;
import org.bouncycastle.crypto.fips.FipsSelfTestFailedError;
import org.bouncycastle.crypto.fips.FipsStatus;
import org.bouncycastle.crypto.fips.FipsTripleDES;
import org.bouncycastle.crypto.fips.FipsUnapprovedOperationError;
import org.bouncycastle.crypto.fips.HKDFBytesGenerator;
import org.bouncycastle.crypto.fips.HKDFKeyGenerator;
import org.bouncycastle.crypto.fips.KDF2BytesGenerator;
import org.bouncycastle.crypto.fips.KDFCounterBytesGenerator;
import org.bouncycastle.crypto.fips.KDFDoublePipelineIterationBytesGenerator;
import org.bouncycastle.crypto.fips.KDFFeedbackBytesGenerator;
import org.bouncycastle.crypto.fips.KMAC;
import org.bouncycastle.crypto.fips.MD5Digest;
import org.bouncycastle.crypto.fips.SelfTestExecutor;
import org.bouncycastle.crypto.fips.TwoStepKeyGenerator;
import org.bouncycastle.crypto.fips.Utils;
import org.bouncycastle.crypto.fips.VariantKatTest;
import org.bouncycastle.crypto.internal.BlockCipher;
import org.bouncycastle.crypto.internal.Digest;
import org.bouncycastle.crypto.internal.EngineProvider;
import org.bouncycastle.crypto.internal.ExtendedDigest;
import org.bouncycastle.crypto.internal.Mac;
import org.bouncycastle.crypto.internal.StreamCipher;
import org.bouncycastle.crypto.internal.macs.HMac;
import org.bouncycastle.crypto.internal.modes.SICBlockCipher;
import org.bouncycastle.crypto.internal.params.HKDFKeyParameters;
import org.bouncycastle.crypto.internal.params.HKDFParameters;
import org.bouncycastle.crypto.internal.params.KDFCounterParameters;
import org.bouncycastle.crypto.internal.params.KDFDoublePipelineIterationParameters;
import org.bouncycastle.crypto.internal.params.KDFFeedbackParameters;
import org.bouncycastle.crypto.internal.params.KDFParameters;
import org.bouncycastle.crypto.internal.params.KeyParameterImpl;
import org.bouncycastle.crypto.internal.params.ParametersWithIV;
import org.bouncycastle.crypto.internal.test.BasicKatTest;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Pack;
import org.bouncycastle.util.Properties;
import org.bouncycastle.util.Strings;
import org.bouncycastle.util.encoders.Hex;

public final class FipsKDF {
    private static final byte[] ZERO_BYTE = new byte[1];
    public static final CounterModeParametersBuilder COUNTER_MODE = new CounterModeParametersBuilder(new FipsAlgorithm("CounterMode"));
    public static final FeedbackModeParametersBuilder FEEDBACK_MODE = new FeedbackModeParametersBuilder(new FipsAlgorithm("FeedbackMode"));
    public static final DoublePipelineModeParametersBuilder DOUBLE_PIPELINE_ITERATION_MODE = new DoublePipelineModeParametersBuilder(new FipsAlgorithm("DoublePipelineIterationMode"));
    public static final SSHParametersBuilder SSH = new SSHParametersBuilder(new FipsAlgorithm("SSH"), SSHPRF.SHA1);
    public static final IKEv2ParametersBuilder IKEv2 = new IKEv2ParametersBuilder(new FipsAlgorithm("IKEv2"), IKEv2PRF.SHA1);
    public static final SRTPParametersBuilder SRTP = new SRTPParametersBuilder(new FipsAlgorithm("SRTP"), SRTPPRF.AES_CM);
    public static final TLSParametersBuilder TLS1_0 = new TLSParametersBuilder(new FipsAlgorithm("TLS1.0"));
    public static final TLSParametersBuilder TLS1_1 = new TLSParametersBuilder(new FipsAlgorithm("TLS1.1"));
    public static final TLSParametersWithPRFBuilder TLS1_2 = new TLSParametersWithPRFBuilder(new FipsAlgorithm("TLS1.2"), TLSPRF.SHA256_HMAC);
    public static final AgreementKDFParametersBuilder X963 = new AgreementKDFParametersBuilder(new FipsAlgorithm("X9.63"), AgreementKDFPRF.SHA1);
    public static final AgreementKDFParametersBuilder CONCATENATION = new AgreementKDFParametersBuilder(new FipsAlgorithm("Concatenation"), AgreementKDFPRF.SHA1);
    public static final HKDFKeyBuilder HKDF_KEY_BUILDER = new HKDFKeyBuilder(new FipsAlgorithm("HKDF"), AgreementKDFPRF.SHA1, null, false);
    public static final AgreementKDFParametersBuilder HKDF = new AgreementKDFParametersBuilder(new FipsAlgorithm("HKDF"), AgreementKDFPRF.SHA1);
    public static final TwoStepKDFKeyBuilder TWO_STEP_KEY_BUILDER = new TwoStepKDFKeyBuilder(new FipsAlgorithm("HKDF"), PRF.SHA256_HMAC, null);
    public static final SNMPParametersBuilder SNMP = new SNMPParametersBuilder(new FipsAlgorithm("SNMP"));
    private static EngineProvider<Digest> md5Provider = new EngineProvider<Digest>(){

        @Override
        public Digest createEngine() {
            return SelfTestExecutor.validate(TLS1_0.getAlgorithm(), new MD5Digest(), new Md5KatTest());
        }
    };

    private FipsKDF() {
    }

    private static byte[] buildFixedInput(byte[] byArray, byte[] byArray2, int n) {
        return Arrays.concatenate(byArray, ZERO_BYTE, byArray2, Pack.intToBigEndian(n));
    }

    private static FipsEngineProvider<Mac> createPRF(PRF pRF) {
        FipsEngineProvider<Mac> fipsEngineProvider;
        if (pRF == PRF.TRIPLEDES_CMAC) {
            if (!FipsStatus.isBooting() && CryptoServicesRegistrar.isInApprovedOnlyMode() && !Properties.isOverrideSet("org.bouncycastle.tripledes.allow_prf")) {
                throw new FipsUnapprovedOperationError("Triple-DES prf disallowed");
            }
            fipsEngineProvider = FipsTripleDES.getMacProvider(FipsTripleDES.CMAC.getAlgorithm());
        } else {
            fipsEngineProvider = pRF == PRF.AES_CMAC ? FipsAES.getMacProvider(FipsAES.CMAC.getAlgorithm()) : FipsSHS.getMacProvider(pRF.algorithm);
        }
        if (fipsEngineProvider == null) {
            throw new IllegalArgumentException("Unknown algorithm passed to FipsKDF.createPRF: " + (Object)((Object)pRF));
        }
        return fipsEngineProvider;
    }

    static byte[] processZBytes(byte[] byArray, FipsAgreementParameters fipsAgreementParameters) {
        PRF pRF = fipsAgreementParameters.getPrfAlgorithm();
        byte[] byArray2 = fipsAgreementParameters.salt;
        FipsAlgorithm fipsAlgorithm = fipsAgreementParameters.digestAlgorithm;
        AgreementOperatorFactory agreementOperatorFactory = new AgreementOperatorFactory();
        AgreementKDFParametersBuilder agreementKDFParametersBuilder = fipsAgreementParameters.kdfType;
        if (pRF == PRF.TRIPLEDES_CMAC && CryptoServicesRegistrar.isInApprovedOnlyMode()) {
            throw new FipsUnapprovedOperationError("Requested PRF has insufficient security level for approved mode: " + pRF.name());
        }
        if (pRF != null) {
            Mac mac = (Mac)FipsKDF.createPRF(pRF).createEngine();
            if (byArray2 == null) {
                if (mac instanceof HMac) {
                    mac.init(new KeyParameterImpl(new byte[((HMac)mac).getUnderlyingDigest().getByteLength()]));
                } else {
                    mac.init(new KeyParameterImpl(new byte[16]));
                }
            } else {
                mac.init(new KeyParameterImpl(Arrays.clone(byArray2)));
            }
            byte[] byArray3 = new byte[mac.getMacSize()];
            mac.update(byArray, 0, byArray.length);
            mac.doFinal(byArray3, 0);
            Arrays.fill(byArray, (byte)0);
            return byArray3;
        }
        if (fipsAlgorithm != null) {
            ExtendedDigest extendedDigest = FipsSHS.createDigest(fipsAlgorithm);
            byte[] byArray4 = new byte[extendedDigest.getDigestSize()];
            extendedDigest.update(byArray, 0, byArray.length);
            extendedDigest.doFinal(byArray4, 0);
            Arrays.fill(byArray, (byte)0);
            return byArray4;
        }
        if (agreementKDFParametersBuilder != null) {
            KDFCalculator<AgreementKDFParameters> kDFCalculator = agreementOperatorFactory.createKDFCalculator(agreementKDFParametersBuilder.using(byArray).withIV(byArray2));
            Arrays.fill(byArray, (byte)0);
            byte[] byArray5 = new byte[fipsAgreementParameters.outputSize];
            kDFCalculator.generateBytes(byArray5);
            return byArray5;
        }
        return byArray;
    }

    private static byte[] PRF(TLSParameters tLSParameters, TLSPRF tLSPRF, byte[] byArray, String string, int n) {
        byte[] byArray2 = Strings.toByteArray(string);
        byte[] byArray3 = Arrays.concatenate(byArray2, tLSParameters.seed);
        Mac mac = FipsSHS.createHMac(tLSPRF.algorithm);
        byte[] byArray4 = new byte[n];
        FipsKDF.hmac_hash(mac, byArray, byArray3, byArray4);
        return byArray4;
    }

    private static byte[] PRF_legacy(TLSParameters tLSParameters, byte[] byArray, String string, int n, Mac mac, Mac mac2) {
        byte[] byArray2 = Strings.toByteArray(string);
        byte[] byArray3 = Arrays.concatenate(byArray2, tLSParameters.seed);
        int n2 = (byArray.length + 1) / 2;
        byte[] byArray4 = new byte[n2];
        byte[] byArray5 = new byte[n2];
        System.arraycopy(byArray, 0, byArray4, 0, n2);
        System.arraycopy(byArray, byArray.length - n2, byArray5, 0, n2);
        byte[] byArray6 = new byte[n];
        byte[] byArray7 = new byte[n];
        FipsKDF.hmac_hash(mac, byArray4, byArray3, byArray6);
        FipsKDF.hmac_hash(mac2, byArray5, byArray3, byArray7);
        for (int i = 0; i < n; ++i) {
            int n3 = i;
            byArray6[n3] = (byte)(byArray6[n3] ^ byArray7[i]);
        }
        return byArray6;
    }

    private static void hmac_hash(Mac mac, byte[] byArray, byte[] byArray2, byte[] byArray3) {
        mac.init(new KeyParameterImpl(byArray));
        byte[] byArray4 = byArray2;
        int n = mac.getMacSize();
        int n2 = (byArray3.length + n - 1) / n;
        byte[] byArray5 = new byte[mac.getMacSize()];
        byte[] byArray6 = new byte[mac.getMacSize()];
        for (int i = 0; i < n2; ++i) {
            mac.update(byArray4, 0, byArray4.length);
            mac.doFinal(byArray5, 0);
            byArray4 = byArray5;
            mac.update(byArray4, 0, byArray4.length);
            mac.update(byArray2, 0, byArray2.length);
            mac.doFinal(byArray6, 0);
            System.arraycopy(byArray6, 0, byArray3, n * i, Math.min(n, byArray3.length - n * i));
        }
    }

    private static KDFCalculator<AgreementKDFParameters> createX963KDFCalculator(boolean bl, final AgreementKDFParameters agreementKDFParameters) {
        Utils.approvedModeCheck(bl, agreementKDFParameters.getAlgorithm());
        final KDF2BytesGenerator kDF2BytesGenerator = new X963KDFProvider(agreementKDFParameters.getAlgorithm()).createEngine();
        kDF2BytesGenerator.init(new KDFParameters(agreementKDFParameters.shared, agreementKDFParameters.iv));
        return new MonitoringKDFCalculator<AgreementKDFParameters>(bl, new BaseKDFCalculator<AgreementKDFParameters>(){

            @Override
            public AgreementKDFParameters getParameters() {
                return agreementKDFParameters;
            }

            @Override
            public void generateBytes(byte[] byArray, int n, int n2) {
                kDF2BytesGenerator.generateBytes(byArray, n, n2);
            }
        });
    }

    private static KDFCalculator<AgreementKDFParameters> createHKDFCalculator(boolean bl, final AgreementKDFParameters agreementKDFParameters) {
        Utils.approvedModeCheck(bl, agreementKDFParameters.getAlgorithm());
        final HKDFBytesGenerator hKDFBytesGenerator = new HKDFProvider(agreementKDFParameters.getAlgorithm()).createEngine();
        hKDFBytesGenerator.init(new HKDFParameters(new KeyParameterImpl(agreementKDFParameters.shared), agreementKDFParameters.iv));
        return new MonitoringKDFCalculator<AgreementKDFParameters>(bl, new BaseKDFCalculator<AgreementKDFParameters>(){

            @Override
            public AgreementKDFParameters getParameters() {
                return agreementKDFParameters;
            }

            @Override
            public void generateBytes(byte[] byArray, int n, int n2) {
                hKDFBytesGenerator.generateBytes(byArray, n, n2);
            }
        });
    }

    private static KDFCalculator<AgreementKDFParameters> createConcatenationKDFCalculator(boolean bl, final AgreementKDFParameters agreementKDFParameters) {
        Utils.approvedModeCheck(bl, agreementKDFParameters.getAlgorithm());
        final ConcatenationKDFGenerator concatenationKDFGenerator = new ConcatenationKDFProvider(agreementKDFParameters.getAlgorithm()).createEngine();
        concatenationKDFGenerator.init(new KDFParameters(agreementKDFParameters.shared, agreementKDFParameters.salt, agreementKDFParameters.iv));
        return new MonitoringKDFCalculator<AgreementKDFParameters>(bl, new BaseKDFCalculator<AgreementKDFParameters>(){

            @Override
            public AgreementKDFParameters getParameters() {
                return agreementKDFParameters;
            }

            @Override
            public void generateBytes(byte[] byArray, int n, int n2) {
                concatenationKDFGenerator.generateBytes(byArray, n, n2);
            }
        });
    }

    private static void tlsLegacyKAT() {
        HMac hMac = new HMac(md5Provider.createEngine());
        Mac mac = FipsSHS.createHMac(FipsSHS.Algorithm.SHA1_HMAC);
        TLSParameters tLSParameters = new TLSParameters(TLS1_0.getAlgorithm(), Hex.decode("0102030405060708090a0b0c0d0e0f"), "master secret", Hex.decode("deadbeefbeefdead"));
        byte[] byArray = FipsKDF.PRF_legacy(tLSParameters, tLSParameters.secret, tLSParameters.label, 32, hMac, mac);
        if (!Arrays.areEqual(byArray, Hex.decode("ef9dca01113c0f6fcaef528e604b3092c8e65022de73a1b117408297a0d969a9"))) {
            FipsStatus.moveToErrorStatus(new FipsSelfTestFailedError("Exception on self test: TLS Legacy KAT", TLS1_0.getAlgorithm()));
        }
    }

    private static void tls1_1and2KAT() {
        TLSParameters tLSParameters = new TLSParameters(TLS1_2.getAlgorithm(), Hex.decode("0102030405060708090a0b0c0d0e0f"), "master secret", Hex.decode("deadbeefbeefdead"));
        byte[] byArray = FipsKDF.PRF(tLSParameters, TLSPRF.SHA256_HMAC, tLSParameters.secret, tLSParameters.label, 32);
        if (!Arrays.areEqual(byArray, Hex.decode("fd9224c363882243d0d949139981093693407e438a508b3c324fd163247e210f"))) {
            FipsStatus.moveToErrorStatus(new FipsSelfTestFailedError("Exception on self test: TLS KAT", TLS1_1.getAlgorithm()));
        }
    }

    private static void tls1_3KAT() {
        byte[] byArray = new byte[32];
        byte[] byArray2 = Hex.decode("E16869403C8451F78E671BCF2D22239F02D8FB8A322F459F0A6761EBE5ED2D2B7B5B66D23C559DB492");
        byte[] byArray3 = Hex.decode("56F181EBDFD6A84EDD35C92ADC99EE5FC510AC2D44AE9D53C5B9089A768125FD0B2DCCAD80EC1BB38A");
        byte[] byArray4 = Strings.toByteArray("tls13 c e traffic");
        ExtendedDigest extendedDigest = FipsSHS.createDigest(FipsSHS.Algorithm.SHA256);
        byte[] byArray5 = new byte[extendedDigest.getDigestSize()];
        extendedDigest.update(byArray3, 0, byArray3.length);
        extendedDigest.doFinal(byArray5, 0);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byteArrayOutputStream.write(0);
        byteArrayOutputStream.write(32);
        byteArrayOutputStream.write((byte)byArray4.length);
        byteArrayOutputStream.write(byArray4, 0, byArray4.length);
        byteArrayOutputStream.write((byte)byArray5.length);
        byteArrayOutputStream.write(byArray5, 0, byArray5.length);
        byte[] byArray6 = byteArrayOutputStream.toByteArray();
        HKDFKey hKDFKey = HKDF_KEY_BUILDER.withPrf(AgreementKDFPRF.SHA256_HMAC).withSalt(byArray).build(byArray2);
        KDFCalculator<AgreementKDFParameters> kDFCalculator = new AgreementOperatorFactory().createKDFCalculator(HKDF.withPRF(hKDFKey.getPRF()).using(hKDFKey.getKey()).withIV(byArray6));
        byte[] byArray7 = new byte[32];
        kDFCalculator.generateBytes(byArray7);
        if (!Arrays.areEqual(byArray7, Hex.decode("fd7f6f0b9079a81fdfa3293f79e2350c2f7c5d93cac1b5b208811c48a1d6dd02"))) {
            FipsStatus.moveToErrorStatus(new FipsSelfTestFailedError("Exception on self test", HKDF.getAlgorithm()));
        }
    }

    private static void sshKAT() {
        ExtendedDigest extendedDigest = FipsSHS.createDigest(FipsSHS.Algorithm.SHA256);
        SSHParameters sSHParameters = new SSHParameters(SSH.getAlgorithm(), 'A', Hex.decode("0102030405060708090a0b0c0d0e0f"), Hex.decode("deadbeefbeefdead"), Hex.decode("a1a2a3a4a5a6a7a8a9a0aaabacadaeaf"));
        byte[] byArray = new byte[32];
        SSHOperatorFactory.hash(extendedDigest, sSHParameters, byArray, 0, 32);
        if (!Arrays.areEqual(byArray, Hex.decode("5ec5d5b69202eecc55e4d932cd9907352c349b0c2ecd2432356dba984495cf2d"))) {
            FipsStatus.moveToErrorStatus(new FipsSelfTestFailedError("Exception on self test: SSH KAT", SSH.getAlgorithm()));
        }
    }

    static {
        new CounterModeProvider(PRF.AES_CMAC).createEngine();
        new FeedbackModeProvider(PRF.SHA256_HMAC).createEngine();
        new DoublePipelineModeProvider(PRF.SHA3_256_HMAC).createEngine();
        new ConcatenationKDFProvider(AgreementKDFPRF.SHA256).createEngine();
        new ConcatenationKDFProvider(AgreementKDFPRF.SHA256_HMAC).createEngine();
        new ConcatenationKDFProvider(AgreementKDFPRF.KMAC_256).createEngine();
        new HKDFProvider(AgreementKDFPRF.SHA256_HMAC).createEngine();
        new X963KDFProvider(AgreementKDFPRF.SHA256).createEngine();
        FipsKDF.tlsLegacyKAT();
        FipsKDF.tls1_1and2KAT();
        FipsKDF.tls1_3KAT();
        FipsKDF.sshKAT();
    }

    public static enum AgreementKDFPRF {
        SHA1(FipsSHS.Algorithm.SHA1),
        SHA224(FipsSHS.Algorithm.SHA224),
        SHA256(FipsSHS.Algorithm.SHA256),
        SHA384(FipsSHS.Algorithm.SHA384),
        SHA512(FipsSHS.Algorithm.SHA512),
        SHA512_224(FipsSHS.Algorithm.SHA512_224),
        SHA512_256(FipsSHS.Algorithm.SHA512_256),
        SHA3_224(FipsSHS.Algorithm.SHA3_224),
        SHA3_256(FipsSHS.Algorithm.SHA3_256),
        SHA3_384(FipsSHS.Algorithm.SHA3_384),
        SHA3_512(FipsSHS.Algorithm.SHA3_512),
        SHA1_HMAC(FipsSHS.Algorithm.SHA1_HMAC),
        SHA224_HMAC(FipsSHS.Algorithm.SHA224_HMAC),
        SHA256_HMAC(FipsSHS.Algorithm.SHA256_HMAC),
        SHA384_HMAC(FipsSHS.Algorithm.SHA384_HMAC),
        SHA512_HMAC(FipsSHS.Algorithm.SHA512_HMAC),
        SHA512_224_HMAC(FipsSHS.Algorithm.SHA512_224_HMAC),
        SHA512_256_HMAC(FipsSHS.Algorithm.SHA512_256_HMAC),
        SHA3_224_HMAC(FipsSHS.Algorithm.SHA3_224_HMAC),
        SHA3_256_HMAC(FipsSHS.Algorithm.SHA3_256_HMAC),
        SHA3_384_HMAC(FipsSHS.Algorithm.SHA3_384_HMAC),
        SHA3_512_HMAC(FipsSHS.Algorithm.SHA3_512_HMAC),
        KMAC_128(FipsSHS.Algorithm.KMAC128),
        KMAC_256(FipsSHS.Algorithm.KMAC256);

        private final FipsAlgorithm algorithm;

        private AgreementKDFPRF(FipsAlgorithm fipsAlgorithm) {
            this.algorithm = fipsAlgorithm;
        }

        public FipsAlgorithm getAlgorithm() {
            return this.algorithm;
        }
    }

    public static class AgreementKDFParameters
    extends FipsParameters {
        private final byte[] shared;
        private final byte[] iv;
        private final byte[] salt;

        AgreementKDFParameters(FipsAlgorithm fipsAlgorithm, byte[] byArray) {
            this(fipsAlgorithm, byArray, null, null);
        }

        AgreementKDFParameters(FipsAlgorithm fipsAlgorithm, byte[] byArray, byte[] byArray2, byte[] byArray3) {
            super(fipsAlgorithm);
            this.shared = byArray;
            this.iv = byArray2;
            this.salt = byArray3;
        }

        public AgreementKDFParameters withIV(byte[] byArray) {
            return new AgreementKDFParameters(this.getAlgorithm(), this.shared, Arrays.clone(byArray), this.salt);
        }

        public AgreementKDFParameters withSalt(byte[] byArray) {
            return new AgreementKDFParameters(this.getAlgorithm(), this.shared, this.iv, Arrays.clone(byArray));
        }
    }

    public static final class AgreementKDFParametersBuilder
    extends FipsParameters {
        AgreementKDFPRF prf;

        AgreementKDFParametersBuilder(FipsAlgorithm fipsAlgorithm, AgreementKDFPRF agreementKDFPRF) {
            super(fipsAlgorithm);
            this.prf = agreementKDFPRF;
        }

        public AgreementKDFParametersBuilder withPRF(AgreementKDFPRF agreementKDFPRF) {
            return new AgreementKDFParametersBuilder(this.getAlgorithm(), agreementKDFPRF);
        }

        public AgreementKDFParameters using(byte[] byArray) {
            return new AgreementKDFParameters(new FipsAlgorithm(this.getAlgorithm(), (Enum)this.prf), Arrays.clone(byArray));
        }

        public AgreementKDFPRF getPRF() {
            return this.prf;
        }
    }

    public static final class AgreementOperatorFactory
    extends FipsKDFOperatorFactory<AgreementKDFParameters> {
        @Override
        public KDFCalculator<AgreementKDFParameters> createKDFCalculator(AgreementKDFParameters agreementKDFParameters) {
            if (agreementKDFParameters.getAlgorithm().getName().startsWith(HKDF.getAlgorithm().getName())) {
                return FipsKDF.createHKDFCalculator(this.approvedModeOnly, agreementKDFParameters);
            }
            if (agreementKDFParameters.getAlgorithm().getName().startsWith(X963.getAlgorithm().getName())) {
                return FipsKDF.createX963KDFCalculator(this.approvedModeOnly, agreementKDFParameters);
            }
            return FipsKDF.createConcatenationKDFCalculator(this.approvedModeOnly, agreementKDFParameters);
        }
    }

    private static interface BaseKDFCalculator<T extends Parameters> {
        public T getParameters();

        public void generateBytes(byte[] var1, int var2, int var3);
    }

    private static final class ConcatenationKDFProvider
    extends FipsEngineProvider<ConcatenationKDFGenerator> {
        private static final byte[] KI = Hex.decode("dff1e50ac0b69dc40f1051d46c2b069c");
        private static final byte[] SALT = Hex.decodeStrict("000102030405060708090a0b0c0d0e0f");
        private static final byte[] IV = Hex.decodeStrict("0f0e0d0c0b0a09080706050403020100");
        private static final byte[] sha1_vec = Hex.decode("f89675c938dadad63345");
        private static final byte[] sha224_vec = Hex.decode("e313f82f00890ef4dda5");
        private static final byte[] sha256_vec = Hex.decode("b9da5516890810968d52");
        private static final byte[] sha384_vec = Hex.decode("c744ab7f6e5e733d19e6");
        private static final byte[] sha512_vec = Hex.decode("ec82b585251123e68c5b");
        private static final byte[] sha512_224_vec = Hex.decode("4c8d06f59e3509a4a1e9");
        private static final byte[] sha512_256_vec = Hex.decode("4e7f8bf4e469c9bc43ad");
        private static final byte[] sha3_224_vec = Hex.decode("2e1ffe3b128e29aefd0f");
        private static final byte[] sha3_256_vec = Hex.decode("2c6e9f731555f185b454");
        private static final byte[] sha3_384_vec = Hex.decode("74c5f03852595114fab2");
        private static final byte[] sha3_512_vec = Hex.decode("58bf8f48097d728bbafa");
        private static final byte[] sha1hmac_vec = Hex.decode("3f9bea499e413964eadf");
        private static final byte[] sha224hmac_vec = Hex.decode("aeeedd9ef8dac5893e8b");
        private static final byte[] sha256hmac_vec = Hex.decode("57a33dd8e888ae7d708d");
        private static final byte[] sha384hmac_vec = Hex.decode("f42a6398fa9395ff5cbb");
        private static final byte[] sha512hmac_vec = Hex.decode("7bacd0d6850f9ad8e5e0");
        private static final byte[] sha512_224hmac_vec = Hex.decode("082e5f02d22652a56d89");
        private static final byte[] sha512_256hmac_vec = Hex.decode("70e76b3b960bc24ed0a4");
        private static final byte[] sha3_224hmac_vec = Hex.decode("ff833670b06e8fdb26ee");
        private static final byte[] sha3_256hmac_vec = Hex.decode("88cb01e86c29c709e080");
        private static final byte[] sha3_384hmac_vec = Hex.decode("5d1bea4994086f3e7522");
        private static final byte[] sha3_512hmac_vec = Hex.decode("d567f8c3531014e36fc9");
        private static final byte[] kmac128_vec = Hex.decode("6327e56ae5ae4ce35b83");
        private static final byte[] kmac256_vec = Hex.decode("fca9dc547ba19dea4115");
        private final FipsAlgorithm algorithm;

        public ConcatenationKDFProvider(FipsAlgorithm fipsAlgorithm) {
            this.algorithm = fipsAlgorithm;
        }

        public ConcatenationKDFProvider(AgreementKDFPRF agreementKDFPRF) {
            this(new FipsAlgorithm(CONCATENATION.getAlgorithm(), (Enum)agreementKDFPRF));
        }

        @Override
        public ConcatenationKDFGenerator createEngine() {
            ConcatenationKDFGenerator concatenationKDFGenerator;
            final AgreementKDFPRF agreementKDFPRF = (AgreementKDFPRF)this.algorithm.basicVariation();
            ExtendedDigest extendedDigest = FipsSHS.createDigest(agreementKDFPRF.algorithm);
            Mac mac = FipsSHS.createHMac(agreementKDFPRF.algorithm);
            if (extendedDigest != null) {
                concatenationKDFGenerator = new ConcatenationKDFGenerator(extendedDigest);
            } else {
                if (mac == null) {
                    if (agreementKDFPRF.algorithm == FipsSHS.Algorithm.KMAC128) {
                        mac = new KMAC(128, Strings.toByteArray("KDF"));
                    } else if (agreementKDFPRF.algorithm == FipsSHS.Algorithm.KMAC256) {
                        mac = new KMAC(256, Strings.toByteArray("KDF"));
                    } else {
                        throw new IllegalArgumentException("PRF not recognized");
                    }
                }
                concatenationKDFGenerator = new ConcatenationKDFGenerator(mac);
            }
            return SelfTestExecutor.validate(this.algorithm, concatenationKDFGenerator, new VariantKatTest<ConcatenationKDFGenerator>(){

                @Override
                public void evaluate(ConcatenationKDFGenerator concatenationKDFGenerator2) {
                    concatenationKDFGenerator.init(new KDFParameters(KI, SALT, IV));
                    byte[] byArray = new byte[10];
                    concatenationKDFGenerator.generateBytes(byArray, 0, byArray.length);
                    if (!Arrays.areEqual(ConcatenationKDFProvider.expectedOutput(agreementKDFPRF), byArray)) {
                        this.fail("failed self test on generation: " + Hex.toHexString(byArray));
                    }
                }
            });
        }

        private static byte[] expectedOutput(AgreementKDFPRF agreementKDFPRF) {
            switch (agreementKDFPRF) {
                case SHA1: {
                    return sha1_vec;
                }
                case SHA224: {
                    return sha224_vec;
                }
                case SHA256: {
                    return sha256_vec;
                }
                case SHA384: {
                    return sha384_vec;
                }
                case SHA512: {
                    return sha512_vec;
                }
                case SHA512_224: {
                    return sha512_224_vec;
                }
                case SHA512_256: {
                    return sha512_256_vec;
                }
                case SHA3_224: {
                    return sha3_224_vec;
                }
                case SHA3_256: {
                    return sha3_256_vec;
                }
                case SHA3_384: {
                    return sha3_384_vec;
                }
                case SHA3_512: {
                    return sha3_512_vec;
                }
                case SHA1_HMAC: {
                    return sha1hmac_vec;
                }
                case SHA224_HMAC: {
                    return sha224hmac_vec;
                }
                case SHA256_HMAC: {
                    return sha256hmac_vec;
                }
                case SHA384_HMAC: {
                    return sha384hmac_vec;
                }
                case SHA512_HMAC: {
                    return sha512hmac_vec;
                }
                case SHA512_224_HMAC: {
                    return sha512_224hmac_vec;
                }
                case SHA512_256_HMAC: {
                    return sha512_256hmac_vec;
                }
                case SHA3_224_HMAC: {
                    return sha3_224hmac_vec;
                }
                case SHA3_256_HMAC: {
                    return sha3_256hmac_vec;
                }
                case SHA3_384_HMAC: {
                    return sha3_384hmac_vec;
                }
                case SHA3_512_HMAC: {
                    return sha3_512hmac_vec;
                }
                case KMAC_128: {
                    return kmac128_vec;
                }
                case KMAC_256: {
                    return kmac256_vec;
                }
            }
            throw new SelfTestExecutor.TestFailedException("unknown PRF");
        }
    }

    public static enum CounterLocation {
        AFTER_ITERATION_DATA(1),
        AFTER_FIXED_INPUT(2),
        BEFORE_ITERATION_DATA(0);

        private final int code;

        private CounterLocation(int n2) {
            this.code = n2;
        }
    }

    public static final class CounterModeFactory
    extends FipsKDFOperatorFactory<CounterModeParameters> {
        @Override
        public KDFCalculator<CounterModeParameters> createKDFCalculator(final CounterModeParameters counterModeParameters) {
            Utils.approvedModeCheck(this.approvedModeOnly, counterModeParameters.getAlgorithm());
            final KDFCounterBytesGenerator kDFCounterBytesGenerator = new CounterModeProvider(counterModeParameters.getAlgorithm()).createEngine();
            kDFCounterBytesGenerator.init(new KDFCounterParameters(counterModeParameters.ki, counterModeParameters.fixedInputPrefix, counterModeParameters.fixedInputSuffix, counterModeParameters.r));
            return new MonitoringKDFCalculator<CounterModeParameters>(this.approvedModeOnly, new BaseKDFCalculator<CounterModeParameters>(){

                @Override
                public CounterModeParameters getParameters() {
                    return counterModeParameters;
                }

                @Override
                public void generateBytes(byte[] byArray, int n, int n2) {
                    kDFCounterBytesGenerator.generateBytes(byArray, n, n2);
                }
            });
        }
    }

    public static final class CounterModeParameters
    extends FipsParameters {
        final int r;
        final byte[] ki;
        final byte[] fixedInputPrefix;
        final byte[] fixedInputSuffix;

        private CounterModeParameters(FipsAlgorithm fipsAlgorithm, int n, byte[] byArray, byte[] byArray2, byte[] byArray3) {
            super(fipsAlgorithm);
            this.r = n;
            this.ki = byArray;
            this.fixedInputPrefix = byArray2;
            this.fixedInputSuffix = byArray3;
        }
    }

    public static final class CounterModeParametersBuilder
    extends FipsParameters {
        private final PRF prf;
        private final int r;

        CounterModeParametersBuilder(FipsAlgorithm fipsAlgorithm) {
            this(fipsAlgorithm, PRF.SHA1_HMAC, 8);
        }

        private CounterModeParametersBuilder(FipsAlgorithm fipsAlgorithm, PRF pRF, int n) {
            super(fipsAlgorithm);
            this.prf = pRF;
            this.r = n;
        }

        public CounterModeParametersBuilder withPRFAndR(PRF pRF, int n) {
            return new CounterModeParametersBuilder(this.getAlgorithm(), pRF, n);
        }

        public CounterModeParameters using(byte[] byArray, byte[] byArray2) {
            return new CounterModeParameters(new FipsAlgorithm(this.getAlgorithm(), (Enum)this.prf), this.r, Arrays.clone(byArray), Arrays.clone(byArray2), null);
        }

        public CounterModeParameters using(byte[] byArray, byte[] byArray2, byte[] byArray3) {
            return new CounterModeParameters(new FipsAlgorithm(this.getAlgorithm(), (Enum)this.prf), this.r, Arrays.clone(byArray), Arrays.clone(byArray2), Arrays.clone(byArray3));
        }

        public CounterModeParameters using(byte[] byArray, boolean bl, byte[] byArray2, byte[] byArray3, int n) {
            return new CounterModeParameters(new FipsAlgorithm(this.getAlgorithm(), (Enum)this.prf), this.r, Arrays.clone(byArray), bl ? FipsKDF.buildFixedInput(byArray2, byArray3, n) : null, bl ? null : FipsKDF.buildFixedInput(byArray2, byArray3, n));
        }
    }

    private static final class CounterModeProvider
    extends FipsEngineProvider<KDFCounterBytesGenerator> {
        private static final byte[] KI = Hex.decode("dff1e50ac0b69dc40f1051d46c2b069c");
        private static final byte[] FIP = new byte[]{1};
        private static final byte[] FIS = new byte[]{2};
        private static final byte[] aes_cmac_vec = Hex.decode("53023e21d00cc5046b15");
        private static final byte[] tripleDes_vec = Hex.decode("d4e062f13b0baefa4943");
        private static final byte[] sha1_vec = Hex.decode("76f881b780e4939d485a");
        private static final byte[] sha224_vec = Hex.decode("66db824abdf2b4e85de2");
        private static final byte[] sha256_vec = Hex.decode("3a46d9be7ab8ea092558");
        private static final byte[] sha384_vec = Hex.decode("d209b2f985ff77301fd1");
        private static final byte[] sha512_vec = Hex.decode("0c51da7c89503acc0050");
        private static final byte[] sha512_224_vec = Hex.decode("86e14446abd90b94c828");
        private static final byte[] sha512_256_vec = Hex.decode("26593c9ef9b39d94bafc");
        private static final byte[] sha3_224_vec = Hex.decode("5d3b03f88c4e34efded6");
        private static final byte[] sha3_256_vec = Hex.decode("24a7d8773d12374c9907");
        private static final byte[] sha3_384_vec = Hex.decode("97896d8bcc5df341c156");
        private static final byte[] sha3_512_vec = Hex.decode("174d4923b0d8bb50c969");
        private final FipsAlgorithm algorithm;

        public CounterModeProvider(FipsAlgorithm fipsAlgorithm) {
            this.algorithm = fipsAlgorithm;
        }

        public CounterModeProvider(PRF pRF) {
            this.algorithm = new FipsAlgorithm(COUNTER_MODE.getAlgorithm(), (Enum)pRF);
        }

        @Override
        public KDFCounterBytesGenerator createEngine() {
            final PRF pRF = (PRF)this.algorithm.basicVariation();
            FipsEngineProvider fipsEngineProvider = FipsKDF.createPRF(pRF);
            return SelfTestExecutor.validate(this.algorithm, new KDFCounterBytesGenerator((Mac)fipsEngineProvider.createEngine()), new VariantKatTest<KDFCounterBytesGenerator>(){

                @Override
                public void evaluate(KDFCounterBytesGenerator kDFCounterBytesGenerator) {
                    kDFCounterBytesGenerator.init(new KDFCounterParameters(KI, FIP, FIS, 8));
                    byte[] byArray = new byte[10];
                    kDFCounterBytesGenerator.generateBytes(byArray, 0, byArray.length);
                    if (!Arrays.areEqual(CounterModeProvider.expectedOutput(pRF), byArray)) {
                        this.fail("failed self test on generation: " + Hex.toHexString(byArray));
                    }
                }
            });
        }

        private static byte[] expectedOutput(PRF pRF) {
            switch (pRF) {
                case AES_CMAC: {
                    return aes_cmac_vec;
                }
                case TRIPLEDES_CMAC: {
                    return tripleDes_vec;
                }
                case SHA1_HMAC: {
                    return sha1_vec;
                }
                case SHA224_HMAC: {
                    return sha224_vec;
                }
                case SHA256_HMAC: {
                    return sha256_vec;
                }
                case SHA384_HMAC: {
                    return sha384_vec;
                }
                case SHA512_HMAC: {
                    return sha512_vec;
                }
                case SHA512_224_HMAC: {
                    return sha512_224_vec;
                }
                case SHA512_256_HMAC: {
                    return sha512_256_vec;
                }
                case SHA3_224_HMAC: {
                    return sha3_224_vec;
                }
                case SHA3_256_HMAC: {
                    return sha3_256_vec;
                }
                case SHA3_384_HMAC: {
                    return sha3_384_vec;
                }
                case SHA3_512_HMAC: {
                    return sha3_512_vec;
                }
            }
            throw new SelfTestExecutor.TestFailedException("unknown PRF");
        }
    }

    public static final class DoublePipelineModeFactory
    extends FipsKDFOperatorFactory<DoublePipelineModeParameters> {
        @Override
        public KDFCalculator<DoublePipelineModeParameters> createKDFCalculator(final DoublePipelineModeParameters doublePipelineModeParameters) {
            Utils.approvedModeCheck(this.approvedModeOnly, doublePipelineModeParameters.getAlgorithm());
            final KDFDoublePipelineIterationBytesGenerator kDFDoublePipelineIterationBytesGenerator = new DoublePipelineModeProvider(doublePipelineModeParameters.getAlgorithm()).createEngine();
            CounterLocation counterLocation = doublePipelineModeParameters.counterLocation;
            int n = doublePipelineModeParameters.r;
            if (n > 0) {
                kDFDoublePipelineIterationBytesGenerator.init(KDFDoublePipelineIterationParameters.createWithCounter(counterLocation.code, doublePipelineModeParameters.ki, doublePipelineModeParameters.fixedInputData, n));
            } else {
                kDFDoublePipelineIterationBytesGenerator.init(KDFDoublePipelineIterationParameters.createWithoutCounter(doublePipelineModeParameters.ki, doublePipelineModeParameters.fixedInputData));
            }
            return new MonitoringKDFCalculator<DoublePipelineModeParameters>(this.approvedModeOnly, new BaseKDFCalculator<DoublePipelineModeParameters>(){

                @Override
                public DoublePipelineModeParameters getParameters() {
                    return doublePipelineModeParameters;
                }

                @Override
                public void generateBytes(byte[] byArray, int n, int n2) {
                    kDFDoublePipelineIterationBytesGenerator.generateBytes(byArray, n, n2);
                }
            });
        }
    }

    public static final class DoublePipelineModeParameters
    extends FipsParameters {
        private final int r;
        private final CounterLocation counterLocation;
        private final byte[] ki;
        private final byte[] fixedInputData;

        private DoublePipelineModeParameters(FipsAlgorithm fipsAlgorithm, int n, CounterLocation counterLocation, byte[] byArray, byte[] byArray2) {
            super(fipsAlgorithm);
            this.r = n;
            this.counterLocation = counterLocation;
            this.ki = byArray;
            this.fixedInputData = byArray2;
        }
    }

    public static final class DoublePipelineModeParametersBuilder
    extends FipsParameters {
        private final PRF prf;
        private final int r;
        private final CounterLocation counterLocation;

        DoublePipelineModeParametersBuilder(FipsAlgorithm fipsAlgorithm) {
            this(fipsAlgorithm, PRF.SHA1_HMAC, -1, null);
        }

        private DoublePipelineModeParametersBuilder(FipsAlgorithm fipsAlgorithm, PRF pRF, int n, CounterLocation counterLocation) {
            super(fipsAlgorithm);
            this.prf = pRF;
            this.r = n;
            this.counterLocation = counterLocation;
        }

        public DoublePipelineModeParametersBuilder withPRF(PRF pRF) {
            return new DoublePipelineModeParametersBuilder(this.getAlgorithm(), pRF, -1, null);
        }

        public DoublePipelineModeParametersBuilder withR(int n) {
            return new DoublePipelineModeParametersBuilder(this.getAlgorithm(), this.prf, n, CounterLocation.AFTER_ITERATION_DATA);
        }

        public DoublePipelineModeParametersBuilder withRAndLocation(int n, CounterLocation counterLocation) {
            return new DoublePipelineModeParametersBuilder(this.getAlgorithm(), this.prf, n, counterLocation);
        }

        public DoublePipelineModeParameters using(byte[] byArray, byte[] byArray2) {
            return new DoublePipelineModeParameters(new FipsAlgorithm(this.getAlgorithm(), (Enum)this.prf), this.r, this.counterLocation, Arrays.clone(byArray), Arrays.clone(byArray2));
        }

        public DoublePipelineModeParameters using(byte[] byArray, byte[] byArray2, byte[] byArray3, int n) {
            return new DoublePipelineModeParameters(new FipsAlgorithm(this.getAlgorithm(), (Enum)this.prf), this.r, this.counterLocation, Arrays.clone(byArray), FipsKDF.buildFixedInput(byArray2, byArray3, n));
        }
    }

    private static final class DoublePipelineModeProvider
    extends FipsEngineProvider<KDFDoublePipelineIterationBytesGenerator> {
        private static final byte[] KI = Hex.decode("dff1e50ac0b69dc40f1051d46c2b069c");
        private static final byte[] FID = new byte[]{2};
        private static final byte[] aes_cmac_vec = Hex.decode("ace76ed103e31681ed03");
        private static final byte[] tripleDes_vec = Hex.decode("41d79be29b5c34ffa40d");
        private static final byte[] sha1_vec = Hex.decode("e5e5666cb2a73b8ce638");
        private static final byte[] sha224_vec = Hex.decode("c4c12b540e51d106abd8");
        private static final byte[] sha256_vec = Hex.decode("b6c232a28b4b450210ee");
        private static final byte[] sha384_vec = Hex.decode("48268b8bf87297a5ce8f");
        private static final byte[] sha512_vec = Hex.decode("52d86063e22a84188285");
        private static final byte[] sha512_224_vec = Hex.decode("d1f521fbc7e736685709");
        private static final byte[] sha512_256_vec = Hex.decode("dca0e9d25e22ca54c0ca");
        private static final byte[] sha3_224_vec = Hex.decode("a54c14ff692e11f63f5f");
        private static final byte[] sha3_256_vec = Hex.decode("f00a6cf634d646672616");
        private static final byte[] sha3_384_vec = Hex.decode("038521245ddd583c8694");
        private static final byte[] sha3_512_vec = Hex.decode("3c45bba3d3184bc876f7");
        private final FipsAlgorithm algorithm;

        public DoublePipelineModeProvider(FipsAlgorithm fipsAlgorithm) {
            this.algorithm = fipsAlgorithm;
        }

        public DoublePipelineModeProvider(PRF pRF) {
            this.algorithm = new FipsAlgorithm(DOUBLE_PIPELINE_ITERATION_MODE.getAlgorithm(), (Enum)pRF);
        }

        @Override
        public KDFDoublePipelineIterationBytesGenerator createEngine() {
            final PRF pRF = (PRF)this.algorithm.basicVariation();
            FipsEngineProvider fipsEngineProvider = FipsKDF.createPRF(pRF);
            return SelfTestExecutor.validate(this.algorithm, new KDFDoublePipelineIterationBytesGenerator((Mac)fipsEngineProvider.createEngine()), new VariantKatTest<KDFDoublePipelineIterationBytesGenerator>(){

                @Override
                public void evaluate(KDFDoublePipelineIterationBytesGenerator kDFDoublePipelineIterationBytesGenerator) {
                    kDFDoublePipelineIterationBytesGenerator.init(KDFDoublePipelineIterationParameters.createWithCounter(0, KI, FID, 8));
                    byte[] byArray = new byte[10];
                    kDFDoublePipelineIterationBytesGenerator.generateBytes(byArray, 0, byArray.length);
                    if (!Arrays.areEqual(DoublePipelineModeProvider.expectedOutput(pRF), byArray)) {
                        this.fail("failed self test on generation: " + Hex.toHexString(byArray));
                    }
                }
            });
        }

        private static byte[] expectedOutput(PRF pRF) {
            switch (pRF) {
                case AES_CMAC: {
                    return aes_cmac_vec;
                }
                case TRIPLEDES_CMAC: {
                    return tripleDes_vec;
                }
                case SHA1_HMAC: {
                    return sha1_vec;
                }
                case SHA224_HMAC: {
                    return sha224_vec;
                }
                case SHA256_HMAC: {
                    return sha256_vec;
                }
                case SHA384_HMAC: {
                    return sha384_vec;
                }
                case SHA512_HMAC: {
                    return sha512_vec;
                }
                case SHA512_224_HMAC: {
                    return sha512_224_vec;
                }
                case SHA512_256_HMAC: {
                    return sha512_256_vec;
                }
                case SHA3_224_HMAC: {
                    return sha3_224_vec;
                }
                case SHA3_256_HMAC: {
                    return sha3_256_vec;
                }
                case SHA3_384_HMAC: {
                    return sha3_384_vec;
                }
                case SHA3_512_HMAC: {
                    return sha3_512_vec;
                }
            }
            throw new SelfTestExecutor.TestFailedException("unknown PRF");
        }
    }

    public static final class FeedbackModeFactory
    extends FipsKDFOperatorFactory<FeedbackModeParameters> {
        @Override
        public KDFCalculator<FeedbackModeParameters> createKDFCalculator(final FeedbackModeParameters feedbackModeParameters) {
            Utils.approvedModeCheck(this.approvedModeOnly, feedbackModeParameters.getAlgorithm());
            final KDFFeedbackBytesGenerator kDFFeedbackBytesGenerator = new FeedbackModeProvider(feedbackModeParameters.getAlgorithm()).createEngine();
            CounterLocation counterLocation = feedbackModeParameters.counterLocation;
            int n = feedbackModeParameters.r;
            if (n > 0) {
                kDFFeedbackBytesGenerator.init(KDFFeedbackParameters.createWithCounter(counterLocation.code, feedbackModeParameters.ki, feedbackModeParameters.iv, feedbackModeParameters.fixedInputData, n));
            } else {
                kDFFeedbackBytesGenerator.init(KDFFeedbackParameters.createWithoutCounter(feedbackModeParameters.ki, feedbackModeParameters.iv, feedbackModeParameters.fixedInputData));
            }
            return new MonitoringKDFCalculator<FeedbackModeParameters>(this.approvedModeOnly, new BaseKDFCalculator<FeedbackModeParameters>(){

                @Override
                public FeedbackModeParameters getParameters() {
                    return feedbackModeParameters;
                }

                @Override
                public void generateBytes(byte[] byArray, int n, int n2) {
                    kDFFeedbackBytesGenerator.generateBytes(byArray, n, n2);
                }
            });
        }
    }

    public static final class FeedbackModeParameters
    extends FipsParameters {
        private final int r;
        private final CounterLocation counterLocation;
        private final byte[] ki;
        private final byte[] iv;
        private final byte[] fixedInputData;

        private FeedbackModeParameters(FipsAlgorithm fipsAlgorithm, int n, CounterLocation counterLocation, byte[] byArray, byte[] byArray2, byte[] byArray3) {
            super(fipsAlgorithm);
            this.r = n;
            this.counterLocation = counterLocation;
            this.ki = byArray;
            this.iv = byArray2;
            this.fixedInputData = byArray3;
        }
    }

    public static final class FeedbackModeParametersBuilder
    extends FipsParameters {
        private final PRF prf;
        private final int r;
        private final CounterLocation counterLocation;

        FeedbackModeParametersBuilder(FipsAlgorithm fipsAlgorithm) {
            this(fipsAlgorithm, PRF.SHA1_HMAC, -1, null);
        }

        private FeedbackModeParametersBuilder(FipsAlgorithm fipsAlgorithm, PRF pRF, int n, CounterLocation counterLocation) {
            super(fipsAlgorithm);
            this.prf = pRF;
            this.r = n;
            this.counterLocation = counterLocation;
        }

        public FeedbackModeParametersBuilder withPRF(PRF pRF) {
            return new FeedbackModeParametersBuilder(this.getAlgorithm(), pRF, -1, null);
        }

        public FeedbackModeParametersBuilder withR(int n) {
            return new FeedbackModeParametersBuilder(this.getAlgorithm(), this.prf, n, CounterLocation.AFTER_ITERATION_DATA);
        }

        public FeedbackModeParametersBuilder withRAndLocation(int n, CounterLocation counterLocation) {
            return new FeedbackModeParametersBuilder(this.getAlgorithm(), this.prf, n, counterLocation);
        }

        public FeedbackModeParameters using(byte[] byArray, byte[] byArray2, byte[] byArray3) {
            return new FeedbackModeParameters(new FipsAlgorithm(this.getAlgorithm(), (Enum)this.prf), this.r, this.counterLocation, Arrays.clone(byArray), Arrays.clone(byArray2), Arrays.clone(byArray3));
        }

        public FeedbackModeParameters using(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, int n) {
            return new FeedbackModeParameters(new FipsAlgorithm(this.getAlgorithm(), (Enum)this.prf), this.r, this.counterLocation, Arrays.clone(byArray), Arrays.clone(byArray2), FipsKDF.buildFixedInput(byArray3, byArray4, n));
        }
    }

    private static final class FeedbackModeProvider
    extends FipsEngineProvider<KDFFeedbackBytesGenerator> {
        private static final byte[] KI = Hex.decode("dff1e50ac0b69dc40f1051d46c2b069c");
        private static final byte[] IV = new byte[]{1};
        private static final byte[] FID = new byte[]{2};
        private static final byte[] aes_cmac_vec = Hex.decode("af7eb5b9a3eb72a1a0cb");
        private static final byte[] tripleDes_vec = Hex.decode("cf65681ac0d3c4f65ce0");
        private static final byte[] sha1_vec = Hex.decode("bfe9d9a6cd8b7befe0fb");
        private static final byte[] sha224_vec = Hex.decode("71d5790138202ab1edc9");
        private static final byte[] sha256_vec = Hex.decode("650d3f9da0f4a8bcf602");
        private static final byte[] sha384_vec = Hex.decode("2a9375ae10e75a9a5ba2");
        private static final byte[] sha512_vec = Hex.decode("e0f3f35c27358f3d0dda");
        private static final byte[] sha512_224_vec = Hex.decode("5fd1372077522505be4a");
        private static final byte[] sha512_256_vec = Hex.decode("ae930bec79b81ee15c67");
        private static final byte[] sha3_224_vec = Hex.decode("7f695648f94b76b419ed");
        private static final byte[] sha3_256_vec = Hex.decode("b056f7a751afc1a47967");
        private static final byte[] sha3_384_vec = Hex.decode("fe02309d3d549e7839af");
        private static final byte[] sha3_512_vec = Hex.decode("e55004746ae4e206d16a");
        private final FipsAlgorithm algorithm;

        public FeedbackModeProvider(FipsAlgorithm fipsAlgorithm) {
            this.algorithm = fipsAlgorithm;
        }

        public FeedbackModeProvider(PRF pRF) {
            this.algorithm = new FipsAlgorithm(FEEDBACK_MODE.getAlgorithm(), (Enum)pRF);
        }

        @Override
        public KDFFeedbackBytesGenerator createEngine() {
            final PRF pRF = (PRF)this.algorithm.basicVariation();
            FipsEngineProvider fipsEngineProvider = FipsKDF.createPRF(pRF);
            return SelfTestExecutor.validate(this.algorithm, new KDFFeedbackBytesGenerator((Mac)fipsEngineProvider.createEngine()), new VariantKatTest<KDFFeedbackBytesGenerator>(){

                @Override
                public void evaluate(KDFFeedbackBytesGenerator kDFFeedbackBytesGenerator) {
                    kDFFeedbackBytesGenerator.init(KDFFeedbackParameters.createWithCounter(2, KI, IV, FID, 8));
                    byte[] byArray = new byte[10];
                    kDFFeedbackBytesGenerator.generateBytes(byArray, 0, byArray.length);
                    if (!Arrays.areEqual(FeedbackModeProvider.expectedOutput(pRF), byArray)) {
                        this.fail("failed self test on generation: " + Hex.toHexString(byArray));
                    }
                }
            });
        }

        private static byte[] expectedOutput(PRF pRF) {
            switch (pRF) {
                case AES_CMAC: {
                    return aes_cmac_vec;
                }
                case TRIPLEDES_CMAC: {
                    return tripleDes_vec;
                }
                case SHA1_HMAC: {
                    return sha1_vec;
                }
                case SHA224_HMAC: {
                    return sha224_vec;
                }
                case SHA256_HMAC: {
                    return sha256_vec;
                }
                case SHA384_HMAC: {
                    return sha384_vec;
                }
                case SHA512_HMAC: {
                    return sha512_vec;
                }
                case SHA512_224_HMAC: {
                    return sha512_224_vec;
                }
                case SHA512_256_HMAC: {
                    return sha512_256_vec;
                }
                case SHA3_224_HMAC: {
                    return sha3_224_vec;
                }
                case SHA3_256_HMAC: {
                    return sha3_256_vec;
                }
                case SHA3_384_HMAC: {
                    return sha3_384_vec;
                }
                case SHA3_512_HMAC: {
                    return sha3_512_vec;
                }
            }
            throw new SelfTestExecutor.TestFailedException("unknown PRF");
        }
    }

    public static final class HKDFKey {
        private final AgreementKDFPRF prf;
        private final byte[] value;

        public HKDFKey(AgreementKDFPRF agreementKDFPRF, byte[] byArray) {
            this.prf = agreementKDFPRF;
            this.value = Arrays.clone(byArray);
        }

        public AgreementKDFPRF getPRF() {
            return this.prf;
        }

        public byte[] getKey() {
            return Arrays.clone(this.value);
        }
    }

    public static final class HKDFKeyBuilder
    extends FipsParameters {
        private final AgreementKDFPRF prf;
        private final byte[] salt;
        private final boolean skipExtract;

        HKDFKeyBuilder(FipsAlgorithm fipsAlgorithm, AgreementKDFPRF agreementKDFPRF, byte[] byArray, boolean bl) {
            super(fipsAlgorithm);
            this.prf = agreementKDFPRF;
            this.salt = byArray;
            this.skipExtract = bl;
        }

        public HKDFKeyBuilder setSkipExtract(boolean bl) {
            return new HKDFKeyBuilder(this.getAlgorithm(), this.prf, this.salt, bl);
        }

        public HKDFKeyBuilder withSalt(byte[] byArray) {
            return new HKDFKeyBuilder(this.getAlgorithm(), this.prf, Arrays.clone(byArray), this.skipExtract);
        }

        public HKDFKeyBuilder withPrf(AgreementKDFPRF agreementKDFPRF) {
            return new HKDFKeyBuilder(this.getAlgorithm(), agreementKDFPRF, Arrays.clone(this.salt), this.skipExtract);
        }

        public HKDFKey build(byte[] byArray) {
            HMac hMac = (HMac)FipsSHS.createHMac(this.prf.algorithm);
            return new HKDFKey(this.prf, new HKDFKeyGenerator(hMac).generate(new HKDFKeyParameters(byArray, this.skipExtract, this.salt)).getKey());
        }
    }

    private static final class HKDFProvider
    extends FipsEngineProvider<HKDFBytesGenerator> {
        private static final byte[] KI = Hex.decode("dff1e50ac0b69dc40f1051d46c2b069c");
        private static final byte[] IV = Hex.decodeStrict("0f0e0d0c0b0a09080706050403020100");
        private static final byte[] sha1hmac_vec = Hex.decode("87794555fda6d7cbabec");
        private static final byte[] sha224hmac_vec = Hex.decode("9c898c64664eafc1ec36");
        private static final byte[] sha256hmac_vec = Hex.decode("1b4beaebaac650b47514");
        private static final byte[] sha384hmac_vec = Hex.decode("b1ede549758863abed34");
        private static final byte[] sha512hmac_vec = Hex.decode("b88c58ec70f7000a0695");
        private static final byte[] sha512_224hmac_vec = Hex.decode("830420fe6ec5d0054997");
        private static final byte[] sha512_256hmac_vec = Hex.decode("f7c42cdacca9a192152b");
        private static final byte[] sha3_224hmac_vec = Hex.decode("0c89dd7c9585d900d7c8");
        private static final byte[] sha3_256hmac_vec = Hex.decode("03d8f28d272a92f79cdc");
        private static final byte[] sha3_384hmac_vec = Hex.decode("513d02750d0ac8f186a5");
        private static final byte[] sha3_512hmac_vec = Hex.decode("fb897e318080fcec9ca2");
        private final FipsAlgorithm algorithm;

        public HKDFProvider(FipsAlgorithm fipsAlgorithm) {
            this.algorithm = fipsAlgorithm;
        }

        public HKDFProvider(AgreementKDFPRF agreementKDFPRF) {
            this(new FipsAlgorithm(HKDF.getAlgorithm(), (Enum)agreementKDFPRF));
        }

        @Override
        public HKDFBytesGenerator createEngine() {
            final AgreementKDFPRF agreementKDFPRF = (AgreementKDFPRF)this.algorithm.basicVariation();
            HMac hMac = (HMac)FipsSHS.createHMac(agreementKDFPRF.algorithm);
            final HKDFBytesGenerator hKDFBytesGenerator = new HKDFBytesGenerator(hMac);
            return SelfTestExecutor.validate(this.algorithm, hKDFBytesGenerator, new VariantKatTest<HKDFBytesGenerator>(){

                @Override
                public void evaluate(HKDFBytesGenerator hKDFBytesGenerator2) {
                    hKDFBytesGenerator.init(new HKDFParameters(new KeyParameterImpl(KI), IV));
                    byte[] byArray = new byte[10];
                    hKDFBytesGenerator.generateBytes(byArray, 0, byArray.length);
                    if (!Arrays.areEqual(HKDFProvider.expectedOutput(agreementKDFPRF), byArray)) {
                        this.fail("failed self test on generation: " + Hex.toHexString(byArray));
                    }
                }
            });
        }

        private static byte[] expectedOutput(AgreementKDFPRF agreementKDFPRF) {
            switch (agreementKDFPRF) {
                case SHA1_HMAC: {
                    return sha1hmac_vec;
                }
                case SHA224_HMAC: {
                    return sha224hmac_vec;
                }
                case SHA256_HMAC: {
                    return sha256hmac_vec;
                }
                case SHA384_HMAC: {
                    return sha384hmac_vec;
                }
                case SHA512_HMAC: {
                    return sha512hmac_vec;
                }
                case SHA512_224_HMAC: {
                    return sha512_224hmac_vec;
                }
                case SHA512_256_HMAC: {
                    return sha512_256hmac_vec;
                }
                case SHA3_224_HMAC: {
                    return sha3_224hmac_vec;
                }
                case SHA3_256_HMAC: {
                    return sha3_256hmac_vec;
                }
                case SHA3_384_HMAC: {
                    return sha3_384hmac_vec;
                }
                case SHA3_512_HMAC: {
                    return sha3_512hmac_vec;
                }
            }
            throw new SelfTestExecutor.TestFailedException("unknown PRF");
        }
    }

    public static final class IKEv2OperatorFactory
    extends FipsKDFOperatorFactory<IKEv2Parameters> {
        @Override
        public KDFCalculator<IKEv2Parameters> createKDFCalculator(final IKEv2Parameters iKEv2Parameters) {
            Utils.approvedModeCheck(this.approvedModeOnly, iKEv2Parameters.getAlgorithm());
            final Mac mac = FipsSHS.createHMac(((IKEv2PRF)iKEv2Parameters.getAlgorithm().basicVariation()).algorithm);
            return new MonitoringKDFCalculator<IKEv2Parameters>(this.approvedModeOnly, new BaseKDFCalculator<IKEv2Parameters>(){

                @Override
                public IKEv2Parameters getParameters() {
                    return iKEv2Parameters;
                }

                @Override
                public void generateBytes(byte[] byArray, int n, int n2) {
                    IKEv2OperatorFactory.prf(mac, iKEv2Parameters, byArray, n, n2);
                }
            });
        }

        private static void prf(Mac mac, IKEv2Parameters iKEv2Parameters, byte[] byArray, int n, int n2) {
            int n3 = mac.getMacSize();
            int n4 = (n2 + n3 - 1) / n3;
            byte[] byArray2 = new byte[n3];
            if (!iKEv2Parameters.isPlus) {
                mac.init(new KeyParameterImpl(iKEv2Parameters.shared));
                mac.update(iKEv2Parameters.keyPad, 0, iKEv2Parameters.keyPad.length);
                mac.doFinal(byArray2, 0);
                System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
            } else {
                mac.init(new KeyParameterImpl(iKEv2Parameters.shared));
                mac.update(iKEv2Parameters.keyPad, 0, iKEv2Parameters.keyPad.length);
                mac.update((byte)1);
                mac.doFinal(byArray2, 0);
                System.arraycopy(byArray2, 0, byArray, n, Math.min(n3, n2));
                for (int i = 1; i < n4; ++i) {
                    mac.update(byArray2, 0, byArray2.length);
                    mac.update(iKEv2Parameters.keyPad, 0, iKEv2Parameters.keyPad.length);
                    mac.update((byte)(i + 1));
                    mac.doFinal(byArray2, 0);
                    System.arraycopy(byArray2, 0, byArray, n + n3 * i, Math.min(n3, byArray.length - n3 * i));
                }
            }
        }
    }

    public static enum IKEv2PRF {
        SHA1(FipsSHS.Algorithm.SHA1_HMAC),
        SHA224(FipsSHS.Algorithm.SHA224_HMAC),
        SHA256(FipsSHS.Algorithm.SHA256_HMAC),
        SHA384(FipsSHS.Algorithm.SHA384_HMAC),
        SHA512(FipsSHS.Algorithm.SHA512_HMAC);

        private final FipsAlgorithm algorithm;

        private IKEv2PRF(FipsAlgorithm fipsAlgorithm) {
            this.algorithm = fipsAlgorithm;
        }

        public FipsAlgorithm getAlgorithm() {
            return this.algorithm;
        }
    }

    public static class IKEv2Parameters
    extends FipsParameters {
        private final boolean isPlus;
        private final byte[] shared;
        private final byte[] keyPad;

        IKEv2Parameters(FipsAlgorithm fipsAlgorithm, boolean bl, byte[] byArray, byte[] byArray2) {
            super(fipsAlgorithm);
            this.isPlus = bl;
            this.shared = byArray;
            this.keyPad = byArray2;
        }
    }

    public static class IKEv2ParametersBuilder
    extends FipsParameters {
        private final IKEv2PRF prf;

        IKEv2ParametersBuilder(FipsAlgorithm fipsAlgorithm, IKEv2PRF iKEv2PRF) {
            super(fipsAlgorithm);
            this.prf = iKEv2PRF;
        }

        public IKEv2ParametersBuilder withPRF(IKEv2PRF iKEv2PRF) {
            return new IKEv2ParametersBuilder(this.getAlgorithm(), iKEv2PRF);
        }

        public IKEv2PRF getPRF() {
            return this.prf;
        }

        public IKEv2Parameters createForPrf(byte[] byArray, byte[] ... byArray2) {
            return new IKEv2Parameters(new FipsAlgorithm(this.getAlgorithm(), (Enum)this.prf), false, Arrays.clone(byArray), Arrays.concatenate(byArray2));
        }

        public IKEv2Parameters createForPrfPlus(byte[] byArray, byte[] ... byArray2) {
            return new IKEv2Parameters(new FipsAlgorithm(this.getAlgorithm(), (Enum)this.prf), true, Arrays.clone(byArray), Arrays.concatenate(byArray2));
        }
    }

    private static class Md5KatTest
    implements BasicKatTest<Digest> {
        private static final byte[] stdShaVector = Strings.toByteArray("abc");
        private static final byte[] kat = Hex.decode("900150983cd24fb0d6963f7d28e17f72");

        private Md5KatTest() {
        }

        @Override
        public boolean hasTestPassed(Digest digest) {
            digest.update(stdShaVector, 0, stdShaVector.length);
            byte[] byArray = new byte[digest.getDigestSize()];
            digest.doFinal(byArray, 0);
            return Arrays.areEqual(byArray, kat);
        }
    }

    private static class MonitoringKDFCalculator<T extends Parameters>
    implements KDFCalculator<T> {
        private final boolean approvedModeOnly;
        private final BaseKDFCalculator<T> kdf;
        private final FipsAlgorithm algorithm;

        MonitoringKDFCalculator(boolean bl, BaseKDFCalculator<T> baseKDFCalculator) {
            this.approvedModeOnly = bl;
            this.kdf = baseKDFCalculator;
            this.algorithm = (FipsAlgorithm)baseKDFCalculator.getParameters().getAlgorithm();
        }

        @Override
        public T getParameters() {
            Utils.approvedModeCheck(this.approvedModeOnly, this.algorithm);
            return this.kdf.getParameters();
        }

        @Override
        public void generateBytes(byte[] byArray) {
            this.generateBytes(byArray, 0, byArray.length);
        }

        @Override
        public void generateBytes(byte[] byArray, int n, int n2) {
            Utils.approvedModeCheck(this.approvedModeOnly, this.algorithm);
            this.kdf.generateBytes(byArray, n, n2);
        }
    }

    public static enum PRF {
        AES_CMAC(FipsAES.CMAC.getAlgorithm()),
        TRIPLEDES_CMAC(FipsTripleDES.CMAC.getAlgorithm()),
        SHA1_HMAC(FipsSHS.Algorithm.SHA1_HMAC),
        SHA224_HMAC(FipsSHS.Algorithm.SHA224_HMAC),
        SHA256_HMAC(FipsSHS.Algorithm.SHA256_HMAC),
        SHA384_HMAC(FipsSHS.Algorithm.SHA384_HMAC),
        SHA512_HMAC(FipsSHS.Algorithm.SHA512_HMAC),
        SHA512_224_HMAC(FipsSHS.Algorithm.SHA512_224_HMAC),
        SHA512_256_HMAC(FipsSHS.Algorithm.SHA512_256_HMAC),
        SHA3_224_HMAC(FipsSHS.Algorithm.SHA3_224_HMAC),
        SHA3_256_HMAC(FipsSHS.Algorithm.SHA3_256_HMAC),
        SHA3_384_HMAC(FipsSHS.Algorithm.SHA3_384_HMAC),
        SHA3_512_HMAC(FipsSHS.Algorithm.SHA3_512_HMAC);

        private final FipsAlgorithm algorithm;

        private PRF(FipsAlgorithm fipsAlgorithm) {
            this.algorithm = fipsAlgorithm;
        }

        public FipsAlgorithm getAlgorithm() {
            return this.algorithm;
        }
    }

    public static final class SNMPOperatorFactory
    extends FipsKDFOperatorFactory<SNMPParameters> {
        @Override
        public KDFCalculator<SNMPParameters> createKDFCalculator(final SNMPParameters sNMPParameters) {
            Utils.approvedModeCheck(this.approvedModeOnly, sNMPParameters.getAlgorithm());
            return new MonitoringKDFCalculator<SNMPParameters>(this.approvedModeOnly, new BaseKDFCalculator<SNMPParameters>(){

                @Override
                public SNMPParameters getParameters() {
                    return sNMPParameters;
                }

                @Override
                public void generateBytes(byte[] byArray, int n, int n2) {
                    this.hash(sNMPParameters, byArray, n);
                }
            });
        }

        private void hash(SNMPParameters sNMPParameters, byte[] byArray, int n) {
            ExtendedDigest extendedDigest = FipsSHS.createDigest(FipsSHS.Algorithm.SHA1);
            byte[] byArray2 = sNMPParameters.getDerivedSecret();
            extendedDigest.update(byArray2, 0, byArray2.length);
            extendedDigest.update(sNMPParameters.engineID, 0, sNMPParameters.engineID.length);
            extendedDigest.update(byArray2, 0, byArray2.length);
            extendedDigest.doFinal(byArray, n);
        }
    }

    public static final class SNMPParameters
    extends FipsParameters {
        private final byte[] derivedSecret;
        private final byte[] engineID;

        SNMPParameters(FipsAlgorithm fipsAlgorithm, byte[] byArray, byte[] byArray2) {
            super(fipsAlgorithm);
            this.derivedSecret = byArray;
            this.engineID = byArray2;
        }

        byte[] getDerivedSecret() {
            return this.derivedSecret;
        }
    }

    public static final class SNMPParametersBuilder
    extends FipsParameters {
        byte[] derivedSecret;

        SNMPParametersBuilder(FipsAlgorithm fipsAlgorithm) {
            super(fipsAlgorithm);
        }

        public SNMPParametersBuilder withPassword(byte[] byArray) {
            if (byArray == null || byArray.length == 0) {
                throw new IllegalArgumentException("password cannot be null or zero length");
            }
            this.derivedSecret = this.deriveSecret(byArray);
            return this;
        }

        public SNMPParametersBuilder withPassword(PasswordConverter passwordConverter, char[] cArray) {
            return this.withPassword(passwordConverter.convert(cArray));
        }

        public SNMPParameters using(byte[] byArray) {
            if (this.derivedSecret == null) {
                throw new IllegalStateException("no password specified");
            }
            return new SNMPParameters(this.getAlgorithm(), this.derivedSecret, byArray);
        }

        private byte[] deriveSecret(byte[] byArray) {
            ExtendedDigest extendedDigest = FipsSHS.createDigest(FipsSHS.Algorithm.SHA1);
            for (int i = 0x100000 / byArray.length; i > 0; --i) {
                extendedDigest.update(byArray, 0, byArray.length);
            }
            byte[] byArray2 = new byte[extendedDigest.getDigestSize()];
            extendedDigest.doFinal(byArray2, 0);
            return byArray2;
        }
    }

    public static final class SRTPOperatorFactory
    extends FipsKDFOperatorFactory<SRTPParameters> {
        @Override
        public KDFCalculator<SRTPParameters> createKDFCalculator(final SRTPParameters sRTPParameters) {
            Utils.approvedModeCheck(this.approvedModeOnly, sRTPParameters.getAlgorithm());
            final SICBlockCipher sICBlockCipher = new SICBlockCipher((BlockCipher)((SRTPPRF)sRTPParameters.getAlgorithm().basicVariation()).engineProvider.createEngine());
            byte[] byArray = new byte[sICBlockCipher.getBlockSize()];
            System.arraycopy(sRTPParameters.masterSalt, 0, byArray, 0, sRTPParameters.masterSalt.length);
            int n = sRTPParameters.masterSalt.length - (sRTPParameters.div.length + 1);
            byArray[n] = (byte)(byArray[n] ^ sRTPParameters.label);
            for (int i = 0; i != sRTPParameters.div.length; ++i) {
                int n2 = i + (sRTPParameters.masterSalt.length - sRTPParameters.div.length);
                byArray[n2] = (byte)(byArray[n2] ^ sRTPParameters.div[i]);
            }
            sICBlockCipher.init(true, new ParametersWithIV(new KeyParameterImpl(sRTPParameters.kMaster), byArray));
            return new MonitoringKDFCalculator<SRTPParameters>(this.approvedModeOnly, new BaseKDFCalculator<SRTPParameters>(){

                @Override
                public SRTPParameters getParameters() {
                    return sRTPParameters;
                }

                @Override
                public void generateBytes(byte[] byArray, int n, int n2) {
                    SRTPOperatorFactory.prf(sICBlockCipher, byArray, n, n2);
                }
            });
        }

        private static void prf(StreamCipher streamCipher, byte[] byArray, int n, int n2) {
            for (int i = n; i != n + n2; ++i) {
                byArray[i] = 0;
            }
            streamCipher.processBytes(byArray, n, n2, byArray, n);
        }
    }

    public static enum SRTPPRF {
        AES_CM(FipsAES.CTR.getAlgorithm(), FipsAES.ENGINE_PROVIDER);

        private final FipsAlgorithm algorithm;
        private final EngineProvider<BlockCipher> engineProvider;

        private SRTPPRF(FipsAlgorithm fipsAlgorithm, EngineProvider<BlockCipher> engineProvider) {
            this.algorithm = fipsAlgorithm;
            this.engineProvider = engineProvider;
        }

        public FipsAlgorithm getAlgorithm() {
            return this.algorithm;
        }
    }

    public static class SRTPParameters
    extends FipsParameters {
        private final byte label;
        private final byte[] kMaster;
        private final byte[] masterSalt;
        private final int kdr;
        private final byte[] index;
        private final byte[] div;

        SRTPParameters(FipsAlgorithm fipsAlgorithm, byte by, byte[] byArray, byte[] byArray2, int n, byte[] byArray3) {
            super(fipsAlgorithm);
            this.label = by;
            this.kMaster = byArray;
            this.masterSalt = byArray2;
            this.kdr = n;
            this.index = byArray3;
            this.div = new byte[byArray3.length];
            if (n != 0) {
                byte[] byArray4;
                if (byArray3.length <= 7) {
                    byte[] byArray5 = new byte[8];
                    System.arraycopy(byArray3, 0, byArray5, byArray5.length - byArray3.length, byArray3.length);
                    long l = Pack.bigEndianToLong(byArray5, 0) / (long)n;
                    byArray4 = Pack.longToBigEndian(l);
                } else {
                    BigInteger bigInteger = new BigInteger(1, byArray3).divide(BigInteger.valueOf(n));
                    byArray4 = bigInteger.toByteArray();
                }
                if (byArray4.length < this.div.length) {
                    System.arraycopy(byArray4, 0, this.div, this.div.length - byArray4.length, byArray4.length);
                } else {
                    System.arraycopy(byArray4, byArray4.length - this.div.length, this.div, 0, this.div.length);
                }
            }
        }

        public SRTPParameters withLabel(byte by) {
            return new SRTPParameters(this.getAlgorithm(), by, this.kMaster, this.masterSalt, this.kdr, this.index);
        }
    }

    public static class SRTPParametersBuilder
    extends FipsParameters {
        private final SRTPPRF prf;

        SRTPParametersBuilder(FipsAlgorithm fipsAlgorithm, SRTPPRF sRTPPRF) {
            super(fipsAlgorithm);
            this.prf = sRTPPRF;
        }

        public SRTPParametersBuilder withPRF(SRTPPRF sRTPPRF) {
            return new SRTPParametersBuilder(this.getAlgorithm(), sRTPPRF);
        }

        public SRTPParameters using(byte[] byArray, byte[] byArray2, int n, byte[] byArray3) {
            return new SRTPParameters(new FipsAlgorithm(this.getAlgorithm(), (Enum)this.prf), 0, Arrays.clone(byArray), Arrays.clone(byArray2), n, Arrays.clone(byArray3));
        }

        public SRTPPRF getPRF() {
            return this.prf;
        }
    }

    public static final class SSHOperatorFactory
    extends FipsKDFOperatorFactory<SSHParameters> {
        @Override
        public KDFCalculator<SSHParameters> createKDFCalculator(final SSHParameters sSHParameters) {
            Utils.approvedModeCheck(this.approvedModeOnly, sSHParameters.getAlgorithm());
            final ExtendedDigest extendedDigest = FipsSHS.createDigest(((SSHPRF)sSHParameters.getAlgorithm().basicVariation()).algorithm);
            return new MonitoringKDFCalculator<SSHParameters>(this.approvedModeOnly, new BaseKDFCalculator<SSHParameters>(){

                @Override
                public SSHParameters getParameters() {
                    return sSHParameters;
                }

                @Override
                public void generateBytes(byte[] byArray, int n, int n2) {
                    SSHOperatorFactory.hash(extendedDigest, sSHParameters, byArray, n, n2);
                }
            });
        }

        private static void hash(Digest digest, SSHParameters sSHParameters, byte[] byArray, int n, int n2) {
            int n3 = digest.getDigestSize();
            int n4 = (n2 + n3 - 1) / n3;
            byte[] byArray2 = new byte[digest.getDigestSize()];
            digest.update(sSHParameters.sharedKey, 0, sSHParameters.sharedKey.length);
            digest.update(sSHParameters.exchangeHash, 0, sSHParameters.exchangeHash.length);
            digest.update((byte)sSHParameters.x);
            digest.update(sSHParameters.sessionID, 0, sSHParameters.sessionID.length);
            digest.doFinal(byArray2, 0);
            System.arraycopy(byArray2, 0, byArray, n, Math.min(n3, n2));
            for (int i = 1; i < n4; ++i) {
                digest.update(sSHParameters.sharedKey, 0, sSHParameters.sharedKey.length);
                digest.update(sSHParameters.exchangeHash, 0, sSHParameters.exchangeHash.length);
                digest.update(byArray, n, n3 * i);
                digest.doFinal(byArray2, 0);
                System.arraycopy(byArray2, 0, byArray, n + n3 * i, Math.min(n3, byArray.length - n3 * i));
            }
        }
    }

    public static enum SSHPRF {
        SHA1(FipsSHS.Algorithm.SHA1),
        SHA224(FipsSHS.Algorithm.SHA224),
        SHA256(FipsSHS.Algorithm.SHA256),
        SHA384(FipsSHS.Algorithm.SHA384),
        SHA512(FipsSHS.Algorithm.SHA512);

        private final FipsAlgorithm algorithm;

        private SSHPRF(FipsAlgorithm fipsAlgorithm) {
            this.algorithm = fipsAlgorithm;
        }

        public FipsAlgorithm getAlgorithm() {
            return this.algorithm;
        }
    }

    public static final class SSHParameters
    extends FipsParameters {
        private final char x;
        private final byte[] sharedKey;
        private final byte[] exchangeHash;
        private final byte[] sessionID;

        SSHParameters(FipsAlgorithm fipsAlgorithm, char c, byte[] byArray, byte[] byArray2, byte[] byArray3) {
            super(fipsAlgorithm);
            this.x = c;
            this.sharedKey = byArray;
            this.exchangeHash = byArray2;
            this.sessionID = byArray3;
        }

        SSHParameters(SSHParameters sSHParameters, SSHPRF sSHPRF) {
            this(new FipsAlgorithm(sSHParameters.getAlgorithm(), (Enum)sSHPRF), sSHParameters.x, sSHParameters.sharedKey, sSHParameters.exchangeHash, sSHParameters.sessionID);
        }

        public SSHParameters withX(char c) {
            return new SSHParameters(this.getAlgorithm(), c, this.sharedKey, this.exchangeHash, this.sessionID);
        }
    }

    public static final class SSHParametersBuilder
    extends FipsParameters {
        SSHPRF prf;

        SSHParametersBuilder(FipsAlgorithm fipsAlgorithm, SSHPRF sSHPRF) {
            super(fipsAlgorithm);
            this.prf = sSHPRF;
        }

        public SSHParametersBuilder withPRF(SSHPRF sSHPRF) {
            return new SSHParametersBuilder(this.getAlgorithm(), sSHPRF);
        }

        public SSHParameters using(char c, byte[] byArray, byte[] byArray2, byte[] byArray3) {
            return new SSHParameters(new FipsAlgorithm(this.getAlgorithm(), (Enum)this.prf), c, Arrays.clone(byArray), Arrays.clone(byArray2), Arrays.clone(byArray3));
        }

        public SSHPRF getPRF() {
            return this.prf;
        }
    }

    public static final class TLSOperatorFactory
    extends FipsKDFOperatorFactory<TLSParameters> {
        @Override
        public KDFCalculator<TLSParameters> createKDFCalculator(final TLSParameters tLSParameters) {
            final TLSPRF tLSPRF = (TLSPRF)tLSParameters.getAlgorithm().basicVariation();
            Utils.approvedModeCheck(this.approvedModeOnly, tLSParameters.getAlgorithm());
            if (tLSPRF == null) {
                final HMac hMac = new HMac((Digest)md5Provider.createEngine());
                final Mac mac = FipsSHS.createHMac(FipsSHS.Algorithm.SHA1_HMAC);
                return new MonitoringKDFCalculator<TLSParameters>(this.approvedModeOnly, new BaseKDFCalculator<TLSParameters>(){

                    @Override
                    public TLSParameters getParameters() {
                        return tLSParameters;
                    }

                    @Override
                    public void generateBytes(byte[] byArray, int n, int n2) {
                        byte[] byArray2 = FipsKDF.PRF_legacy(tLSParameters, tLSParameters.secret, tLSParameters.label, n2, hMac, mac);
                        System.arraycopy(byArray2, 0, byArray, n, n2);
                    }
                });
            }
            return new MonitoringKDFCalculator<TLSParameters>(this.approvedModeOnly, new BaseKDFCalculator<TLSParameters>(){

                @Override
                public TLSParameters getParameters() {
                    return tLSParameters;
                }

                @Override
                public void generateBytes(byte[] byArray, int n, int n2) {
                    byte[] byArray2 = FipsKDF.PRF(tLSParameters, tLSPRF, tLSParameters.secret, tLSParameters.label, n2);
                    System.arraycopy(byArray2, 0, byArray, n, n2);
                }
            });
        }
    }

    public static enum TLSPRF {
        SHA256_HMAC(FipsSHS.Algorithm.SHA256_HMAC),
        SHA384_HMAC(FipsSHS.Algorithm.SHA384_HMAC),
        SHA512_HMAC(FipsSHS.Algorithm.SHA512_HMAC);

        private final FipsAlgorithm algorithm;

        private TLSPRF(FipsAlgorithm fipsAlgorithm) {
            this.algorithm = fipsAlgorithm;
        }

        public FipsAlgorithm getAlgorithm() {
            return this.algorithm;
        }
    }

    public static final class TLSParameters
    extends FipsParameters {
        private final byte[] secret;
        private final String label;
        private final byte[] seed;

        TLSParameters(FipsAlgorithm fipsAlgorithm, byte[] byArray, String string, byte[] byArray2) {
            super(fipsAlgorithm);
            this.secret = byArray;
            this.label = string;
            this.seed = byArray2;
        }
    }

    public static class TLSParametersBuilder
    extends FipsParameters {
        TLSParametersBuilder(FipsAlgorithm fipsAlgorithm) {
            super(fipsAlgorithm);
        }

        public TLSParameters using(byte[] byArray, String string, byte[] ... byArray2) {
            return new TLSParameters(this.getAlgorithm(), Arrays.clone(byArray), string, Arrays.concatenate(byArray2));
        }
    }

    public static final class TLSParametersWithPRFBuilder
    extends TLSParametersBuilder {
        private final TLSPRF prf;

        TLSParametersWithPRFBuilder(FipsAlgorithm fipsAlgorithm, TLSPRF tLSPRF) {
            super(fipsAlgorithm);
            this.prf = tLSPRF;
        }

        public TLSParametersWithPRFBuilder withPRF(TLSPRF tLSPRF) {
            return new TLSParametersWithPRFBuilder(this.getAlgorithm(), tLSPRF);
        }

        @Override
        public TLSParameters using(byte[] byArray, String string, byte[] ... byArray2) {
            return new TLSParameters(new FipsAlgorithm(this.getAlgorithm(), (Enum)this.prf), Arrays.clone(byArray), string, Arrays.concatenate(byArray2));
        }
    }

    public static final class TLSStage {
        public static final String MASTER_SECRET = "master secret";
        public static final String KEY_EXPANSION = "key expansion";
        public static final String EXTENDED_MASTER_SECRET = "extended master secret";

        private TLSStage() {
        }
    }

    public static final class TwoStepKDFKey {
        private final PRF prf;
        private final byte[] value;

        public TwoStepKDFKey(PRF pRF, byte[] byArray) {
            this.prf = pRF;
            this.value = Arrays.clone(byArray);
        }

        public PRF getPRF() {
            return this.prf;
        }

        public byte[] getKey() {
            return Arrays.clone(this.value);
        }
    }

    public static final class TwoStepKDFKeyBuilder
    extends FipsParameters {
        private final PRF prf;
        private final byte[] salt;

        TwoStepKDFKeyBuilder(FipsAlgorithm fipsAlgorithm, PRF pRF, byte[] byArray) {
            super(fipsAlgorithm);
            this.prf = pRF;
            this.salt = byArray;
        }

        public PRF getPRF() {
            return this.prf;
        }

        public TwoStepKDFKeyBuilder withSalt(byte[] byArray) {
            return new TwoStepKDFKeyBuilder(this.getAlgorithm(), this.prf, Arrays.clone(byArray));
        }

        public TwoStepKDFKeyBuilder withPRF(PRF pRF) {
            return new TwoStepKDFKeyBuilder(this.getAlgorithm(), pRF, Arrays.clone(this.salt));
        }

        public TwoStepKDFKey build(byte[] byArray) {
            Mac mac = (Mac)FipsKDF.createPRF(this.prf).createEngine();
            return new TwoStepKDFKey(this.prf, new TwoStepKeyGenerator(mac).generate(new HKDFKeyParameters(byArray, false, this.salt)).getKey());
        }
    }

    private static final class X963KDFProvider
    extends FipsEngineProvider<KDF2BytesGenerator> {
        private static final byte[] KI = Hex.decode("dff1e50ac0b69dc40f1051d46c2b069c");
        private static final byte[] IV = Hex.decodeStrict("0f0e0d0c0b0a09080706050403020100");
        private static final byte[] sha1_vec = Hex.decode("06f2fcab86efc5f48a02");
        private static final byte[] sha224_vec = Hex.decode("c54a4802590716162eb6");
        private static final byte[] sha256_vec = Hex.decode("24673d707fef10b05bc2");
        private static final byte[] sha384_vec = Hex.decode("f699f47d34dfe7f36864");
        private static final byte[] sha512_vec = Hex.decode("33aece95a69d41e6cb18");
        private static final byte[] sha512_224_vec = Hex.decode("75acc6bd45cfe98c1c0b");
        private static final byte[] sha512_256_vec = Hex.decode("575686a5196013a515d3");
        private static final byte[] sha3_224_vec = Hex.decode("3dd03d8806fe9b224c98");
        private static final byte[] sha3_256_vec = Hex.decode("c20a575144b9fbbe90b6");
        private static final byte[] sha3_384_vec = Hex.decode("3e63b227d8c34d5aba22");
        private static final byte[] sha3_512_vec = Hex.decode("02e43940664e01e02eda");
        private final FipsAlgorithm algorithm;

        public X963KDFProvider(FipsAlgorithm fipsAlgorithm) {
            this.algorithm = fipsAlgorithm;
        }

        public X963KDFProvider(AgreementKDFPRF agreementKDFPRF) {
            this(new FipsAlgorithm(X963.getAlgorithm(), (Enum)agreementKDFPRF));
        }

        @Override
        public KDF2BytesGenerator createEngine() {
            final AgreementKDFPRF agreementKDFPRF = (AgreementKDFPRF)this.algorithm.basicVariation();
            ExtendedDigest extendedDigest = FipsSHS.createDigest(agreementKDFPRF.algorithm);
            final KDF2BytesGenerator kDF2BytesGenerator = new KDF2BytesGenerator(extendedDigest);
            return SelfTestExecutor.validate(this.algorithm, kDF2BytesGenerator, new VariantKatTest<KDF2BytesGenerator>(){

                @Override
                public void evaluate(KDF2BytesGenerator kDF2BytesGenerator2) {
                    kDF2BytesGenerator.init(new KDFParameters(KI, IV));
                    byte[] byArray = new byte[10];
                    kDF2BytesGenerator.generateBytes(byArray, 0, byArray.length);
                    if (!Arrays.areEqual(X963KDFProvider.expectedOutput(agreementKDFPRF), byArray)) {
                        this.fail("failed self test on generation: " + Hex.toHexString(byArray));
                    }
                }
            });
        }

        private static byte[] expectedOutput(AgreementKDFPRF agreementKDFPRF) {
            switch (agreementKDFPRF) {
                case SHA1: {
                    return sha1_vec;
                }
                case SHA224: {
                    return sha224_vec;
                }
                case SHA256: {
                    return sha256_vec;
                }
                case SHA384: {
                    return sha384_vec;
                }
                case SHA512: {
                    return sha512_vec;
                }
                case SHA512_224: {
                    return sha512_224_vec;
                }
                case SHA512_256: {
                    return sha512_256_vec;
                }
                case SHA3_224: {
                    return sha3_224_vec;
                }
                case SHA3_256: {
                    return sha3_256_vec;
                }
                case SHA3_384: {
                    return sha3_384_vec;
                }
                case SHA3_512: {
                    return sha3_512_vec;
                }
            }
            throw new SelfTestExecutor.TestFailedException("unknown PRF");
        }
    }
}

