/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.disparity.block.select;

import boofcv.alg.disparity.block.score.DisparitySparseRectifiedScoreBM;
import boofcv.alg.disparity.block.select.SelectSparseCorrelationWithChecksWta_F32;

public class SelectSparseCorrelationSubpixel {

    public static class F32
    extends SelectSparseCorrelationWithChecksWta_F32 {
        public F32(double texture, int tolRightToLeft) {
            super(texture, tolRightToLeft);
        }

        @Override
        public boolean select(DisparitySparseRectifiedScoreBM<float[], ?> scorer, int x, int y) {
            if (super.select(scorer, x, y)) {
                int disparityRange = scorer.getLocalRangeLtoR();
                float[] scores = scorer.getScoreLtoR();
                int disparityValue = (int)this.disparity;
                if (disparityValue == 0 || disparityValue == disparityRange - 1) {
                    return true;
                }
                float c0 = scores[disparityValue - 1];
                float c1 = scores[disparityValue];
                float c2 = scores[disparityValue + 1];
                float offset = (c0 - c2) / (2.0f * (c0 - 2.0f * c1 + c2));
                this.disparity += (double)offset;
                return true;
            }
            return false;
        }
    }
}

