/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.disparity.block;

import boofcv.alg.disparity.block.BlockRowScore;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayI;
import boofcv.struct.image.GrayS16;
import boofcv.struct.image.GrayU16;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageType;

public interface BlockRowScoreSad {

    public static class F32
    extends SadArrayF32 {
        @Override
        public void score(float[] leftRow, float[] rightRow, int indexLeft, int indexRight, int offset, int length, float[] elementScore) {
            for (int i = 0; i < length; ++i) {
                float difference = leftRow[indexLeft++] - rightRow[indexRight++];
                elementScore[offset + i] = Math.abs(difference);
            }
        }

        @Override
        public ImageType<GrayF32> getImageType() {
            return ImageType.SB_F32;
        }
    }

    public static class S16
    extends SadArrayS32<GrayS16, short[]> {
        public S16() {
            super(-1);
        }

        @Override
        public void score(short[] leftRow, short[] rightRow, int indexLeft, int indexRight, int offset, int length, int[] elementScore) {
            for (int rCol = 0; rCol < length; ++rCol) {
                int difference = leftRow[indexLeft++] - rightRow[indexRight++];
                elementScore[offset + rCol] = Math.abs(difference);
            }
        }

        @Override
        public ImageType<GrayS16> getImageType() {
            return ImageType.SB_S16;
        }
    }

    public static class U16
    extends SadArrayS32<GrayU16, short[]> {
        public U16() {
            super(-1);
        }

        @Override
        public void score(short[] leftRow, short[] rightRow, int indexLeft, int indexRight, int offset, int length, int[] elementScore) {
            for (int i = 0; i < length; ++i) {
                int difference = (leftRow[indexLeft++] & 0xFFFF) - (rightRow[indexRight++] & 0xFFFF);
                elementScore[offset + i] = Math.abs(difference);
            }
        }

        @Override
        public ImageType<GrayU16> getImageType() {
            return ImageType.SB_U16;
        }
    }

    public static class U8
    extends SadArrayS32<GrayU8, byte[]> {
        public U8() {
            super(255);
        }

        @Override
        public void score(byte[] leftRow, byte[] rightRow, int indexLeft, int indexRight, int offset, int length, int[] elementScore) {
            for (int i = 0; i < length; ++i) {
                int difference = (leftRow[indexLeft++] & 0xFF) - (rightRow[indexRight++] & 0xFF);
                elementScore[offset + i] = Math.abs(difference);
            }
        }

        @Override
        public ImageType<GrayU8> getImageType() {
            return ImageType.SB_U8;
        }
    }

    public static abstract class SadArrayF32
    extends BlockRowScore.ArrayS32_BF32 {
        @Override
        public boolean isRequireNormalize() {
            return false;
        }

        @Override
        public int getMaxPerPixelError() {
            throw new RuntimeException("Not supported for float images");
        }
    }

    public static abstract class SadArrayS32<T extends GrayI<T>, ImageData>
    extends BlockRowScore.ArrayS32_BS32<T, ImageData> {
        SadArrayS32(int maxPerPixel) {
            super(maxPerPixel);
        }

        @Override
        public boolean isRequireNormalize() {
            return false;
        }
    }
}

