/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.params;

import com.google.common.base.Preconditions;
import java.math.BigInteger;
import org.bitcoinj.core.Block;
import org.bitcoinj.params.AbstractBitcoinNetParams;

public class RegTestParams
extends AbstractBitcoinNetParams {
    private static final BigInteger MAX_TARGET = new BigInteger("7fffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff", 16);
    private static Block genesis;
    private static RegTestParams instance;

    public RegTestParams() {
        this.packetMagic = 4206867930L;
        this.addressHeader = 111;
        this.p2shHeader = 196;
        this.targetTimespan = 1209600;
        this.dumpedPrivateKeyHeader = 239;
        this.segwitAddressHrp = "bcrt";
        this.genesisBlock.setTime(1296688602L);
        this.genesisBlock.setDifficultyTarget(487063544L);
        this.genesisBlock.setNonce(384568319L);
        this.spendableCoinbaseDepth = 100;
        String genesisHash = this.genesisBlock.getHashAsString();
        Preconditions.checkState((boolean)genesisHash.equals("00000007199508e34a9ff81e6ec0c477a4cccff2a4767a8eee39c11db367b008"));
        this.dnsSeeds = null;
        this.addrSeeds = null;
        this.bip32HeaderP2PKHpub = 70617039;
        this.bip32HeaderP2PKHpriv = 70615956;
        this.bip32HeaderP2WPKHpub = 73342198;
        this.bip32HeaderP2WPKHpriv = 73341116;
        this.interval = Integer.MAX_VALUE;
        this.maxTarget = MAX_TARGET;
        this.subsidyDecreaseBlockCount = 150;
        this.port = 18444;
        this.id = "org.bitcoin.regtest";
        this.majorityEnforceBlockUpgrade = 750;
        this.majorityRejectBlockOutdated = 950;
        this.majorityWindow = 1000;
    }

    @Override
    public boolean allowEmptyPeerChain() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Block getGenesisBlock() {
        Class<RegTestParams> clazz = RegTestParams.class;
        synchronized (RegTestParams.class) {
            if (genesis == null) {
                genesis = super.getGenesisBlock();
                genesis.setNonce(2L);
                genesis.setDifficultyTarget(545259519L);
                genesis.setTime(1296688602L);
                Preconditions.checkState((boolean)genesis.getHashAsString().toLowerCase().equals("0f9188f13cb7b2c71f2a335e3a4fc328bf5beb436012afca590b1a11466e2206"));
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return genesis;
        }
    }

    public static synchronized RegTestParams get() {
        if (instance == null) {
            instance = new RegTestParams();
        }
        return instance;
    }

    @Override
    public String getPaymentProtocolId() {
        return "regtest";
    }
}

