/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.net;

import com.google.common.base.Throwables;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.concurrent.Executor;
import org.bitcoinj.net.AbstractTimeoutHandler;
import org.bitcoinj.net.MessageWriteTarget;
import org.bitcoinj.net.NioClientManager;
import org.bitcoinj.net.StreamConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NioClient
implements MessageWriteTarget {
    private static final Logger log = LoggerFactory.getLogger(NioClient.class);
    private final Handler handler;
    private final NioClientManager manager = new NioClientManager();

    public NioClient(final SocketAddress serverAddress, StreamConnection parser, int connectTimeoutMillis) throws IOException {
        this.manager.startAsync();
        this.manager.awaitRunning();
        this.handler = new Handler(parser, connectTimeoutMillis);
        Futures.addCallback(this.manager.openConnection(serverAddress, this.handler), (FutureCallback)new FutureCallback<SocketAddress>(){

            public void onSuccess(SocketAddress result) {
            }

            public void onFailure(Throwable t) {
                log.error("Connect to {} failed: {}", (Object)serverAddress, (Object)Throwables.getRootCause((Throwable)t));
            }
        }, (Executor)MoreExecutors.directExecutor());
    }

    @Override
    public void closeConnection() {
        this.handler.writeTarget.closeConnection();
    }

    @Override
    public synchronized void writeBytes(byte[] message) throws IOException {
        this.handler.writeTarget.writeBytes(message);
    }

    class Handler
    extends AbstractTimeoutHandler
    implements StreamConnection {
        private final StreamConnection upstreamConnection;
        private MessageWriteTarget writeTarget;
        private boolean closeOnOpen = false;
        private boolean closeCalled = false;

        Handler(StreamConnection upstreamConnection, int connectTimeoutMillis) {
            this.upstreamConnection = upstreamConnection;
            this.setSocketTimeout(connectTimeoutMillis);
            this.setTimeoutEnabled(true);
        }

        @Override
        protected synchronized void timeoutOccurred() {
            this.closeOnOpen = true;
            this.connectionClosed();
        }

        @Override
        public synchronized void connectionClosed() {
            NioClient.this.manager.stopAsync();
            if (!this.closeCalled) {
                this.closeCalled = true;
                this.upstreamConnection.connectionClosed();
            }
        }

        @Override
        public synchronized void connectionOpened() {
            if (!this.closeOnOpen) {
                this.upstreamConnection.connectionOpened();
            }
        }

        @Override
        public int receiveBytes(ByteBuffer buff) throws Exception {
            return this.upstreamConnection.receiveBytes(buff);
        }

        @Override
        public synchronized void setWriteTarget(MessageWriteTarget writeTarget) {
            if (this.closeOnOpen) {
                writeTarget.closeConnection();
            } else {
                this.setTimeoutEnabled(false);
                this.writeTarget = writeTarget;
                this.upstreamConnection.setWriteTarget(writeTarget);
            }
        }

        @Override
        public int getMaxMessageSize() {
            return this.upstreamConnection.getMaxMessageSize();
        }
    }
}

